/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.trambda.bc.mth;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import xyz.cofe.trambda.bc.bm.BootstrapMethArg;
import xyz.cofe.trambda.bc.bm.DoubleArg;
import xyz.cofe.trambda.bc.bm.FloatArg;
import xyz.cofe.trambda.bc.bm.HandleArg;
import xyz.cofe.trambda.bc.bm.IntArg;
import xyz.cofe.trambda.bc.bm.LongArg;
import xyz.cofe.trambda.bc.bm.MHandle;
import xyz.cofe.trambda.bc.bm.StringArg;
import xyz.cofe.trambda.bc.bm.TypeArg;
import xyz.cofe.trambda.bc.mth.MAbstractBC;
import xyz.cofe.trambda.bc.mth.MethodWriter;
import xyz.cofe.trambda.bc.mth.MethodWriterCtx;

public class MInvokeDynamicInsn
extends MAbstractBC
implements MethodWriter {
    private static final long serialVersionUID = 1L;
    private String name;
    private String descriptor;
    private MHandle bootstrapMethodHandle;
    private List<BootstrapMethArg> bootstrapMethodArguments;

    public MInvokeDynamicInsn() {
    }

    public MInvokeDynamicInsn(String name, String descriptor, Handle handle, Object[] args) {
        this.name = name;
        this.descriptor = descriptor;
        if (handle != null) {
            this.bootstrapMethodHandle = new MHandle(handle);
        }
        if (args != null) {
            this.bootstrapMethodArguments = new ArrayList<BootstrapMethArg>();
            for (Object a : args) {
                if (a instanceof Integer) {
                    this.bootstrapMethodArguments.add(new IntArg((Integer)a));
                    continue;
                }
                if (a instanceof Float) {
                    this.bootstrapMethodArguments.add(new FloatArg((Float)a));
                    continue;
                }
                if (a instanceof Long) {
                    this.bootstrapMethodArguments.add(new LongArg((Long)a));
                    continue;
                }
                if (a instanceof Double) {
                    this.bootstrapMethodArguments.add(new DoubleArg((Double)a));
                    continue;
                }
                if (a instanceof String) {
                    this.bootstrapMethodArguments.add(new StringArg((String)a));
                    continue;
                }
                if (a instanceof Type) {
                    this.bootstrapMethodArguments.add(new TypeArg(((Type)a).toString()));
                    continue;
                }
                if (a instanceof Handle) {
                    this.bootstrapMethodArguments.add(new HandleArg(new MHandle((Handle)a)));
                    continue;
                }
                throw new IllegalArgumentException("unsupported bootstrapMethodArgument " + a);
            }
        }
    }

    public MInvokeDynamicInsn(MInvokeDynamicInsn sample) {
        List<BootstrapMethArg> l;
        if (sample == null) {
            throw new IllegalArgumentException("sample==null");
        }
        this.name = sample.getName();
        this.descriptor = sample.getDescriptor();
        MHandle bmh = sample.bootstrapMethodHandle;
        if (bmh != null) {
            this.bootstrapMethodHandle = bmh.clone();
        }
        if ((l = sample.bootstrapMethodArguments) != null) {
            this.bootstrapMethodArguments = new ArrayList<BootstrapMethArg>(l);
        }
    }

    @Override
    public MInvokeDynamicInsn clone() {
        return new MInvokeDynamicInsn(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(String descriptor) {
        this.descriptor = descriptor;
    }

    public MHandle getBootstrapMethodHandle() {
        return this.bootstrapMethodHandle;
    }

    public void setBootstrapMethodHandle(MHandle bootstrapMethodHandle) {
        this.bootstrapMethodHandle = bootstrapMethodHandle;
    }

    public List<BootstrapMethArg> getBootstrapMethodArguments() {
        if (this.bootstrapMethodArguments == null) {
            this.bootstrapMethodArguments = new ArrayList<BootstrapMethArg>();
        }
        return this.bootstrapMethodArguments;
    }

    public void setBootstrapMethodArguments(List<BootstrapMethArg> bootstrapMethodArguments) {
        this.bootstrapMethodArguments = bootstrapMethodArguments;
    }

    public String toString() {
        return MInvokeDynamicInsn.class.getSimpleName() + " name=" + this.name + " descriptor=" + this.descriptor + " bootstrapMethodHandle=" + this.bootstrapMethodHandle + " args=" + this.bootstrapMethodArguments;
    }

    @Override
    public void write(MethodVisitor v, MethodWriterCtx ctx) {
        if (v == null) {
            throw new IllegalArgumentException("v==null");
        }
        if (ctx == null) {
            throw new IllegalArgumentException("ctx==null");
        }
        MHandle bmh = this.getBootstrapMethodHandle();
        if (bmh == null) {
            throw new IllegalStateException("getBootstrapMethodHandle() return null");
        }
        Handle hdl = new Handle(bmh.getTag(), bmh.getOwner(), bmh.getName(), bmh.getDesc(), bmh.isIface());
        List<BootstrapMethArg> bma = this.getBootstrapMethodArguments();
        if (bma == null) {
            throw new IllegalStateException("getBootstrapMethodArguments() return null");
        }
        Object[] args = new Object[bma.size()];
        for (int ai = 0; ai < args.length; ++ai) {
            Object arg = null;
            BootstrapMethArg sarg = bma.get(ai);
            if (sarg instanceof IntArg) {
                arg = this.build((IntArg)sarg);
            } else if (sarg instanceof StringArg) {
                arg = this.build((StringArg)sarg);
            } else if (sarg instanceof FloatArg) {
                arg = this.build((FloatArg)sarg);
            } else if (sarg instanceof LongArg) {
                arg = this.build((LongArg)sarg);
            } else if (sarg instanceof DoubleArg) {
                arg = this.build((DoubleArg)sarg);
            } else if (sarg instanceof TypeArg) {
                arg = this.build((TypeArg)sarg);
            } else if (sarg instanceof HandleArg) {
                arg = this.build((HandleArg)sarg, hdl, ctx);
            } else {
                throw new UnsupportedOperationException("can't feetch BootstrapMethodArgument from " + sarg);
            }
            args[ai] = arg;
        }
        v.visitInvokeDynamicInsn(this.getName(), this.getDescriptor(), hdl, args);
    }

    protected Object build(IntArg arg) {
        return arg.getValue();
    }

    protected Object build(LongArg arg) {
        return arg.getValue();
    }

    protected Object build(FloatArg arg) {
        return arg.getValue();
    }

    protected Object build(DoubleArg arg) {
        return arg.getValue();
    }

    protected Object build(StringArg arg) {
        return arg.getValue();
    }

    protected Object build(TypeArg arg) {
        return Type.getType((String)arg.getType());
    }

    protected Object build(HandleArg arg, Handle bm, MethodWriterCtx ctx) {
        MHandle hdl = arg.getHandle();
        if (hdl == null) {
            throw new IllegalArgumentException("target handle is null");
        }
        return ctx.bootstrapArgument(hdl, bm);
    }
}

