/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.trambda.bc.fld;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.FieldVisitor;
import xyz.cofe.iter.Eterable;
import xyz.cofe.trambda.bc.ByteCode;
import xyz.cofe.trambda.bc.ann.AnnotationByteCode;
import xyz.cofe.trambda.bc.ann.AnnotationDef;
import xyz.cofe.trambda.bc.ann.GetAnnotationByteCodes;
import xyz.cofe.trambda.bc.fld.FieldByteCode;

public class FAnnotation
implements FieldByteCode,
AnnotationDef,
GetAnnotationByteCodes {
    private static final long serialVersionUID = 1L;
    protected String descriptor;
    protected boolean visible;
    protected List<AnnotationByteCode> annotationByteCodes;

    public FAnnotation() {
    }

    public FAnnotation(String descriptor, boolean visible) {
        this.descriptor = descriptor;
        this.visible = visible;
    }

    public FAnnotation(FAnnotation sample) {
        if (sample == null) {
            throw new IllegalArgumentException("sample==null");
        }
        this.descriptor = sample.getDescriptor();
        this.visible = sample.isVisible();
        if (sample.annotationByteCodes != null) {
            this.annotationByteCodes = new ArrayList<AnnotationByteCode>();
            for (AnnotationByteCode b : sample.annotationByteCodes) {
                if (b != null) {
                    this.annotationByteCodes.add(b.clone());
                    continue;
                }
                this.annotationByteCodes.add(null);
            }
        }
    }

    @Override
    public FAnnotation clone() {
        return new FAnnotation(this);
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(String descriptor) {
        this.descriptor = descriptor;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public String toString() {
        return FAnnotation.class.getSimpleName() + " descriptor=" + this.descriptor + " visible=" + this.visible;
    }

    @Override
    public List<AnnotationByteCode> getAnnotationByteCodes() {
        if (this.annotationByteCodes == null) {
            this.annotationByteCodes = new ArrayList<AnnotationByteCode>();
        }
        return this.annotationByteCodes;
    }

    public void setAnnotationByteCodes(List<AnnotationByteCode> byteCodes) {
        this.annotationByteCodes = byteCodes;
    }

    @Override
    public Eterable<ByteCode> nodes() {
        if (this.annotationByteCodes != null) {
            return Eterable.of(this.annotationByteCodes);
        }
        return Eterable.empty();
    }

    @Override
    public void write(FieldVisitor v) {
        if (v == null) {
            throw new IllegalArgumentException("v==null");
        }
        AnnotationVisitor av = v.visitAnnotation(this.getDescriptor(), this.isVisible());
        List<AnnotationByteCode> abody = this.annotationByteCodes;
        if (abody != null) {
            int i = -1;
            for (AnnotationByteCode ab : abody) {
                ++i;
                if (ab != null) {
                    ab.write(av);
                    continue;
                }
                throw new IllegalStateException("annotationByteCodes[" + i + "]==null");
            }
        }
    }
}

