/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.trambda.bc.cls;

import java.util.function.Consumer;
import org.objectweb.asm.ClassWriter;
import xyz.cofe.trambda.bc.cls.ClazzWriter;
import xyz.cofe.trambda.bc.cls.ClsByteCode;

public class CSource
implements ClsByteCode,
ClazzWriter {
    private static final long serialVersionUID = 1L;
    protected String source;
    protected String debug;

    public CSource() {
    }

    public CSource(String source, String debug) {
        this.source = source;
        this.debug = debug;
    }

    public CSource(CSource sample) {
        if (sample == null) {
            throw new IllegalArgumentException("sample==null");
        }
        this.source = sample.source;
        this.debug = sample.debug;
    }

    @Override
    public CSource clone() {
        return new CSource(this);
    }

    public CSource configure(Consumer<CSource> conf) {
        if (conf == null) {
            throw new IllegalArgumentException("conf==null");
        }
        conf.accept(this);
        return this;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getDebug() {
        return this.debug;
    }

    public void setDebug(String debug) {
        this.debug = debug;
    }

    public String toString() {
        return CSource.class.getSimpleName() + " source=" + (String)(this.source != null ? "\"" + this.source + "\"" : "null") + ", debug=" + (String)(this.debug != null ? "\"" + this.debug + "\"" : "null");
    }

    @Override
    public void write(ClassWriter v) {
        if (v == null) {
            throw new IllegalArgumentException("v==null");
        }
        v.visitSource(this.getSource(), this.getDebug());
    }
}

