/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.trambda.bc.cls;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import xyz.cofe.trambda.bc.AccFlags;
import xyz.cofe.trambda.bc.AccFlagsProperty;
import xyz.cofe.trambda.bc.FieldFlags;
import xyz.cofe.trambda.bc.cls.ClazzWriter;
import xyz.cofe.trambda.bc.cls.ClsByteCode;
import xyz.cofe.trambda.bc.fld.FieldByteCode;
import xyz.cofe.trambda.bc.fld.FieldEnd;

public class CField
implements ClsByteCode,
ClazzWriter,
AccFlagsProperty,
FieldFlags {
    private static final long serialVersionUID = 1L;
    protected int access;
    protected String name;
    protected String descriptor;
    protected String signature;
    protected Object value;
    protected List<FieldByteCode> fieldByteCodes;

    public CField() {
    }

    public CField(int access, String name, String descriptor, String signature, Object value) {
        this.access = access;
        this.name = name;
        this.descriptor = descriptor;
        this.signature = signature;
        this.value = value;
    }

    public CField(CField sample) {
        if (sample == null) {
            throw new IllegalArgumentException("sample==null");
        }
        this.access = sample.getAccess();
        this.name = sample.getName();
        this.descriptor = sample.getDescriptor();
        this.signature = sample.getSignature();
        this.value = sample.getValue();
    }

    @Override
    public CField clone() {
        return new CField(this);
    }

    public CField configure(Consumer<CField> conf) {
        if (conf == null) {
            throw new IllegalArgumentException("conf==null");
        }
        conf.accept(this);
        return this;
    }

    @Override
    public int getAccess() {
        return this.access;
    }

    @Override
    public void setAccess(int access) {
        this.access = access;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(String descriptor) {
        this.descriptor = descriptor;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String toString() {
        return CField.class.getSimpleName() + " access=" + this.access + "#" + new AccFlags(this.access).flags() + " name=" + this.name + " descriptor=" + this.descriptor + " signature=" + this.signature + " value=" + this.value;
    }

    public List<FieldByteCode> getFieldByteCodes() {
        if (this.fieldByteCodes == null) {
            this.fieldByteCodes = new ArrayList<FieldByteCode>();
        }
        return this.fieldByteCodes;
    }

    public void setFieldByteCodes(List<FieldByteCode> fld) {
        this.fieldByteCodes = fld;
    }

    @Override
    public void write(ClassWriter v) {
        if (v == null) {
            throw new IllegalArgumentException("v==null");
        }
        FieldVisitor fv = v.visitField(this.getAccess(), this.getName(), this.getDescriptor(), this.getSignature(), this.getValue());
        List<FieldByteCode> body = this.fieldByteCodes;
        if (body != null) {
            for (FieldByteCode b : body) {
                if (b instanceof FieldEnd) continue;
                b.write(fv);
            }
        }
        fv.visitEnd();
    }
}

