/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.trambda.bc;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class AccFlags {
    private final int flags;
    private static Map<String, Integer> flagName = new TreeMap<String, Integer>();

    public AccFlags(int flags) {
        this.flags = flags;
    }

    public int value() {
        return this.flags;
    }

    private boolean has(int flag) {
        return (this.flags & flag) == flag;
    }

    private static int set(int flags, int flag) {
        return flags | flag;
    }

    private static int set(int flags, int flag, boolean switchOn) {
        return switchOn ? flags | flag : flags & ~flag;
    }

    private static int unset(int flags, int flag) {
        return flags & ~flag;
    }

    public boolean isAbstract() {
        return this.has(1024);
    }

    public AccFlags withAbstract(boolean v) {
        return new AccFlags(AccFlags.set(this.flags, 1024, v));
    }

    public boolean isAnnotation() {
        return this.has(8192);
    }

    public AccFlags withAnnotation(boolean v) {
        return new AccFlags(AccFlags.set(this.flags, 8192, v));
    }

    public boolean isBridge() {
        return this.has(64);
    }

    public AccFlags withBridge(boolean v) {
        return new AccFlags(AccFlags.set(this.flags, 64, v));
    }

    public boolean isDeprecated() {
        return this.has(131072);
    }

    public AccFlags withDeprecated(boolean v) {
        return new AccFlags(AccFlags.set(this.flags, 131072, v));
    }

    public boolean isEnum() {
        return this.has(16384);
    }

    public AccFlags withEnum(boolean v) {
        return new AccFlags(AccFlags.set(this.flags, 16384, v));
    }

    public boolean isFinal() {
        return this.has(16);
    }

    public AccFlags withFinal(boolean v) {
        return new AccFlags(AccFlags.set(this.flags, 16, v));
    }

    public boolean isInterface() {
        return this.has(512);
    }

    public AccFlags withInterface(boolean v) {
        return new AccFlags(AccFlags.set(this.flags, 512, v));
    }

    public boolean isMandated() {
        return this.has(32768);
    }

    public AccFlags withMandated(boolean v) {
        return new AccFlags(AccFlags.set(this.flags, 32768, v));
    }

    public boolean isModule() {
        return this.has(32768);
    }

    public AccFlags withModule(boolean v) {
        return new AccFlags(AccFlags.set(this.flags, 32768, v));
    }

    public boolean isNative() {
        return this.has(256);
    }

    public AccFlags withNative(boolean v) {
        return new AccFlags(AccFlags.set(this.flags, 256, v));
    }

    public boolean isOpen() {
        return this.has(32);
    }

    public AccFlags withOpen(boolean v) {
        return new AccFlags(AccFlags.set(this.flags, 32, v));
    }

    public boolean isPrivate() {
        return this.has(2);
    }

    public AccFlags withPrivate(boolean v) {
        return new AccFlags(AccFlags.set(this.flags, 2, v));
    }

    public boolean isProtected() {
        return this.has(4);
    }

    public AccFlags withProtected(boolean v) {
        return new AccFlags(AccFlags.set(this.flags, 4, v));
    }

    public boolean isPublic() {
        return this.has(1);
    }

    public AccFlags withPublic(boolean v) {
        return new AccFlags(AccFlags.set(this.flags, 1, v));
    }

    public boolean isRecord() {
        return this.has(65536);
    }

    public AccFlags withRecord(boolean v) {
        return new AccFlags(AccFlags.set(this.flags, 65536, v));
    }

    public boolean isStatic() {
        return this.has(8);
    }

    public AccFlags withStatic(boolean v) {
        return new AccFlags(AccFlags.set(this.flags, 8, v));
    }

    public boolean isStaticPhase() {
        return this.has(64);
    }

    public AccFlags withStaticPhase(boolean v) {
        return new AccFlags(AccFlags.set(this.flags, 64, v));
    }

    public boolean isStrict() {
        return this.has(2048);
    }

    public AccFlags withStrict(boolean v) {
        return new AccFlags(AccFlags.set(this.flags, 2048, v));
    }

    public boolean isSuper() {
        return this.has(32);
    }

    public AccFlags withSuper(boolean v) {
        return new AccFlags(AccFlags.set(this.flags, 32, v));
    }

    public boolean isSynchronized() {
        return this.has(32);
    }

    public AccFlags withSynchronized(boolean v) {
        return new AccFlags(AccFlags.set(this.flags, 32, v));
    }

    public boolean isSynthetic() {
        return this.has(4096);
    }

    public AccFlags withSynthetic(boolean v) {
        return new AccFlags(AccFlags.set(this.flags, 4096, v));
    }

    public boolean isTransient() {
        return this.has(128);
    }

    public AccFlags withTransient(boolean v) {
        return new AccFlags(AccFlags.set(this.flags, 128, v));
    }

    public boolean isTransitive() {
        return this.has(32);
    }

    public AccFlags withTransitive(boolean v) {
        return new AccFlags(AccFlags.set(this.flags, 32, v));
    }

    public boolean isVarArgs() {
        return this.has(128);
    }

    public AccFlags withVarArgs(boolean v) {
        return new AccFlags(AccFlags.set(this.flags, 128, v));
    }

    public boolean isVolatile() {
        return this.has(64);
    }

    public AccFlags withVolatile(boolean v) {
        return new AccFlags(AccFlags.set(this.flags, 64, v));
    }

    public Set<String> flags() {
        LinkedHashSet<String> flags = new LinkedHashSet<String>();
        for (Map.Entry<String, Integer> e : flagName.entrySet()) {
            if (!this.has(e.getValue())) continue;
            flags.add(e.getKey());
        }
        return flags;
    }

    public AccFlags flags(Set<String> flags) {
        if (flags == null) {
            throw new IllegalArgumentException("flags==null");
        }
        HashMap<String, Boolean> state = new HashMap<String, Boolean>();
        for (String f : flagName.keySet()) {
            state.put(f, flags.contains(f));
        }
        AccFlags res = this;
        for (Map.Entry<String, Integer> e : flagName.entrySet()) {
            Integer mask = e.getValue();
            Boolean set = (Boolean)state.get(e.getKey());
            res = new AccFlags(AccFlags.set(res.value(), mask, set));
        }
        return res;
    }

    static {
        flagName.put("Abstract", 1024);
        flagName.put("Annotation", 8192);
        flagName.put("Bridge", 64);
        flagName.put("Deprecated", 131072);
        flagName.put("Enum", 16384);
        flagName.put("Final", 16);
        flagName.put("Interface", 512);
        flagName.put("Mandated", 32768);
        flagName.put("Module", 32768);
        flagName.put("Native", 256);
        flagName.put("Open", 32);
        flagName.put("Private", 2);
        flagName.put("Protected", 4);
        flagName.put("Public", 1);
        flagName.put("Record", 65536);
        flagName.put("Static", 8);
        flagName.put("StaticPhase", 64);
        flagName.put("Strict", 2048);
        flagName.put("Super", 32);
        flagName.put("Syncronized", 32);
        flagName.put("Synthetic", 4096);
        flagName.put("Transient", 128);
        flagName.put("Transitive", 32);
        flagName.put("VarArgs", 128);
        flagName.put("Volatile", 64);
        flagName = Collections.unmodifiableMap(flagName);
    }
}

