/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.trambda;

import java.io.IOError;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.cofe.fn.Fn1;
import xyz.cofe.fn.Tuple;
import xyz.cofe.fn.Tuple2;
import xyz.cofe.fn.Tuple4;
import xyz.cofe.trambda.JavaClassName;
import xyz.cofe.trambda.LambdaNode;
import xyz.cofe.trambda.bc.ByteCode;
import xyz.cofe.trambda.bc.bm.HandleArg;
import xyz.cofe.trambda.bc.bm.MHandle;
import xyz.cofe.trambda.bc.cls.CBegin;
import xyz.cofe.trambda.bc.cls.CField;
import xyz.cofe.trambda.bc.cls.CMethod;
import xyz.cofe.trambda.bc.mth.MInvokeDynamicInsn;

public class LambdaDump
implements Serializable {
    protected List<Object> capturedArgs;
    protected LambdaNode lambdaNode;
    public final transient Map<Serializable, SerializedLambda> serializableLambdaCache = new LinkedHashMap<Serializable, SerializedLambda>();
    public final transient Map<SerializedLambda, LambdaNode> lambdaNodeCache = new LinkedHashMap<SerializedLambda, LambdaNode>();
    protected boolean cacheSerializedLambda = true;
    public final transient Map<Class<?>, Map<String, CBegin>> classByteCodeCache = new HashMap();
    protected final transient Map<MHandle, LambdaNode> refs = new LinkedHashMap<MHandle, LambdaNode>();

    public LambdaDump configure(Consumer<LambdaDump> conf) {
        if (conf == null) {
            throw new IllegalArgumentException("conf==null");
        }
        conf.accept(this);
        return this;
    }

    public List<Object> getCapturedArgs() {
        if (this.capturedArgs == null) {
            this.capturedArgs = new ArrayList<Object>();
        }
        return this.capturedArgs;
    }

    public void setCapturedArgs(List<Object> ls) {
        if (ls == null) {
            throw new IllegalArgumentException("ls==null");
        }
        this.capturedArgs = ls;
    }

    public LambdaNode getLambdaNode() {
        return this.lambdaNode;
    }

    public void setLambdaNode(LambdaNode node) {
        this.lambdaNode = node;
    }

    public synchronized LambdaDump dump(Fn1<?, ?> fn) {
        if (fn == null) {
            throw new IllegalArgumentException("fn==null");
        }
        return this.dumpSLambda((Serializable)fn);
    }

    public synchronized void invalidateCache() {
        this.serializableLambdaCache.clear();
        this.classByteCodeCache.clear();
        this.lambdaNodeCache.clear();
    }

    protected void onSerializedLambda(SerializedLambda sl) {
    }

    protected void onLambdaNode(LambdaNode ln) {
    }

    public synchronized boolean isCacheSerializedLambda() {
        return this.cacheSerializedLambda;
    }

    public synchronized void setCacheSerializedLambda(boolean v) {
        this.cacheSerializedLambda = v;
    }

    protected synchronized LambdaDump dumpSLambda(Serializable serializableLambda) {
        SerializedLambda sl;
        if (serializableLambda == null) {
            throw new IllegalArgumentException("serializableLambda==null");
        }
        try {
            sl = this.cacheSerializedLambda ? this.serializableLambdaCache.computeIfAbsent(serializableLambda, x -> this.serializedLambda(serializableLambda)) : this.serializedLambda(serializableLambda);
        }
        catch (Exception e) {
            throw new IOError(e);
        }
        this.onSerializedLambda(sl);
        LambdaNode lnode = this.lambdaNodeCache.computeIfAbsent(sl, x -> {
            this.refs.clear();
            return this.lambdaNode(serializableLambda.getClass(), sl.getImplClass(), sl.getImplMethodName(), sl.getImplMethodSignature());
        });
        this.onLambdaNode(lnode);
        LambdaDump ldump = new LambdaDump();
        ldump.setLambdaNode(lnode);
        if (sl.getCapturedArgCount() > 0) {
            for (int i = 0; i < sl.getCapturedArgCount(); ++i) {
                ldump.getCapturedArgs().add(sl.getCapturedArg(i));
            }
        }
        return ldump;
    }

    protected SerializedLambda serializedLambda(Serializable lambda) {
        if (lambda == null) {
            throw new IllegalArgumentException("lambda==null");
        }
        Method method = null;
        try {
            method = lambda.getClass().getDeclaredMethod("writeReplace", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
        method.setAccessible(true);
        try {
            return (SerializedLambda)method.invoke((Object)lambda, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new Error(e);
        }
    }

    protected CBegin classByteCode(Class<?> baseClass, String clazz) throws IOException {
        if (baseClass == null) {
            throw new IllegalArgumentException("baseClass==null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("clazz==null");
        }
        Map cachedMap = this.classByteCodeCache.computeIfAbsent(baseClass, b -> new HashMap());
        CBegin cachedValue = (CBegin)cachedMap.get(clazz);
        if (cachedValue != null) {
            return cachedValue;
        }
        URL lambdaClassURL = baseClass.getResource("/" + clazz.replace(".", "/") + ".class");
        if (lambdaClassURL == null) {
            throw new IOException("bytecode of class " + clazz + " not found");
        }
        CBegin cbegin = CBegin.parseByteCode(lambdaClassURL);
        cachedMap.put(clazz, cbegin);
        return cbegin;
    }

    protected synchronized LambdaNode lambdaNode(Class<?> baseClass, String implClass, String methName, String methSign) {
        if (baseClass == null) {
            throw new IllegalArgumentException("baseClass==null");
        }
        if (implClass == null) {
            throw new IllegalArgumentException("implClass==null");
        }
        if (methName == null) {
            throw new IllegalArgumentException("methName==null");
        }
        if (methSign == null) {
            throw new IllegalArgumentException("methSign==null");
        }
        CBegin classByteCode = null;
        try {
            classByteCode = this.classByteCode(baseClass, implClass);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        LambdaNode node = new LambdaNode();
        node.setClazz(classByteCode);
        Optional<CMethod> cmethod = classByteCode.getMethods().stream().filter(m -> methName.equals(m.getName()) && methSign.equals(m.getDescriptor())).findFirst();
        cmethod.ifPresent(m -> {
            node.setMethod((CMethod)m);
            m.getMethodByteCodes().stream().map(bc -> bc instanceof MInvokeDynamicInsn ? (MInvokeDynamicInsn)bc : null).filter(Objects::nonNull).flatMap(idi -> idi.getBootstrapMethodArguments().stream().map(arg -> {
                if (!(arg instanceof HandleArg)) {
                    return null;
                }
                HandleArg ha = (HandleArg)arg;
                MHandle h = ha.getHandle();
                if (h == null) {
                    return null;
                }
                if (h.getName().startsWith("lambda$") && h.getTag() == 6) {
                    return h;
                }
                return null;
            })).filter(Objects::nonNull).map(h -> {
                LambdaNode rrefs = this.refs.get(h);
                if (rrefs != null) {
                    return rrefs;
                }
                LambdaNode mdefChild = this.lambdaNode(baseClass, h.getOwner(), h.getName(), h.getDesc());
                if (mdefChild != null) {
                    this.refs.put((MHandle)h, mdefChild);
                }
                return mdefChild;
            }).forEach(ref -> node.getNodes().add((LambdaNode)ref));
        });
        return node;
    }

    public Restore restore() {
        return new Restore(this);
    }

    public static void dump(Consumer<String> log, ByteCode byteCode) {
        if (log == null) {
            throw new IllegalArgumentException("log==null");
        }
        if (byteCode == null) {
            throw new IllegalArgumentException("byteCode==null");
        }
        byteCode.walk().tree().forEach(ts -> {
            String pref = "";
            if (ts.getLevel() > 0) {
                pref = (String)ts.nodes().limit((long)ts.getLevel()).map(b -> {
                    if (b instanceof CMethod) {
                        return CMethod.class.getSimpleName() + "#" + ((CMethod)b).getName() + "()";
                    }
                    if (b instanceof CField) {
                        return CField.class.getSimpleName() + "#" + ((CField)b).getName();
                    }
                    return b.getClass().getSimpleName();
                }).reduce((Object)"", (a, b) -> a + "/" + b);
            }
            log.accept(pref + "/" + ts.getNode());
        });
    }

    public static class Restore {
        private static final Logger rlog = LoggerFactory.getLogger(Restore.class);
        protected final LambdaDump dump;
        protected static final AtomicInteger classNameIdSeq = new AtomicInteger(0);
        protected JavaClassName className = new JavaClassName(LambdaDump.class.getPackageName() + "." + LambdaDump.class.getSimpleName().toLowerCase() + ".AutoGen" + classNameIdSeq.getAndIncrement());
        protected String rootMethodName = "_root_";
        public final Fn1<CBegin, ClassLoader> defaultClassLoader = (Fn1 & Serializable)cb -> new ClassLoader((CBegin)cb){
            final /* synthetic */ CBegin val$cb;
            {
                this.val$cb = cBegin;
            }

            @Override
            protected Class<?> findClass(String name) throws ClassNotFoundException {
                if (name != null && name.equals(this.val$cb.javaName().getName())) {
                    byte[] bytes = this.val$cb.toByteCode();
                    return this.defineClass(name, bytes, 0, bytes.length);
                }
                return super.findClass(name);
            }
        };
        protected Fn1<CBegin, ClassLoader> classLoader = this.defaultClassLoader;

        public Restore(LambdaDump dump) {
            if (dump == null) {
                throw new IllegalArgumentException("dump==null");
            }
            this.dump = dump;
        }

        public synchronized JavaClassName className() {
            return this.className;
        }

        public synchronized Restore className(String name) {
            if (name == null) {
                throw new IllegalArgumentException("name==null");
            }
            this.className = new JavaClassName(name);
            return this;
        }

        public synchronized Restore className(JavaClassName name) {
            if (name == null) {
                throw new IllegalArgumentException("name==null");
            }
            this.className = name;
            return this;
        }

        public synchronized String rootMethodName() {
            return this.rootMethodName;
        }

        public synchronized Restore rootMethodName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("name==null");
            }
            if (!JavaClassName.validId.matcher(name).matches()) {
                throw new IllegalArgumentException("name not matched " + JavaClassName.validId);
            }
            this.rootMethodName = name;
            return this;
        }

        public synchronized CBegin classByteCode() {
            return this.classByteCode(null);
        }

        public synchronized CBegin classByteCode(Consumer<Tuple2<CBegin, CMethod>> rootConsumer) {
            LambdaNode srcRootNode = this.dump.getLambdaNode();
            if (srcRootNode == null) {
                throw new IllegalStateException("root lambda node is null");
            }
            CBegin srcRootClass = srcRootNode.getClazz();
            if (srcRootClass == null) {
                throw new IllegalStateException("root class (CBegin) is null");
            }
            CMethod srcRootMethod = srcRootNode.getMethod();
            if (srcRootMethod == null) {
                throw new IllegalStateException("root method (CMethod) is null");
            }
            CBegin rootClass = new CBegin();
            rootClass.javaName().setName(this.className.name);
            rootClass.setAccess(33);
            rootClass.setVersion(srcRootClass.getVersion());
            rootClass.setSuperName(Object.class.getName().replace(".", "/"));
            rootClass.setInterfaces(new String[0]);
            rlog.debug("generate class {}", (Object)rootClass);
            CMethod rootMethod = srcRootMethod.clone();
            rootMethod.setName("_root_");
            rootMethod.setPrivate(false);
            rootMethod.setPublic(true);
            rootClass.getMethods().add(rootMethod);
            rlog.debug("add method {}", (Object)rootMethod);
            LinkedHashMap<LambdaNode, CMethod> methods = new LinkedHashMap<LambdaNode, CMethod>();
            methods.put(srcRootNode, rootMethod);
            HashMap relinkMap = new HashMap();
            if (rlog.isTraceEnabled()) {
                srcRootNode.walk().tree().forEach(t -> {
                    CMethod m;
                    StringBuilder sb = new StringBuilder();
                    sb.append("..".repeat(t.getLevel()));
                    LambdaNode n = (LambdaNode)t.getNode();
                    if (n.getClazz() != null) {
                        sb.append(" class=").append(n.getClazz().javaName());
                    }
                    if ((m = n.getMethod()) != null) {
                        sb.append(" method=").append(m.getName()).append(" ").append(m.getDescriptor());
                    }
                    rlog.trace(sb.toString());
                });
            }
            srcRootNode.walk().tree().forEach(ts -> {
                if (ts.getLevel() <= 0) {
                    return;
                }
                LambdaNode parent = (LambdaNode)ts.getParent().getNode();
                LambdaNode node = (LambdaNode)ts.getNode();
                CBegin nodeClazz = node.getClazz();
                CMethod nodeMethod = node.getMethod();
                CMethod nm = nodeMethod.clone();
                methods.put(node, nm);
                rootClass.getMethods().add(nm);
                CMethod prntMethod = (CMethod)methods.get(parent);
                relinkMap.computeIfAbsent(prntMethod, x -> new ArrayList()).add(Tuple.of((Object)nodeClazz, (Object)nodeMethod, (Object)rootClass, (Object)nm));
            });
            for (CMethod smeth : relinkMap.keySet()) {
                smeth.getMethodByteCodes().stream().map(b -> b instanceof MInvokeDynamicInsn ? (MInvokeDynamicInsn)b : null).filter(Objects::nonNull).forEach(invd -> invd.getBootstrapMethodArguments().stream().filter(ma -> ma instanceof HandleArg).map(ma -> (HandleArg)ma).forEach(ha -> {
                    for (Tuple4 tlink : (List)relinkMap.get(smeth)) {
                        MHandle mh = ha.getHandle();
                        if (mh == null || !mh.getOwner().equals(((CBegin)tlink.a()).getName()) || !mh.getName().equals(((CMethod)tlink.b()).getName()) || !mh.getDesc().equals(((CMethod)tlink.b()).getDescriptor())) continue;
                        MHandle nmh = new MHandle();
                        nmh.setName(((CMethod)tlink.d()).getName());
                        nmh.setOwner(((CBegin)tlink.c()).getName());
                        nmh.setDesc(((CMethod)tlink.d()).getDescriptor());
                        nmh.setTag(mh.getTag());
                        nmh.setIface(mh.isIface());
                        ha.setHandle(nmh);
                        rlog.debug("linked {} -> {}", (Object)(((CBegin)tlink.a()).javaName() + " " + ((CMethod)tlink.b()).getName() + ((CMethod)tlink.b()).getDescriptor()), (Object)(((CBegin)tlink.c()).javaName() + " " + ((CMethod)tlink.d()).getName() + ((CMethod)tlink.d()).getDescriptor()));
                    }
                }));
            }
            if (rlog.isTraceEnabled()) {
                rlog.trace("dump generated class");
                Restore.traceByteCode(rootClass);
            }
            if (rootConsumer != null) {
                rootConsumer.accept((Tuple2<CBegin, CMethod>)Tuple2.of((Object)rootClass, (Object)rootMethod));
            }
            return rootClass;
        }

        private static void traceByteCode(ByteCode begin) {
            if (begin == null) {
                throw new IllegalArgumentException("begin==null");
            }
            LambdaDump.dump(arg_0 -> ((Logger)rlog).trace(arg_0), begin);
        }

        public synchronized Fn1<CBegin, ClassLoader> classLoader() {
            return this.classLoader;
        }

        public synchronized Restore classLoader(Fn1<CBegin, ClassLoader> cl) {
            if (cl == null) {
                throw new IllegalArgumentException("cl==null");
            }
            this.classLoader = cl;
            return this;
        }

        public synchronized Class<?> restoreClass(Consumer<CMethod> rootMethodConsumer) {
            CMethod[] rootMethArr = new CMethod[]{null};
            CBegin cbegin = this.classByteCode(r -> {
                rootMethArr[0] = (CMethod)r.b();
            });
            CMethod rootMethod = rootMethArr[0];
            ClassLoader cloader = (ClassLoader)this.classLoader().apply((Object)cbegin);
            try {
                Class<?> c = Class.forName(cbegin.javaName().getName(), true, cloader);
                if (rootMethodConsumer != null) {
                    rootMethodConsumer.accept(rootMethod);
                }
                return c;
            }
            catch (ClassNotFoundException e) {
                throw new Error(e);
            }
        }

        public synchronized Class<?> restoreClass() {
            return this.restoreClass(null);
        }

        public synchronized Method method() {
            CMethod[] rootm = new CMethod[]{null};
            Class<?> cls = this.restoreClass(m -> {
                rootm[0] = m;
            });
            CMethod rootMethod = rootm[0];
            Optional<Method> res = Arrays.stream(cls.getDeclaredMethods()).filter(m -> m.getName().equals(rootMethod.getName())).findFirst();
            if (res.isEmpty()) {
                throw new Error("method " + rootMethod.getName() + " not found in " + cls);
            }
            return res.get();
        }
    }
}

