/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.trambda;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.objectweb.asm.AnnotationVisitor;
import xyz.cofe.trambda.bc.ByteCode;
import xyz.cofe.trambda.bc.ann.AEnd;
import xyz.cofe.trambda.bc.ann.AEnum;
import xyz.cofe.trambda.bc.ann.APair;
import xyz.cofe.trambda.bc.ann.AnnotationByteCode;
import xyz.cofe.trambda.bc.ann.EmAArray;
import xyz.cofe.trambda.bc.ann.EmANameDesc;
import xyz.cofe.trambda.bc.ann.GetAnnotationByteCodes;

public class AnnotationDump
extends AnnotationVisitor {
    public static final AtomicInteger idSeq = new AtomicInteger(0);
    private Consumer<? super ByteCode> byteCodeConsumer;

    public AnnotationDump(int api) {
        super(api);
    }

    public AnnotationDump(int api, AnnotationVisitor annotationVisitor) {
        super(api, annotationVisitor);
    }

    public AnnotationDump byteCode(Consumer<? super ByteCode> bc) {
        this.byteCodeConsumer = bc;
        return this;
    }

    public AnnotationDump byteCode(Consumer<? super ByteCode> bc, GetAnnotationByteCodes sencondConsumer) {
        this.byteCodeConsumer = b -> {
            if (bc != null) {
                bc.accept((ByteCode)b);
            }
            if (sencondConsumer != null && b instanceof AnnotationByteCode) {
                sencondConsumer.getAnnotationByteCodes().add((AnnotationByteCode)b);
            }
        };
        return this;
    }

    protected void emit(ByteCode bc) {
        if (bc == null) {
            throw new IllegalArgumentException("bc==null");
        }
        Consumer<? super ByteCode> c = this.byteCodeConsumer;
        if (c != null) {
            c.accept(bc);
        }
    }

    public void visit(String name, Object value) {
        this.emit(APair.create(name, value));
    }

    public void visitEnum(String name, String descriptor, String value) {
        this.emit(new AEnum(name, descriptor, value));
    }

    public AnnotationVisitor visitAnnotation(String name, String descriptor) {
        EmANameDesc emOb = new EmANameDesc();
        AnnotationDump dump = new AnnotationDump(this.api);
        dump = dump.byteCode(this.byteCodeConsumer, emOb);
        emOb.setName(name);
        emOb.setDescriptor(descriptor);
        this.emit(emOb);
        return dump;
    }

    public AnnotationVisitor visitArray(String name) {
        EmAArray emOb = new EmAArray();
        AnnotationDump dump = new AnnotationDump(this.api);
        dump = dump.byteCode(this.byteCodeConsumer, emOb);
        emOb.setName(name);
        return dump;
    }

    public void visitEnd() {
        this.emit(new AEnd());
    }
}

