/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class Template<V> {
    protected final List<Item<V>> items;

    public static <A> List<A> parse(String template, Function<String, A> text, Function<String, A> code) {
        if (template == null) {
            throw new IllegalArgumentException("template==null");
        }
        if (text == null) {
            throw new IllegalArgumentException("text==null");
        }
        if (code == null) {
            throw new IllegalArgumentException("code==null");
        }
        int state = 0;
        ArrayList list = new ArrayList();
        StringBuilder buff = new StringBuilder();
        int[] level = new int[]{0};
        Runnable switch2code = () -> {
            if (buff.length() > 0) {
                list.add(text.apply(buff.toString()));
            }
            buff.setLength(0);
        };
        Runnable switch2text = () -> {
            if (buff.length() > 0) {
                list.add(code.apply(buff.toString()));
            }
            buff.setLength(0);
        };
        block17: for (int ci = 0; ci < template.length(); ++ci) {
            char c = template.charAt(ci);
            switch (state) {
                case 0: {
                    switch (c) {
                        case '$': {
                            state = 1;
                            continue block17;
                        }
                        case '\\': {
                            state = 2;
                            continue block17;
                        }
                    }
                    buff.append(c);
                    continue block17;
                }
                case 1: {
                    switch (c) {
                        case '{': {
                            state = 50;
                            switch2code.run();
                            level[0] = 1;
                            continue block17;
                        }
                    }
                    buff.append("$").append(c);
                    state = 0;
                    continue block17;
                }
                case 2: {
                    state = 0;
                    buff.append(c);
                    continue block17;
                }
                case 50: {
                    switch (c) {
                        case '{': {
                            level[0] = level[0] + 1;
                            buff.append(c);
                            continue block17;
                        }
                        case '}': {
                            level[0] = level[0] - 1;
                            if (level[0] <= 0) {
                                switch2text.run();
                                state = 0;
                                continue block17;
                            }
                            buff.append(c);
                            continue block17;
                        }
                    }
                    buff.append(c);
                }
            }
        }
        if (buff.length() > 0) {
            if (state == 50) {
                switch2text.run();
            } else {
                switch2code.run();
            }
        }
        return list;
    }

    public Template(List<Item<V>> items) {
        if (items == null) {
            throw new IllegalArgumentException("items==null");
        }
        ArrayList<Item<V>> itms = new ArrayList<Item<V>>();
        int idx = -1;
        for (Item<V> itm : items) {
            ++idx;
            if (itm == null) {
                throw new IllegalArgumentException("items[" + idx + "]==null");
            }
            itms.add(itm);
        }
        this.items = Collections.unmodifiableList(itms);
    }

    public List<Item<V>> items() {
        return this.items;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Item<V> itm : this.items()) {
            if (itm == null) {
                sb.append("null");
                continue;
            }
            if (itm instanceof CodeItem) {
                sb.append("${").append(itm.text).append("}");
                continue;
            }
            sb.append(itm.text);
        }
        return sb.toString();
    }

    public static <V> Template<V> parse(String template, Class<V> valueType) {
        if (template == null) {
            throw new IllegalArgumentException("template==null");
        }
        return new Template<V>(Template.parse(template, TextItem::new, CodeItem::new));
    }

    public static <V> Template<V> parse(String template) {
        if (template == null) {
            throw new IllegalArgumentException("template==null");
        }
        return new Template<V>(Template.parse(template, TextItem::new, CodeItem::new));
    }

    public Template<V> binder(Function<String, Optional<Function<V, String>>> binder) {
        if (binder == null) {
            throw new IllegalArgumentException("binder==null");
        }
        return new Template<V>(this.items.stream().map(itm -> {
            if (itm instanceof CodeItem && !(itm instanceof BindedCodeItem)) {
                return ((Optional)binder.apply(itm.text)).map(f -> new BindedCodeItem(itm.text, f)).orElse((Item)itm);
            }
            return itm;
        }).collect(Collectors.toList()));
    }

    public Template<V> bind(String code, Function<V, String> evalFun) {
        if (code == null) {
            throw new IllegalArgumentException("code==null");
        }
        if (evalFun == null) {
            throw new IllegalArgumentException("evalFun==null");
        }
        return this.binder(c -> {
            if (code.equals(c)) {
                return Optional.of(evalFun);
            }
            return Optional.empty();
        });
    }

    public String eval(V value) {
        StringBuilder sb = new StringBuilder();
        for (Item<V> itm : this.items()) {
            if (itm == null) {
                sb.append("null");
                continue;
            }
            String s = itm.eval(value);
            sb.append(s);
        }
        return sb.toString();
    }

    public static class BindedCodeItem<V>
    extends CodeItem<V> {
        public final Function<V, String> interpret;

        public BindedCodeItem(String text, Function<V, String> interpret) {
            super(text);
            if (interpret == null) {
                throw new IllegalArgumentException("code==null");
            }
            this.interpret = interpret;
        }

        public BindedCodeItem(String text, Supplier<String> interpret) {
            super(text);
            if (interpret == null) {
                throw new IllegalArgumentException("code==null");
            }
            this.interpret = x -> (String)interpret.get();
        }

        @Override
        public String eval(V value) {
            return this.interpret.apply(value);
        }
    }

    public static class CodeItem<V>
    extends Item<V> {
        public CodeItem(String text) {
            super(text);
        }

        @Override
        public String eval(V value) {
            return "";
        }
    }

    public static class TextItem<V>
    extends Item<V> {
        public TextItem(String text) {
            super(text);
        }

        @Override
        public String eval(V value) {
            return this.text;
        }
    }

    public static abstract class Item<V> {
        public final String text;

        public Item(String text) {
            this.text = text;
        }

        public abstract String eval(V var1);
    }
}

