/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import xyz.cofe.fn.Tuple2;
import xyz.cofe.fn.Tuple3;
import xyz.cofe.text.Text;

public class BytesDump {
    protected int offsetAlign = 16;
    protected int ptrAlign = 16;
    protected int offsetWidth = 8;
    protected int offsetRadix = 16;
    protected String offsetDelimiter = "|";
    protected String descDelimiter = "|";
    protected int defBytesPerLine = 16;
    protected Function<Decode, Optional<Decoded>> preview;

    public int getOffsetAlign() {
        return this.offsetAlign;
    }

    public void setOffsetAlign(int v) {
        this.offsetAlign = v;
    }

    public int getPtrAlign() {
        return this.ptrAlign;
    }

    public void setPtrAlign(int v) {
        this.ptrAlign = v;
    }

    public int getOffsetWidth() {
        return this.offsetWidth;
    }

    public void setOffsetWidth(int offsetWidth) {
        this.offsetWidth = offsetWidth;
    }

    public int getOffsetRadix() {
        return this.offsetRadix;
    }

    public void setOffsetRadix(int offsetRadix) {
        this.offsetRadix = offsetRadix;
    }

    public String getOffsetDelimiter() {
        return this.offsetDelimiter;
    }

    public void setOffsetDelimiter(String offsetDelimiter) {
        this.offsetDelimiter = offsetDelimiter;
    }

    public String getDescDelimiter() {
        return this.descDelimiter;
    }

    public void setDescDelimiter(String descDelimiter) {
        this.descDelimiter = descDelimiter;
    }

    public int getDefBytesPerLine() {
        return this.defBytesPerLine;
    }

    public void setDefBytesPerLine(int defBytesPerLine) {
        this.defBytesPerLine = defBytesPerLine;
    }

    public Function<Decode, Optional<Decoded>> getPreview() {
        return this.preview;
    }

    public void setPreview(Function<Decode, Optional<Decoded>> preview) {
        this.preview = preview;
    }

    private static String align(int width, int i, int radix) {
        String s = Integer.toString(i, radix);
        if (s.length() < width) {
            return Text.repeat(" ", width - s.length()) + s;
        }
        return s;
    }

    public String dump(byte[] buff) {
        if (buff == null) {
            throw new IllegalArgumentException("buff==null");
        }
        return this.dump(buff, 0, buff.length);
    }

    public String dump(byte[] buff, int off, int len) {
        int n;
        if (buff == null) {
            throw new IllegalArgumentException("buff==null");
        }
        if (off < 0) {
            throw new IllegalArgumentException("off<0");
        }
        if (len < 0) {
            throw new IllegalArgumentException("len<0");
        }
        if (off + len > buff.length) {
            throw new IllegalArgumentException("off+len>buff.length");
        }
        StringBuilder sb = new StringBuilder();
        boolean newLine = true;
        int perLine = 0;
        int maxPerLine = this.defBytesPerLine;
        int lineIdx = -1;
        String decodedCurrLine = null;
        DecodeMutable decodeMutable = new DecodeMutable(buff, off, len, off);
        if (this.offsetAlign > 1 && (n = off % this.offsetAlign) > 0) {
            int lineLen;
            Optional<Decoded> o;
            int off1 = off - n;
            sb.append(BytesDump.align(this.offsetWidth, off1, this.offsetRadix)).append(this.offsetDelimiter);
            for (int i = 0; i < n; ++i) {
                sb.append("   ");
            }
            perLine = n;
            newLine = false;
            if (this.preview != null && (o = this.preview.apply(decodeMutable)).isPresent() && (lineLen = o.get().getLength()) > 0) {
                maxPerLine = lineLen + perLine;
                decodedCurrLine = o.get().getMessage();
            }
        }
        for (int ptr = off; ptr < off + len; ++ptr) {
            if (newLine) {
                int lineLen;
                Optional<Decoded> o;
                sb.append(BytesDump.align(this.offsetWidth, ptr, this.offsetRadix)).append(this.offsetDelimiter);
                newLine = false;
                ++lineIdx;
                maxPerLine = this.defBytesPerLine;
                decodedCurrLine = null;
                if (this.preview != null && (o = this.preview.apply(decodeMutable.pointer(ptr))).isPresent() && (lineLen = o.get().getLength()) > 0) {
                    maxPerLine = lineLen;
                    decodedCurrLine = o.get().getMessage();
                }
            }
            ++perLine;
            byte b = buff[ptr];
            int hval = (b & 0xF0) >> 4;
            int lval = b & 0xF;
            sb.append(Integer.toHexString(hval)).append(Integer.toHexString(lval));
            if (perLine >= maxPerLine) {
                int lineLen;
                Optional<Decoded> o;
                int n2;
                int appends = this.defBytesPerLine - perLine;
                if (appends > 0) {
                    for (int i = 0; i < appends; ++i) {
                        sb.append("   ");
                    }
                }
                if (decodedCurrLine != null) {
                    sb.append(this.descDelimiter).append(decodedCurrLine);
                }
                sb.append("\n");
                newLine = true;
                perLine = 0;
                if (this.ptrAlign <= 1 || (n2 = (ptr + 1) % this.ptrAlign) <= 0) continue;
                sb.append(BytesDump.align(this.offsetWidth, ptr + 1, this.offsetRadix)).append(this.offsetDelimiter);
                for (int i = 0; i < n2; ++i) {
                    sb.append("   ");
                }
                perLine = n2;
                maxPerLine = this.defBytesPerLine;
                decodedCurrLine = null;
                if (this.preview != null && ptr + 1 < len && (o = this.preview.apply(decodeMutable.pointer(ptr + 1))).isPresent() && (lineLen = o.get().getLength()) > 0) {
                    maxPerLine = lineLen + perLine;
                    decodedCurrLine = o.get().getMessage();
                }
                newLine = false;
                ++lineIdx;
                continue;
            }
            sb.append(" ");
        }
        return sb.toString();
    }

    public static class Builder {
        private final Map<Integer, Tuple2<Integer, Function<byte[], String>>> absoluteDecoded = new HashMap<Integer, Tuple2<Integer, Function<byte[], String>>>();
        private final Map<Integer, Tuple2<Integer, Function<byte[], String>>> relativeDecoded = new HashMap<Integer, Tuple2<Integer, Function<byte[], String>>>();

        public Function<Decode, Optional<Decoded>> preview() {
            return decode -> {
                int off;
                Tuple2<Integer, Function<byte[], String>> rel;
                Tuple2<Integer, Function<byte[], String>> abs = this.absoluteDecoded.get(decode.getPointer());
                if (abs != null) {
                    Optional<byte[]> bytes;
                    int len = (Integer)abs.a();
                    Function fun = (Function)abs.b();
                    if (len > 0 && (bytes = decode.lookup(len)).isPresent()) {
                        return decode.respone(len, (String)fun.apply(bytes.get()));
                    }
                }
                if ((rel = this.relativeDecoded.get(off = decode.getPointer() - decode.getOffset())) != null) {
                    Optional<byte[]> bytes;
                    int len = (Integer)rel.a();
                    Function fun = (Function)rel.b();
                    if (len > 0 && (bytes = decode.lookup(len)).isPresent()) {
                        return decode.respone(len, (String)fun.apply(bytes.get()));
                    }
                }
                return Optional.empty();
            };
        }

        public Builder absolute(Consumer<NextDecoder> decoder) {
            if (decoder == null) {
                throw new IllegalArgumentException("decoder==null");
            }
            decoder.accept(new NextDecoder(this, this.absoluteDecoded, 0, 0));
            return this;
        }

        public Builder relative(Consumer<NextDecoder> decoder) {
            if (decoder == null) {
                throw new IllegalArgumentException("decoder==null");
            }
            decoder.accept(new NextDecoder(this, this.relativeDecoded, 0, 0));
            return this;
        }

        public BytesDump build() {
            BytesDump dump = new BytesDump();
            dump.setPreview(this.preview());
            return dump;
        }

        public static class NextDecoder
        extends Decoder {
            public final int baseOffset;
            public final int baseLen;

            public NextDecoder(Builder builder, Map<Integer, Tuple2<Integer, Function<byte[], String>>> map, int baseOffset, int baseLen) {
                super(builder, map);
                this.baseOffset = baseOffset;
                this.baseLen = baseLen;
            }

            public NextDecoder name(int len, String name) {
                if (len < 1) {
                    throw new IllegalArgumentException("len<1");
                }
                int off = this.baseOffset + this.baseLen;
                this.map.put(off, Tuple2.of((Object)len, b -> name));
                return new NextDecoder(this.builder, this.map, off, len);
            }

            public NextDecoder decode(int len, Function<byte[], String> decoder) {
                if (len < 1) {
                    throw new IllegalArgumentException("len<1");
                }
                int off = this.baseOffset + this.baseLen;
                this.map.put(off, Tuple2.of((Object)len, decoder));
                return new NextDecoder(this.builder, this.map, off, len);
            }

            public NextDecoder byteValue() {
                return this.byteValue(null);
            }

            public NextDecoder byteValue(Function<Integer, String> toString) {
                return this.decode(1, bytes -> toString != null ? (String)toString.apply(Integer.valueOf(bytes[0])) : Integer.toString(bytes[0]));
            }

            public NextDecoder longValue() {
                return this.longValue(true, null);
            }

            public NextDecoder longValue(Function<Long, String> toString) {
                return this.longValue(true, toString);
            }

            public NextDecoder longValue(boolean BE, Function<Long, String> toString) {
                return this.decode(8, bytes -> {
                    int off = 0;
                    int s = 1;
                    if (!BE) {
                        off = 7;
                        s = -1;
                    }
                    long v = 0L;
                    v |= (long)(bytes[off] & 0xFF) << 56;
                    v |= (long)(bytes[off += s] & 0xFF) << 48;
                    v |= (long)(bytes[off += s] & 0xFF) << 40;
                    v |= (long)(bytes[off += s] & 0xFF) << 32;
                    v |= (long)(bytes[off += s] & 0xFF) << 24;
                    v |= (long)(bytes[off += s] & 0xFF) << 16;
                    v |= (long)(bytes[off += s] & 0xFF) << 8;
                    off += s;
                    return toString != null ? (String)toString.apply(v) : Long.toString(v |= (long)(bytes[off += s] & 0xFF));
                });
            }

            public NextDecoder intValue() {
                return this.intValue(true, null);
            }

            public NextDecoder intValue(Function<Integer, String> toString) {
                return this.intValue(true, toString);
            }

            public NextDecoder intValue(boolean BE, Function<Integer, String> toString) {
                return this.decode(4, bytes -> {
                    int off = 0;
                    int s = 1;
                    if (!BE) {
                        off = 3;
                        s = -1;
                    }
                    int v = 0;
                    v |= (bytes[off] & 0xFF) << 24;
                    v |= (bytes[off += s] & 0xFF) << 16;
                    v |= (bytes[off += s] & 0xFF) << 8;
                    off += s;
                    return toString != null ? (String)toString.apply(v) : Integer.toString(v |= bytes[off += s] & 0xFF);
                });
            }

            public NextDecoder shortValue() {
                return this.shortValue(true, null);
            }

            public NextDecoder shortValue(Function<Integer, String> toString) {
                return this.shortValue(true, toString);
            }

            public NextDecoder shortValue(boolean BE, Function<Integer, String> toString) {
                return this.decode(2, bytes -> {
                    int off = 0;
                    int s = 1;
                    if (!BE) {
                        off = 1;
                        s = -1;
                    }
                    int v = 0;
                    v |= (bytes[off] & 0xFF) << 8;
                    off += s;
                    return toString != null ? (String)toString.apply(v) : Integer.toString(v |= bytes[off += s] & 0xFF);
                });
            }
        }

        public static class Decoder {
            public final Builder builder;
            public final Map<Integer, Tuple2<Integer, Function<byte[], String>>> map;

            public Decoder(Builder builder, Map<Integer, Tuple2<Integer, Function<byte[], String>>> map) {
                if (map == null) {
                    throw new IllegalArgumentException("map==null");
                }
                if (builder == null) {
                    throw new IllegalArgumentException("builder==null");
                }
                this.map = map;
                this.builder = builder;
            }

            public NextDecoder name(int off, int len, String name) {
                if (off < 0) {
                    throw new IllegalArgumentException("off<0");
                }
                if (len < 1) {
                    throw new IllegalArgumentException("len<1");
                }
                this.map.put(off, (Tuple2<Integer, Function<byte[], String>>)Tuple2.of((Object)len, b -> name));
                return new NextDecoder(this.builder, this.map, off, len);
            }

            public NextDecoder decode(int off, int len, Function<byte[], String> decoder) {
                if (off < 0) {
                    throw new IllegalArgumentException("off<0");
                }
                if (len < 1) {
                    throw new IllegalArgumentException("len<1");
                }
                this.map.put(off, (Tuple2<Integer, Function<byte[], String>>)Tuple2.of((Object)len, decoder));
                return new NextDecoder(this.builder, this.map, off, len);
            }
        }
    }

    private static class DecodeMutable
    extends Decode {
        public DecodeMutable(byte[] bytes, int offset, int length, int pointer) {
            super(bytes, offset, length, pointer);
        }

        public void setPointer(int ptr) {
            this.pointer = ptr;
        }

        public DecodeMutable pointer(int p) {
            this.setPointer(p);
            return this;
        }
    }

    public static class Decoded {
        private final int length;
        private final String message;

        public Decoded(int length, String message) {
            this.length = length;
            this.message = message;
        }

        public int getLength() {
            return this.length;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static class Decode {
        protected byte[] bytes;
        protected int offset;
        protected int length;
        protected int pointer;

        public Decode(byte[] bytes, int offset, int length, int pointer) {
            this.bytes = bytes;
            this.offset = offset;
            this.length = length;
            this.pointer = pointer;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public int getPointer() {
            return this.pointer;
        }

        public Optional<Tuple3<byte[], Integer, Integer>> lookupBytes(int len) {
            if (len < 1) {
                return Optional.empty();
            }
            int available = this.length - (this.pointer - this.offset);
            if (available < len) {
                return Optional.empty();
            }
            return Optional.of(Tuple3.of((Object)this.bytes, (Object)this.pointer, (Object)available));
        }

        public Optional<byte[]> lookup(int length) {
            Optional<Tuple3<byte[], Integer, Integer>> opt = this.lookupBytes(length);
            return opt.map(integerIntegerTuple3 -> Arrays.copyOfRange((byte[])integerIntegerTuple3.a(), (int)((Integer)integerIntegerTuple3.b()), (Integer)integerIntegerTuple3.b() + length));
        }

        public Optional<Decoded> respone(int length, String message) {
            if (length < 1) {
                throw new IllegalArgumentException("length<1");
            }
            if (message == null) {
                throw new IllegalArgumentException("message==null");
            }
            return Optional.of(new Decoded(length, message));
        }
    }
}

