/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.text.Align;
import xyz.cofe.text.Text;
import xyz.cofe.text.table.TextCell;

public class TextCellBuilder {
    protected Integer width = null;
    private Align horzAlign = null;
    private Boolean trimSpaces = null;
    private Boolean evalNewLine = null;
    private String fillAlignText = null;
    private Integer blankLineCount = null;
    private Boolean multiLine = null;
    protected String threeDots = null;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(TextCellBuilder.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(TextCellBuilder.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(TextCellBuilder.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(TextCellBuilder.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(TextCellBuilder.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(TextCellBuilder.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(TextCellBuilder.class.getName()).log(Level.SEVERE, null, ex);
    }

    public TextCellBuilder() {
    }

    public TextCellBuilder(TextCellBuilder src) {
        if (src != null) {
            this.width = src.width;
            this.horzAlign = src.horzAlign;
            this.trimSpaces = src.trimSpaces;
            this.evalNewLine = src.evalNewLine;
            this.fillAlignText = src.fillAlignText;
            this.blankLineCount = src.blankLineCount;
            this.multiLine = src.multiLine;
            this.threeDots = src.threeDots;
        }
    }

    public TextCellBuilder clone() {
        return new TextCellBuilder(this);
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Align getHorzAlign() {
        return this.horzAlign;
    }

    public void setHorzAlign(Align horzAlign) {
        this.horzAlign = horzAlign;
    }

    public Boolean isTrimSpaces() {
        return this.trimSpaces;
    }

    public void setTrimSpaces(Boolean trimSpaces) {
        this.trimSpaces = trimSpaces;
    }

    public Boolean isEvalNewLine() {
        return this.evalNewLine;
    }

    public void setEvalNewLine(Boolean evalNewLine) {
        this.evalNewLine = evalNewLine;
    }

    public String getFillAlignText() {
        return this.fillAlignText;
    }

    public void setFillAlignText(String txt) {
        this.fillAlignText = txt;
    }

    public Integer getBlankLineCount() {
        return this.blankLineCount;
    }

    public void setBlankLineCount(Integer blankLineCount) {
        this.blankLineCount = blankLineCount;
    }

    protected String getBlankLine() {
        return "";
    }

    public Boolean isMultiLine() {
        return this.multiLine;
    }

    public void setMultiLine(Boolean multiLine) {
        this.multiLine = multiLine;
    }

    public String getThreeDots() {
        return this.threeDots;
    }

    public void setThreeDots(String threeDots) {
        this.threeDots = threeDots;
    }

    protected String[] initConvertToLines(String text) {
        return new String[]{text};
    }

    protected String[] trimSpaces(String[] lines) {
        String[] res = new String[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            res[i] = lines[i].trim();
        }
        return res;
    }

    protected String[] evalNewLine(String[] srcLines) {
        ArrayList<String> res = new ArrayList<String>();
        for (String line : srcLines) {
            String[] lines = Text.splitNewLines(line);
            if (lines.length == 1) {
                res.add(line);
                continue;
            }
            if (lines.length <= 1) continue;
            int idx = -1;
            for (String sline : lines) {
                if (++idx > 0) {
                    Integer bc = this.getBlankLineCount();
                    if (bc == null || bc < 1) {
                        bc = 1;
                    }
                    for (int j = 0; j < bc; ++j) {
                        res.add(this.getBlankLine());
                    }
                }
                res.add(sline);
            }
        }
        return res.toArray(new String[0]);
    }

    protected String[] wordWrap(String[] srcLines) {
        Integer w = this.getWidth();
        if (w == null || w < 1) {
            return srcLines;
        }
        ArrayList<String> res = new ArrayList<String>();
        for (String line : srcLines) {
            String[] lines = Text.wordWrap(line, w);
            res.addAll(Arrays.asList(lines));
        }
        return res.toArray(new String[0]);
    }

    protected String[] horizAlign(String[] srcLines) {
        String fill;
        Integer w = this.getWidth();
        if (w == null || w < 1) {
            return srcLines;
        }
        Align align = this.getHorzAlign();
        if (align == null) {
            align = Align.Begin;
        }
        if ((fill = this.getFillAlignText()) == null || fill.length() < 1) {
            fill = " ";
        }
        String[] lines = Text.align(srcLines, align, fill, (int)w);
        return lines;
    }

    protected String[] buildMultiLineData(String text) {
        Boolean trimcaps;
        if (text == null) {
            throw new IllegalArgumentException("text==null");
        }
        String[] lines = this.initConvertToLines(text);
        Boolean evnewline = this.isEvalNewLine();
        lines = evnewline != null && evnewline != false ? this.evalNewLine(lines) : Text.splitNewLines(text);
        Integer w = this.getWidth();
        if (w != null && w > 0) {
            lines = this.wordWrap(lines);
        }
        if ((trimcaps = this.isTrimSpaces()) != null && trimcaps.booleanValue()) {
            lines = this.trimSpaces(lines);
        }
        if (w != null && w > 0) {
            lines = this.horizAlign(lines);
        }
        return lines;
    }

    protected String[] buildSingleLineData(String text) {
        Integer w = this.getWidth();
        if (w == null) {
            return new String[]{text};
        }
        if (w <= 0) {
            return new String[0];
        }
        String tdots = this.getThreeDots();
        String string = tdots = tdots == null ? "\u2026" : tdots;
        if (tdots.length() > 1) {
            tdots = tdots.substring(0, 1);
        }
        if (tdots.length() < 1) {
            tdots = "\u2026";
        }
        if (w < text.length()) {
            if (w == 1) {
                return new String[]{tdots};
            }
            Align a = this.getHorzAlign();
            if (a == null) {
                a = Align.Begin;
            }
            if (a == Align.Begin) {
                text = text.substring(0, w - 1) + tdots;
            } else if (a == Align.Center) {
                int diffw = text.length() - w;
                int leftw = diffw / 2;
                if ((text = text.substring(leftw)).length() > w) {
                    text = text.substring(text.length() - w, text.length());
                }
                if (text.length() > 2) {
                    text = tdots + text.substring(1, text.length() - 2) + tdots;
                } else if (text.length() == 2) {
                    text = tdots + tdots;
                } else if (text.length() == 1) {
                    text = tdots;
                }
            } else if (a == Align.End) {
                String rtext = text.substring(text.length() - w, text.length());
                text = tdots + rtext.substring(1);
            }
            return new String[]{text};
        }
        if (w > text.length()) {
            Align a = this.getHorzAlign();
            if (a == null) {
                a = Align.Begin;
            }
            String fill = this.getFillAlignText();
            String aligned = Text.align(text, a, fill, (int)w);
            return new String[]{aligned};
        }
        return new String[]{text};
    }

    protected String[] buildCellData(String text) {
        if (text == null) {
            throw new IllegalArgumentException("text==null");
        }
        Boolean ml = this.isMultiLine();
        if (ml != null && ml.booleanValue()) {
            return this.buildMultiLineData(text);
        }
        return this.buildSingleLineData(text);
    }

    public TextCell build(String text) {
        if (text == null) {
            throw new IllegalArgumentException("text==null");
        }
        String[] lines = this.buildCellData(text);
        return new TextCell(lines, text);
    }
}

