/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.text.Align;
import xyz.cofe.text.Text;
import xyz.cofe.text.table.Border;
import xyz.cofe.text.table.Borders;
import xyz.cofe.text.table.Bounds;
import xyz.cofe.text.table.TextCell;
import xyz.cofe.text.table.TextCellBuilder;

public class CellFormat {
    private final TextCellBuilder cellBuilder;
    private Border border = null;
    private Align vertAlign = null;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(CellFormat.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(CellFormat.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(CellFormat.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(CellFormat.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(CellFormat.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(CellFormat.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(CellFormat.class.getName()).log(Level.SEVERE, null, ex);
    }

    public CellFormat() {
        this.cellBuilder = new TextCellBuilder();
    }

    public CellFormat(CellFormat src) {
        TextCellBuilder textCellBuilder = this.cellBuilder = src.cellBuilder != null ? src.cellBuilder.clone() : new TextCellBuilder();
        if (src != null) {
            this.border = src.border != null ? src.border.clone() : null;
            this.vertAlign = src.vertAlign != null ? src.vertAlign : null;
        }
    }

    public CellFormat clone() {
        return new CellFormat(this);
    }

    public TextCellBuilder getCellBuilder() {
        return this.cellBuilder;
    }

    public Border getBorder() {
        return this.border;
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    public CellFormat border(Border border) {
        this.border = border;
        return this;
    }

    public Integer getWidth() {
        return this.cellBuilder.getWidth();
    }

    public void setWidth(Integer width) {
        this.cellBuilder.setWidth(width);
    }

    public CellFormat width(Integer width) {
        this.cellBuilder.setWidth(width);
        return this;
    }

    public Align getHorzAlign() {
        return this.cellBuilder.getHorzAlign();
    }

    public void setHorzAlign(Align horzAlign) {
        this.cellBuilder.setHorzAlign(horzAlign);
    }

    public CellFormat align(Align horzAlign) {
        this.cellBuilder.setHorzAlign(horzAlign);
        return this;
    }

    public Boolean isTrimSpaces() {
        return this.cellBuilder.isTrimSpaces();
    }

    public void setTrimSpaces(Boolean trimCapsSapces) {
        this.cellBuilder.setTrimSpaces(trimCapsSapces);
    }

    public CellFormat trimSpaces(Boolean trimCapsSapces) {
        this.cellBuilder.setTrimSpaces(trimCapsSapces);
        return this;
    }

    public Boolean isEvalNewLine() {
        return this.cellBuilder.isEvalNewLine();
    }

    public void setEvalNewLine(Boolean evalNewLine) {
        this.cellBuilder.setEvalNewLine(evalNewLine);
    }

    public CellFormat evalNewLine(Boolean evalNewLine) {
        this.cellBuilder.setEvalNewLine(evalNewLine);
        return this;
    }

    public String getHorzAlignText() {
        return this.cellBuilder.getFillAlignText();
    }

    public void setHorzAlignText(String txt) {
        this.cellBuilder.setFillAlignText(txt);
    }

    public CellFormat alignText(String txt) {
        this.cellBuilder.setFillAlignText(txt);
        return this;
    }

    public Integer getBlankLineCount() {
        return this.cellBuilder.getBlankLineCount();
    }

    public void setBlankLineCount(Integer blankLineCount) {
        this.cellBuilder.setBlankLineCount(blankLineCount);
    }

    public CellFormat blankLineCount(Integer blankLineCount) {
        this.cellBuilder.setBlankLineCount(blankLineCount);
        return this;
    }

    public Boolean isMultiLine() {
        return this.cellBuilder.isMultiLine();
    }

    public void setMultiLine(Boolean multiLine) {
        this.cellBuilder.setMultiLine(multiLine);
    }

    public CellFormat multiLine(Boolean multiLine) {
        this.cellBuilder.setMultiLine(multiLine);
        return this;
    }

    public Align getVertAlign() {
        return this.vertAlign;
    }

    public void setVertAlign(Align vertAlign) {
        this.vertAlign = vertAlign;
    }

    public CellFormat valign(Align vertAlign) {
        this.vertAlign = vertAlign;
        return this;
    }

    public String getThreeDots() {
        return this.cellBuilder.getThreeDots();
    }

    public void setThreeDots(String threeDots) {
        this.cellBuilder.setThreeDots(threeDots);
    }

    public CellFormat threeDots(String threeDots) {
        this.cellBuilder.setThreeDots(threeDots);
        return this;
    }

    public List<String> format(String[] text, int targetHeight) {
        ArrayList<String> lines;
        Border brd;
        block11: {
            if (text == null) {
                throw new IllegalArgumentException("text==null");
            }
            brd = this.getBorder();
            if (brd == null) {
                brd = Borders.empty();
            }
            Bounds b = Bounds.get(text);
            lines = new ArrayList<String>();
            lines.addAll(Arrays.asList(text));
            if (lines.size() >= targetHeight) break block11;
            int diff = targetHeight - lines.size();
            Align valign = this.getVertAlign();
            if (valign == null) {
                valign = Align.Begin;
            }
            if (valign == Align.Begin) {
                for (int i = 0; i < diff; ++i) {
                    lines.add(Text.repeat(" ", b.getWidth()));
                }
            } else if (valign == Align.End) {
                for (int i = 0; i < diff; ++i) {
                    lines.add(0, Text.repeat(" ", b.getWidth()));
                }
            } else {
                int i;
                int topl = diff / 2;
                int bottoml = diff - topl;
                for (i = 0; i < topl; ++i) {
                    lines.add(0, Text.repeat(" ", b.getWidth()));
                }
                for (i = 0; i < bottoml; ++i) {
                    lines.add(Text.repeat(" ", b.getWidth()));
                }
            }
        }
        return Border.format(lines, brd);
    }

    public TextCell build(String[] text, int targetHeight) {
        return new TextCell(this.format(text, targetHeight));
    }

    public CellFormat merge(CellFormat cf) {
        if (cf == null) {
            throw new IllegalArgumentException("cf==null");
        }
        CellFormat f = this.clone();
        if (cf.isEvalNewLine() != null) {
            f.setEvalNewLine(cf.isEvalNewLine());
        }
        if (cf.getBorder() != null) {
            f.setBorder(cf.getBorder());
        }
        if (cf.getWidth() != null) {
            f.setWidth(cf.getWidth());
        }
        if (cf.getHorzAlign() != null) {
            f.setHorzAlign(cf.getHorzAlign());
        }
        if (cf.isTrimSpaces() != null) {
            f.setTrimSpaces(cf.isTrimSpaces());
        }
        if (cf.getHorzAlignText() != null) {
            f.setHorzAlignText(cf.getHorzAlignText());
        }
        if (cf.getBlankLineCount() != null) {
            f.setBlankLineCount(cf.getBlankLineCount());
        }
        if (cf.isMultiLine() != null) {
            f.setMultiLine(cf.isMultiLine());
        }
        if (cf.getVertAlign() != null) {
            f.setVertAlign(cf.getVertAlign());
        }
        return f;
    }
}

