/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.table;

import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.text.table.TextCell;

public class Bounds {
    protected int width = 0;
    protected int height = 0;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(Bounds.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(Bounds.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(Bounds.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(Bounds.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(Bounds.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(Bounds.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(Bounds.class.getName()).log(Level.SEVERE, null, ex);
    }

    public Bounds(int w, int h) {
        this.width = w;
        this.height = h;
    }

    public Bounds(Bounds s) {
        if (s != null) {
            this.width = s.width;
            this.height = s.height;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Bounds clone() {
        return new Bounds(this);
    }

    public static Bounds max(TextCell ... tcells) {
        int maxHeight = -1;
        int maxWidth = -1;
        for (TextCell tc : tcells) {
            int w;
            int h = tc.getHeight();
            if (maxHeight < h) {
                maxHeight = h;
            }
            if (maxWidth >= (w = tc.getMaxWidth())) continue;
            maxWidth = w;
        }
        Bounds b = new Bounds(maxWidth, maxHeight);
        return b;
    }

    public static Bounds get(String ... lines) {
        if (lines == null) {
            throw new IllegalArgumentException("lines==null");
        }
        int w = 0;
        int h = lines.length;
        for (String line : lines) {
            if (w >= line.length()) continue;
            w = line.length();
        }
        return new Bounds(w, h);
    }
}

