/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TextBuffer
extends Reader {
    private static final Logger logger = Logger.getLogger(TextBuffer.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected StringBuilder buffer;
    protected final Random rnd = new Random();
    protected final Object bufferLock;
    protected final AtomicBoolean waitData = new AtomicBoolean(false);
    protected volatile Writer writer;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public TextBuffer(StringBuilder buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer==null");
        }
        this.buffer = buffer;
        this.bufferLock = this;
    }

    public TextBuffer(StringBuilder buffer, Object bufferLock) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer==null");
        }
        this.buffer = buffer;
        this.bufferLock = bufferLock == null ? this : bufferLock;
    }

    public TextBuffer() {
        this.buffer = new StringBuilder();
        this.bufferLock = this;
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public Object getBufferLock() {
        return this.bufferLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBufferText() {
        Object object = this.bufferLock;
        synchronized (object) {
            if (this.buffer != null) {
                return this.buffer.toString();
            }
            return null;
        }
    }

    public boolean isWaitData() {
        return this.waitData.get();
    }

    /*
     * Exception decompiling
     */
    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 10[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.bufferLock;
        synchronized (object) {
            this.buffer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String txt) {
        if (txt == null || txt.length() < 1) {
            return;
        }
        Object object = this.bufferLock;
        synchronized (object) {
            if (this.buffer == null) {
                return;
            }
            this.buffer.append(txt);
        }
    }

    public Writer createWriter() {
        return new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                TextBuffer.this.write(new String(cbuf, off, len));
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
                TextBuffer.this.close();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Writer getWriter() {
        if (this.writer != null) {
            return this.writer;
        }
        TextBuffer textBuffer = this;
        synchronized (textBuffer) {
            if (this.writer == null) {
                this.writer = this.createWriter();
            }
            return this.writer;
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

