/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.table;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.text.table.CellFormat;

public class CellFormatMap
extends LinkedHashMap<Object, CellFormat> {
    private static void logFine(String message, Object ... args) {
        Logger.getLogger(CellFormatMap.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(CellFormatMap.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(CellFormatMap.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(CellFormatMap.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(CellFormatMap.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(CellFormatMap.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(CellFormatMap.class.getName()).log(Level.SEVERE, null, ex);
    }

    @Override
    public void put(int colIndex, CellFormat cf) {
        if (cf == null) {
            throw new IllegalArgumentException("cf==null");
        }
        this.put(new ColumnIndexPredicate(colIndex), cf);
    }

    @Override
    public void put(String colName, CellFormat cf) {
        if (cf == null) {
            throw new IllegalArgumentException("cf==null");
        }
        if (colName == null) {
            throw new IllegalArgumentException("colName==null");
        }
        this.put(new ColumnNamePredicate(colName), cf);
    }

    public void put(String colName, boolean ignoreCase, CellFormat cf) {
        if (cf == null) {
            throw new IllegalArgumentException("cf==null");
        }
        if (colName == null) {
            throw new IllegalArgumentException("colName==null");
        }
        this.put(new ColumnNamePredicate(colName, ignoreCase), cf);
    }

    public CellFormatMap() {
    }

    public CellFormatMap(CellFormatMap src) {
        if (src != null) {
            this.putAll(src);
        }
    }

    @Override
    public CellFormatMap clone() {
        return new CellFormatMap(this);
    }

    public CellFormat[] getByName(String colname) {
        CellFormat[] res = new CellFormat[]{};
        if (colname == null) {
            return res;
        }
        for (Object k : this.keySet()) {
            ColumnNamePredicate cp;
            if (!(k instanceof ColumnNamePredicate) || !(cp = (ColumnNamePredicate)k).test(colname)) continue;
            res = Arrays.copyOf(res, res.length + 1);
            res[res.length - 1] = (CellFormat)this.get(k);
        }
        return res;
    }

    public CellFormat[] getByIndex(int colidx) {
        CellFormat[] res = new CellFormat[]{};
        for (Object k : this.keySet()) {
            ColumnIndexPredicate cp;
            if (!(k instanceof ColumnIndexPredicate) || !(cp = (ColumnIndexPredicate)k).test(colidx)) continue;
            res = Arrays.copyOf(res, res.length + 1);
            res[res.length - 1] = (CellFormat)this.get(k);
        }
        return res;
    }

    public static class ColumnNamePredicate
    implements Predicate<String> {
        public String columnName = null;
        public boolean ignoreCase = true;

        public ColumnNamePredicate() {
        }

        public ColumnNamePredicate(String columnName) {
            this.columnName = columnName;
        }

        public ColumnNamePredicate(String columnName, boolean ignoreCase) {
            this.columnName = columnName;
            this.ignoreCase = ignoreCase;
        }

        @Override
        public boolean test(String c) {
            if (c == null) {
                return false;
            }
            if (this.columnName == null) {
                return false;
            }
            return this.ignoreCase ? this.columnName.equalsIgnoreCase(c) : this.columnName.equals(c);
        }
    }

    public static class ColumnIndexPredicate
    implements Predicate<Integer> {
        public int columnIndex = 0;

        public ColumnIndexPredicate() {
        }

        public ColumnIndexPredicate(int colIdx) {
            this.columnIndex = colIdx;
        }

        @Override
        public boolean test(Integer c) {
            if (c == null) {
                return false;
            }
            return c == this.columnIndex;
        }
    }
}

