/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StackWriter
extends Writer {
    protected Writer output = null;
    protected Stack<Writer> stack = new Stack();

    public StackWriter(Writer output) {
        if (output == null) {
            throw new IllegalArgumentException("output==null");
        }
        this.output = output;
    }

    public Stack<Writer> getStack() {
        return this.stack;
    }

    public void push() {
        this.stack.push(this.output);
        this.output = new StringWriter();
    }

    public String pop() {
        String res = "";
        if (this.output instanceof StringWriter) {
            try {
                StringWriter s = (StringWriter)this.output;
                s.flush();
                res = s.toString();
                s.close();
            }
            catch (IOException ex) {
                Logger.getLogger(StackWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (this.stack.size() > 0) {
            this.output = this.stack.pop();
        }
        return res;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.output.write(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.output.flush();
        if (this.stack.size() > 0) {
            Writer w = this.output;
            for (int i = this.stack.size() - 1; i >= 0; --i) {
                Writer top = (Writer)this.stack.get(i);
                if (w instanceof StringWriter) {
                    StringWriter sw = (StringWriter)w;
                    sw.flush();
                    String buff = sw.toString();
                    top.write(buff);
                    sw.getBuffer().setLength(0);
                    sw.getBuffer().trimToSize();
                }
                w = top;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.output.close();
        if (this.stack.size() > 0) {
            for (int i = this.stack.size() - 1; i >= 0; --i) {
                Writer top = (Writer)this.stack.get(i);
                top.close();
            }
            this.output = (Writer)this.stack.get(0);
            this.stack.clear();
        }
    }
}

