/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.iter.Eterable;
import xyz.cofe.text.Text;
import xyz.cofe.text.table.Bounds;

public class TextCell {
    protected ArrayList<String> data = new ArrayList();
    protected String sourceText = null;
    protected int maxWidth = Integer.MIN_VALUE;
    protected int minWidth = Integer.MAX_VALUE;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(TextCell.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(TextCell.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(TextCell.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(TextCell.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(TextCell.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(TextCell.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(TextCell.class.getName()).log(Level.SEVERE, null, ex);
    }

    public TextCell(Iterable<String> data) {
        if (data == null) {
            throw new IllegalArgumentException("data==null");
        }
        this.data.addAll(Eterable.of(data).toList());
    }

    public TextCell(String[] data) {
        if (data == null) {
            throw new IllegalArgumentException("data==null");
        }
        this.data.addAll(Arrays.asList(data));
    }

    public TextCell(String[] data, String source) {
        if (data == null) {
            throw new IllegalArgumentException("data==null");
        }
        this.data.addAll(Arrays.asList(data));
        this.sourceText = source;
    }

    public String[] getTextLines() {
        return this.data.toArray(new String[0]);
    }

    protected void evalMinMaxWidth() {
        int minw = Integer.MAX_VALUE;
        int maxw = Integer.MIN_VALUE;
        for (String line : this.data) {
            int w = line.length();
            if (w > maxw) {
                maxw = w;
            }
            if (w >= minw) continue;
            minw = w;
        }
        this.maxWidth = maxw;
        this.minWidth = minw;
    }

    public int getMaxWidth() {
        if (this.maxWidth > Integer.MIN_VALUE) {
            return this.maxWidth;
        }
        this.evalMinMaxWidth();
        return this.maxWidth;
    }

    public int getMinWidth() {
        if (this.minWidth < Integer.MAX_VALUE) {
            return this.minWidth;
        }
        this.evalMinMaxWidth();
        return this.minWidth;
    }

    public int getHeight() {
        return this.data.size();
    }

    public TextCell hjoin(Iterable<TextCell> tcells) {
        Eterable cells = Eterable.of(tcells);
        Eterable single = Eterable.single((Object)this);
        cells = single.union(new Iterable[]{cells});
        return new TextCell(TextCell.horizontalJoin((Iterable<TextCell>)cells));
    }

    public TextCell hjoin(TextCell ... tcells) {
        List<TextCell> cells = Arrays.asList(tcells);
        cells.add(0, this);
        return new TextCell(TextCell.horizontalJoin(cells));
    }

    public static List<String> horizontalJoin(Iterable<TextCell> tcells) {
        return TextCell.horizontalJoin(Eterable.of(tcells).toList().toArray(new TextCell[0]));
    }

    public static TextCell horizontalJoinAsTextCell(Iterable<TextCell> tcells) {
        return new TextCell(TextCell.horizontalJoin(tcells));
    }

    public static TextCell horizontalJoinAsTextCell(TextCell ... tcells) {
        return new TextCell(TextCell.horizontalJoin(tcells));
    }

    public static List<String> horizontalJoin(TextCell ... tcells) {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        Bounds b = Bounds.max(tcells);
        for (int y = 0; y < b.getHeight(); ++y) {
            sb.setLength(0);
            for (TextCell tc : tcells) {
                String[] tcLines = tc.getTextLines();
                if (y < tcLines.length) {
                    sb.append(tcLines[y]);
                    continue;
                }
                sb.append(Text.repeat(" ", tc.getMaxWidth()));
            }
            lines.add(sb.toString());
        }
        return lines;
    }

    public static TextCell createBlock(String repeatText, int width, int height) {
        if (repeatText == null || repeatText.length() < 1) {
            repeatText = " ";
        }
        if (height < 1) {
            TextCell tc = new TextCell(new String[0]);
            return tc;
        }
        if (width < 1 && height >= 1) {
            String[] data = new String[height];
            for (int i = 0; i < height; ++i) {
                data[i] = "";
            }
            return new TextCell(data);
        }
        ArrayList<String> l = new ArrayList<String>();
        for (int y = 0; y < height; ++y) {
            String t = repeatText;
            while (t.length() < width) {
                t = t + repeatText;
            }
            if (t.length() > width) {
                t = t.substring(0, width);
            }
            l.add(t);
        }
        return new TextCell(l.toArray(new String[0]));
    }
}

