/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.text.Text;

public class LineReaderIterator
implements Iterator<String>,
Closeable {
    private static final Logger logger = Logger.getLogger(LineReaderIterator.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected Reader reader = null;
    protected char[] buff = new char[8192];
    protected String[] lines = null;
    protected final Lock lock;
    protected Consumer<Reader> closeReader = null;
    private long lineCounter = 0L;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public LineReaderIterator(Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("reader==null");
        }
        this.reader = reader;
        this.lock = new ReentrantLock();
        this.lines = this.readLines();
    }

    public LineReaderIterator(Reader reader, int bufferSize, Consumer<Reader> closeReader, Lock lock) {
        if (reader == null) {
            throw new IllegalArgumentException("reader==null");
        }
        if (bufferSize < 1) {
            throw new IllegalArgumentException("bufferSize<1");
        }
        this.buff = new char[bufferSize];
        this.lock = lock == null ? new ReentrantLock() : lock;
        this.closeReader = closeReader;
        this.reader = reader;
        this.lines = this.readLines();
    }

    public Lock getLock() {
        return this.lock;
    }

    public long getLineCounter() {
        try {
            this.lock.lock();
            long l = this.lineCounter;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String[] readLines() {
        try {
            this.lock.lock();
            StringBuilder sb = new StringBuilder();
            while (true) {
                if (this.reader == null) {
                    String[] stringArray = Text.splitNewLines(sb.toString());
                    return stringArray;
                }
                try {
                    int readed = this.reader.read(this.buff);
                    if (readed > 0) {
                        String l = new String(this.buff, 0, readed);
                        if (l.contains("\n") || l.contains("\r")) {
                            sb.append(l);
                            String[] stringArray = Text.splitNewLines(sb.toString());
                            return stringArray;
                        }
                        sb.append(l);
                        continue;
                    }
                    if (readed == 0) continue;
                    if (this.closeReader != null) {
                        this.closeReader.accept(this.reader);
                    }
                    this.reader = null;
                }
                catch (IOException ex) {
                    Logger.getLogger(LineReaderIterator.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean hasNext() {
        try {
            this.lock.lock();
            boolean bl = this.lines != null && this.lines.length > 0;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String next() {
        try {
            this.lock.lock();
            if (this.lines == null) {
                try {
                    this.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(LineReaderIterator.class.getName()).log(Level.SEVERE, null, ex);
                }
                String ex = null;
                return ex;
            }
            if (this.lines.length > 1) {
                String l = this.lines[0];
                this.lines = Arrays.copyOfRange(this.lines, 1, this.lines.length);
                ++this.lineCounter;
                String string = l;
                return string;
            }
            if (this.lines.length == 1) {
                String[] lines2 = this.readLines();
                if (lines2 == null) {
                    String r = this.lines[0];
                    this.lines = null;
                    ++this.lineCounter;
                    String string = r;
                    return string;
                }
                if (lines2.length == 0) {
                    String r = this.lines[0];
                    this.lines = null;
                    ++this.lineCounter;
                    String string = r;
                    return string;
                }
                if (lines2.length == 1) {
                    String l0 = this.lines[0];
                    String l1 = lines2[0];
                    String r = l0 + l1;
                    this.lines = null;
                    ++this.lineCounter;
                    String string = r;
                    return string;
                }
                String l0 = this.lines[0];
                String l1 = lines2[0];
                String r = l0 + l1;
                this.lines = lines2;
                this.lines = Arrays.copyOfRange(this.lines, 1, this.lines.length);
                ++this.lineCounter;
                String string = r;
                return string;
            }
            try {
                this.close();
            }
            catch (IOException ex) {
                Logger.getLogger(LineReaderIterator.class.getName()).log(Level.SEVERE, null, ex);
            }
            String string = null;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void remove() {
    }

    @Override
    public void close() throws IOException {
        try {
            this.lock.lock();
            if (this.lines != null) {
                this.lines = null;
            }
            if (this.reader != null) {
                if (this.closeReader != null) {
                    this.closeReader.accept(this.reader);
                }
                this.reader = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Throwable er) {
            LineReaderIterator.logException(er);
        }
        super.finalize();
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

