/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import xyz.cofe.text.Align;
import xyz.cofe.text.Text;

public class FullDecFormat {
    private static final Logger logger = Logger.getLogger(FullDecFormat.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private int intZeroDigits = 0;
    private int intGroupSize = -1;
    private String intGroupDelimiter = "`";
    private int floatZeroDigits = 0;
    private boolean limitFloat = true;
    private int floatGroupSize = -1;
    private String floatGroupDelimiter = "`";
    private String floatPoint = ".";
    private boolean forceFloatPoint = false;
    private String positiveSign = "";
    private String zeroSign = "";
    private String negativeSign = "-";
    private String nullValue = null;
    private String nan = "NaN";
    private String positiveInfinity = "+Inf";
    private String negativeInfinity = "-Inf";
    private int intWidth = -1;
    private Align intAlign = Align.End;
    private String intPad = " ";
    private int floatWidth = -1;
    private String floatPad = " ";
    private Align floatAlign = Align.End;
    private int signIntWidth = -1;
    private Align signIntAlign = Align.End;
    private String signIntPad = " ";
    private int width = -1;
    private Align align = Align.End;
    private String pad = " ";
    private Double multiplier;
    private Double addition;
    private static final Pattern longPtrn;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(FullDecFormat.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(FullDecFormat.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(FullDecFormat.class.getName(), method, result);
    }

    public FullDecFormat() {
    }

    public FullDecFormat(FullDecFormat sample) {
        if (sample != null) {
            this.assign(sample);
        }
    }

    public FullDecFormat(String format) {
        FullDecFormat sample = FullDecFormat.create(format);
        if (sample == null) {
            throw new IllegalArgumentException("format == null");
        }
        this.assign(sample);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void assign(FullDecFormat sample) {
        if (sample != null) {
            FullDecFormat fullDecFormat = sample;
            synchronized (fullDecFormat) {
                this.intZeroDigits = sample.intZeroDigits;
                this.intGroupSize = sample.intGroupSize;
                this.intGroupDelimiter = sample.intGroupDelimiter;
                this.floatPoint = sample.floatPoint;
                this.floatZeroDigits = sample.floatZeroDigits;
                this.floatGroupSize = sample.floatGroupSize;
                this.floatGroupDelimiter = sample.floatGroupDelimiter;
                this.forceFloatPoint = sample.forceFloatPoint;
                this.positiveInfinity = sample.positiveInfinity;
                this.negativeInfinity = sample.negativeInfinity;
                this.nan = sample.nan;
                this.nullValue = sample.nullValue;
                this.positiveSign = sample.positiveSign;
                this.negativeSign = sample.negativeSign;
                this.zeroSign = sample.zeroSign;
                this.intWidth = sample.intWidth;
                this.intAlign = sample.intAlign;
                this.intPad = sample.intPad;
                this.signIntWidth = sample.signIntWidth;
                this.signIntAlign = sample.signIntAlign;
                this.signIntPad = sample.signIntPad;
                this.width = sample.width;
                this.align = sample.align;
                this.pad = sample.pad;
                this.floatWidth = sample.floatWidth;
                this.floatPad = sample.floatPad;
                this.floatAlign = sample.floatAlign;
                this.multiplier = sample.multiplier;
                this.addition = sample.addition;
            }
        }
    }

    public synchronized FullDecFormat clone() {
        return new FullDecFormat(this);
    }

    public synchronized int getIntZeroDigits() {
        return this.intZeroDigits;
    }

    public synchronized void setIntZeroDigits(int intZeroDigits) {
        this.intZeroDigits = intZeroDigits;
    }

    public synchronized int getIntGroupSize() {
        return this.intGroupSize;
    }

    public synchronized void setIntGroupSize(int intGroupSize) {
        this.intGroupSize = intGroupSize;
    }

    public synchronized String getIntGroupDelimiter() {
        return this.intGroupDelimiter;
    }

    public synchronized void setIntGroupDelimiter(String intGroupDelimiter) {
        this.intGroupDelimiter = intGroupDelimiter;
    }

    public synchronized int getFloatZeroDigits() {
        return this.floatZeroDigits;
    }

    public synchronized void setFloatZeroDigits(int floatZeroDigits) {
        this.floatZeroDigits = floatZeroDigits;
    }

    public synchronized boolean isLimitFloat() {
        return this.limitFloat;
    }

    public synchronized void setLimitFloat(boolean limitFloat) {
        this.limitFloat = limitFloat;
    }

    public synchronized int getFloatGroupSize() {
        return this.floatGroupSize;
    }

    public synchronized void setFloatGroupSize(int floatGroupSize) {
        this.floatGroupSize = floatGroupSize;
    }

    public synchronized String getFloatGroupDelimiter() {
        return this.floatGroupDelimiter;
    }

    public synchronized void setFloatGroupDelimiter(String floatGroupDelimiter) {
        this.floatGroupDelimiter = floatGroupDelimiter;
    }

    public synchronized String getFloatPoint() {
        return this.floatPoint;
    }

    public synchronized void setFloatPoint(String floatPoint) {
        this.floatPoint = floatPoint;
    }

    public synchronized boolean isForceFloatPoint() {
        return this.forceFloatPoint;
    }

    public synchronized void setForceFloatPoint(boolean forceFloatPoint) {
        this.forceFloatPoint = forceFloatPoint;
    }

    public synchronized String getPositiveSign() {
        return this.positiveSign;
    }

    public synchronized void setPositiveSign(String positiveSign) {
        this.positiveSign = positiveSign;
    }

    public synchronized String getZeroSign() {
        return this.zeroSign;
    }

    public synchronized void setZeroSign(String zeroSign) {
        this.zeroSign = zeroSign;
    }

    public synchronized String getNegativeSign() {
        return this.negativeSign;
    }

    public synchronized void setNegativeSign(String negativeSign) {
        this.negativeSign = negativeSign;
    }

    public synchronized String getNullValue() {
        return this.nullValue;
    }

    public synchronized void setNullValue(String nullValue) {
        this.nullValue = nullValue;
    }

    public synchronized String getNan() {
        return this.nan;
    }

    public synchronized void setNan(String nan) {
        this.nan = nan;
    }

    public synchronized String getPositiveInfinity() {
        return this.positiveInfinity;
    }

    public synchronized void setPositiveInfinity(String positiveInfinity) {
        this.positiveInfinity = positiveInfinity;
    }

    public synchronized String getNegativeInfinity() {
        return this.negativeInfinity;
    }

    public synchronized void setNegativeInfinity(String negativeInfinity) {
        this.negativeInfinity = negativeInfinity;
    }

    public synchronized int getIntWidth() {
        return this.intWidth;
    }

    public synchronized void setIntWidth(int intWidth) {
        this.intWidth = intWidth;
    }

    public synchronized Align getIntAlign() {
        return this.intAlign;
    }

    public synchronized void setIntAlign(Align intAlign) {
        this.intAlign = intAlign;
    }

    public synchronized String getIntPad() {
        return this.intPad;
    }

    public synchronized void setIntPad(String intPad) {
        this.intPad = intPad;
    }

    public synchronized int getFloatWidth() {
        return this.floatWidth;
    }

    public synchronized void setFloatWidth(int floatWidth) {
        this.floatWidth = floatWidth;
    }

    public synchronized String getFloatPad() {
        return this.floatPad;
    }

    public synchronized void setFloatPad(String floatPad) {
        this.floatPad = floatPad;
    }

    public synchronized Align getFloatAlign() {
        return this.floatAlign;
    }

    public synchronized void setFloatAlign(Align floatAlign) {
        this.floatAlign = floatAlign;
    }

    public synchronized int getSignIntWidth() {
        return this.signIntWidth;
    }

    public synchronized void setSignIntWidth(int signIntWidth) {
        this.signIntWidth = signIntWidth;
    }

    public synchronized Align getSignIntAlign() {
        return this.signIntAlign;
    }

    public synchronized void setSignIntAlign(Align signIntAlign) {
        this.signIntAlign = signIntAlign;
    }

    public synchronized String getSignIntPad() {
        return this.signIntPad;
    }

    public synchronized void setSignIntPad(String signIntPad) {
        this.signIntPad = signIntPad;
    }

    public synchronized int getWidth() {
        return this.width;
    }

    public synchronized void setWidth(int width) {
        this.width = width;
    }

    public synchronized Align getAlign() {
        return this.align;
    }

    public synchronized void setAlign(Align align) {
        this.align = align;
    }

    public synchronized String getPad() {
        return this.pad;
    }

    public synchronized void setPad(String pad) {
        this.pad = pad;
    }

    public synchronized Double getMultiplier() {
        return this.multiplier;
    }

    public synchronized void setMultiplier(Double multiplier) {
        this.multiplier = multiplier;
    }

    public synchronized Double getAddition() {
        return this.addition;
    }

    public synchronized void setAddition(Double addition) {
        this.addition = addition;
    }

    public synchronized String format(Number num) {
        int ci;
        int i;
        int ci2;
        int padZero;
        String[] strParts;
        DecimalFormat df;
        String str;
        if (num == null) {
            return this.nullValue;
        }
        if (num instanceof Double) {
            if (((Double)num).isNaN()) {
                return this.nan;
            }
            if (((Double)num).isInfinite() && Objects.equals(num, Double.POSITIVE_INFINITY)) {
                return this.positiveInfinity;
            }
            if (((Double)num).isInfinite() && Objects.equals(num, Double.NEGATIVE_INFINITY)) {
                return this.negativeInfinity;
            }
        }
        if (num instanceof Float) {
            if (((Float)num).isNaN()) {
                return this.nan;
            }
            if (((Float)num).isInfinite() && Objects.equals(num, Float.valueOf(Float.POSITIVE_INFINITY))) {
                return this.positiveInfinity;
            }
            if (((Float)num).isInfinite() && Objects.equals(num, Float.valueOf(Float.NEGATIVE_INFINITY))) {
                return this.negativeInfinity;
            }
        }
        if (this.multiplier != null) {
            num = num.doubleValue() * this.multiplier;
        }
        if (this.addition != null) {
            num = num.doubleValue() + this.addition;
        }
        String dfFloat = "######################################################################################################################";
        if (this.floatZeroDigits >= 0 && this.limitFloat) {
            int cnt = this.floatZeroDigits;
            if (this.floatWidth > 0 && this.floatZeroDigits < this.floatWidth) {
                cnt = this.floatWidth;
            }
            dfFloat = Text.repeat("#", cnt);
        }
        if ((str = (df = new DecimalFormat("#." + dfFloat, new DecimalFormatSymbols(Locale.US))).format(num)).startsWith("-")) {
            str = Text.trimStart(str, "-");
        }
        if ((strParts = Text.split(str, ".")).length == 1) {
            strParts = new String[]{strParts[0], ""};
        }
        StringBuilder intstr = new StringBuilder();
        intstr.append(strParts[0]);
        StringBuilder floatstr = new StringBuilder();
        floatstr.append(strParts[1]);
        if (this.intZeroDigits > intstr.length()) {
            padZero = this.intZeroDigits - intstr.length();
            for (ci2 = 0; ci2 < padZero; ++ci2) {
                intstr.insert(0, "0");
            }
        }
        if (this.intGroupSize > 0 && this.intGroupDelimiter != null && this.intGroupDelimiter.length() > 0) {
            StringBuilder sb = new StringBuilder();
            i = -1;
            for (ci = intstr.length() - 1; ci >= 0; --ci) {
                if (++i > 0) {
                    if (this.intGroupSize == 1) {
                        sb.insert(0, this.intGroupDelimiter);
                    } else if (i % this.intGroupSize == 0) {
                        sb.insert(0, this.intGroupDelimiter);
                    }
                    sb.insert(0, intstr.charAt(ci));
                    continue;
                }
                sb.insert(0, intstr.charAt(ci));
            }
            intstr = sb;
        }
        if (this.floatZeroDigits > floatstr.length()) {
            padZero = this.floatZeroDigits - floatstr.length();
            for (ci2 = 0; ci2 < padZero; ++ci2) {
                floatstr.append("0");
            }
        }
        if (this.floatGroupSize > 0 && this.floatGroupDelimiter != null && this.floatGroupDelimiter.length() > 0) {
            StringBuilder sb = new StringBuilder();
            i = -1;
            for (ci = 0; ci <= floatstr.length() - 1; ++ci) {
                if (++i > 0) {
                    if (this.floatGroupSize == 1) {
                        sb.append(this.floatGroupDelimiter);
                    } else if (i % this.floatGroupSize == 0) {
                        sb.append(this.floatGroupDelimiter);
                    }
                    sb.append(floatstr.charAt(ci));
                    continue;
                }
                sb.append(floatstr.charAt(ci));
            }
            floatstr = sb;
        }
        if (this.floatWidth > 0 && this.floatWidth > floatstr.length() && this.floatPad != null && this.floatPad.length() > 0 && this.floatAlign != null) {
            int padCnt;
            int padLeftCnt = padCnt = this.floatWidth - floatstr.length();
            int padRightCnt = 0;
            if (this.floatAlign == Align.Center) {
                padLeftCnt = padCnt / 2;
                padRightCnt = padCnt - padLeftCnt;
            } else if (this.floatAlign == Align.End) {
                padRightCnt = padCnt;
                padLeftCnt = 0;
            }
            String padLeft = Text.align("", Align.Begin, this.floatPad, padLeftCnt, true);
            String padRight = Text.align("", Align.Begin, this.floatPad, padRightCnt, true);
            String s = floatstr.toString();
            floatstr.setLength(0);
            floatstr.append(padLeft);
            floatstr.append(s);
            floatstr.append(padRight);
        }
        if (this.intWidth > 0 && this.intAlign != null && this.intPad != null && this.intPad.length() > 0 && this.intWidth > intstr.length()) {
            String s = Text.align(intstr.toString(), this.intAlign, this.intPad, this.intWidth, true);
            intstr.setLength(0);
            intstr.append(s);
        }
        StringBuilder res = new StringBuilder();
        res.append((CharSequence)intstr);
        if (num.doubleValue() < 0.0 && this.negativeSign != null) {
            res.insert(0, this.negativeSign);
        } else if (num.doubleValue() > 0.0 && this.positiveSign != null) {
            res.insert(0, this.positiveSign);
        } else if (this.zeroSign != null) {
            res.insert(0, this.zeroSign);
        }
        if (this.signIntWidth > 0 && this.signIntAlign != null && this.signIntPad != null && this.signIntPad.length() > 0 && this.signIntWidth > res.length()) {
            String s = Text.align(res.toString(), this.signIntAlign, this.signIntPad, this.signIntWidth, true);
            res.setLength(0);
            res.append(s);
        }
        if (this.floatPoint != null) {
            if (this.forceFloatPoint) {
                res.append(this.floatPoint);
            } else if (floatstr.toString().trim().length() > 0) {
                res.append(this.floatPoint);
            } else if (floatstr.toString().length() > 0) {
                res.append(Text.repeat(" ", this.floatPoint.length()));
            }
        }
        res.append((CharSequence)floatstr);
        if (this.width > 0 && this.align != null && this.pad != null && this.pad.length() > 0 && this.width > res.length()) {
            int padCnt;
            int padLeftCnt = padCnt = this.width - res.length();
            int padRightCnt = 0;
            if (this.align == Align.Center) {
                padLeftCnt = padCnt / 2;
                padRightCnt = padCnt - padLeftCnt;
            } else if (this.align == Align.End) {
                padRightCnt = padCnt;
                padLeftCnt = 0;
            }
            String padLeft = Text.align("", Align.Begin, this.pad, padLeftCnt, true);
            String padRight = Text.align("", Align.Begin, this.pad, padRightCnt, true);
            String s = res.toString();
            res.setLength(0);
            res.append(padLeft);
            res.append(s);
            res.append(padRight);
        }
        return res.toString();
    }

    private static int countOf(String str, String find) {
        int f;
        if (find == null || find.length() == 0) {
            return 0;
        }
        if (str == null || str.length() == 0) {
            return 0;
        }
        int from = 0;
        int cnt = 0;
        while ((f = str.indexOf(find, from)) >= 0) {
            from = f + find.length();
            ++cnt;
        }
        return cnt;
    }

    public static FullDecFormat create(String format) {
        String fpoint;
        int cntFloatDummy;
        String num2;
        int cntFloatZero;
        if (format == null) {
            throw new IllegalArgumentException("format==null");
        }
        FullDecFormat fmt = new FullDecFormat();
        Matcher m = longPtrn.matcher(format);
        if (!m.matches()) {
            return null;
        }
        String kof = m.group("kof");
        String shiftNum = m.group("shiftNum");
        if (kof != null && kof.length() > 0) {
            fmt.multiplier = Double.parseDouble(kof);
        }
        if (shiftNum != null && shiftNum.length() > 0) {
            fmt.addition = Double.parseDouble(shiftNum);
        }
        String signIntAlign = m.group("a1");
        String signIntWidth = m.group("ac1");
        String align = m.group("a2");
        String width = m.group("ac2");
        String sign = m.group("sign");
        if ("+".equals(sign)) {
            fmt.setNegativeSign("-");
            fmt.setZeroSign(" ");
            fmt.setPositiveSign("+");
        } else {
            fmt.setNegativeSign("-");
            fmt.setZeroSign("");
            fmt.setPositiveSign("");
        }
        String num1 = m.group("num1");
        int cntIntZero = FullDecFormat.countOf(num1, "0");
        int cntIntDummy = FullDecFormat.countOf(num1, "#");
        int cntWidthAdd = 0;
        if ("+".equals(sign)) {
            ++cntWidthAdd;
        }
        if (cntIntZero > 0 && cntIntDummy == 0) {
            fmt.setIntZeroDigits(cntIntZero);
        } else if (cntIntZero == 0 && cntIntDummy > 0) {
            fmt.setSignIntWidth(cntIntDummy + cntWidthAdd);
        } else if (cntIntZero > 0 && cntIntDummy > 0 && (signIntAlign == null || signIntAlign.length() < 1)) {
            fmt.setSignIntWidth(cntIntZero + cntIntDummy + cntWidthAdd);
            fmt.setIntZeroDigits(cntIntZero);
        }
        int num1grpStart1 = num1.lastIndexOf("`");
        int num1grpStart2 = num1.lastIndexOf(" ");
        int num1grpStart = Math.max(num1grpStart1, num1grpStart2);
        if (num1grpStart >= 0 && num1grpStart < num1.length() - 1) {
            String grp = num1.substring(num1grpStart + 1);
            if (grp.length() > 0) {
                fmt.setIntGroupSize(grp.length());
                fmt.setFloatGroupSize(grp.length());
            }
            if (num1grpStart2 > num1grpStart1) {
                fmt.setIntGroupDelimiter(" ");
                fmt.setFloatGroupDelimiter(" ");
            }
        }
        if ((cntFloatZero = FullDecFormat.countOf(num2 = m.group("num2"), "0")) > 0) {
            fmt.setFloatZeroDigits(cntFloatZero);
        }
        if ((cntFloatDummy = FullDecFormat.countOf(num2, "#")) > 0 && cntFloatZero == 0) {
            fmt.setLimitFloat(false);
            fmt.setFloatWidth(cntFloatDummy);
            fmt.setForceFloatPoint(false);
        } else if (cntFloatDummy == 0 && cntFloatZero > 0) {
            fmt.setLimitFloat(true);
            fmt.setFloatZeroDigits(cntFloatZero);
            fmt.setFloatWidth(cntFloatZero);
        } else if (cntFloatDummy > 0 && cntFloatZero > 0) {
            fmt.setLimitFloat(true);
            int s = cntFloatDummy + cntFloatZero;
            fmt.setFloatZeroDigits(cntFloatZero);
            fmt.setFloatWidth(s);
        } else if (cntFloatDummy == 0 && cntFloatZero == 0) {
            fmt.setLimitFloat(true);
            fmt.setFloatZeroDigits(0);
            fmt.setFloatWidth(0);
        }
        int num2grpStart1 = num2 == null ? -1 : num2.lastIndexOf("`");
        int num2grpStart2 = num2 == null ? -1 : num2.lastIndexOf(" ");
        int num2grpStart = Math.max(num2grpStart1, num2grpStart2);
        if (num2grpStart >= 0 && num2 != null && num2grpStart < num2.length() - 1) {
            String grp = num2.substring(num2grpStart + 1);
            if (grp.length() > 0) {
                fmt.setFloatGroupSize(grp.length());
            }
            if (num1grpStart2 > num1grpStart1) {
                fmt.setFloatGroupDelimiter(" ");
            }
        }
        if ((fpoint = m.group("fpoint")) != null && fpoint.length() > 0) {
            fmt.setFloatPoint(fpoint);
        }
        if (signIntAlign != null && signIntAlign.length() > 0 && signIntWidth != null && signIntWidth.length() > 0) {
            fmt.setSignIntWidth(Integer.parseInt(signIntWidth));
            if ("<".equals(signIntAlign)) {
                fmt.setSignIntAlign(Align.Begin);
            } else if ("=".equals(signIntAlign)) {
                fmt.setSignIntAlign(Align.Center);
            } else if (">".equals(signIntAlign)) {
                fmt.setSignIntAlign(Align.End);
            }
        }
        if (align != null && align.length() > 0 && width != null && width.length() > 0) {
            fmt.setWidth(Integer.parseInt(width));
            if ("<".equals(align)) {
                fmt.setAlign(Align.End);
            } else if ("=".equals(align)) {
                fmt.setAlign(Align.Center);
            } else if (">".equals(align)) {
                fmt.setAlign(Align.Begin);
            }
        }
        return fmt;
    }

    public synchronized Double parseDouble(String str) {
        if (str == null) {
            throw new IllegalArgumentException("str==null");
        }
        str = str.replaceAll(" +", "");
        Double d = Double.parseDouble(str);
        if (this.addition != null) {
            d = d - this.addition;
        }
        if (this.multiplier != null) {
            if (this.multiplier == 0.0) {
                return Double.NaN;
            }
            d = d / this.multiplier;
        }
        return d;
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
        longPtrn = Pattern.compile("(?is)^(?<sign>\\+)?(?<num1>[0\\#` ]+)((?<a1><|>|=)(?<ac1>\\d+))?((?<fpoint>\\,|\\.)(?<num2>[0\\#` ]+))?((?<a2><|>|=)(?<ac2>\\d+))?(\\*(?<kof>[\\+\\-]?\\d+(\\.\\d+)?)(?<shiftNum>[\\+\\-]\\d+(\\.\\d+)?)?)?");
    }
}

