/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.table;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.text.table.Border;
import xyz.cofe.text.table.Borders;
import xyz.cofe.text.table.Bounds;
import xyz.cofe.text.table.CellFormat;
import xyz.cofe.text.table.CellFormatMap;
import xyz.cofe.text.table.CellFormats;
import xyz.cofe.text.table.RowFormat;
import xyz.cofe.text.table.RowFormats;
import xyz.cofe.text.table.TextCell;

public class TableFormat {
    protected boolean headerVisible = true;
    private Border border = Borders.empty().clone();
    private RowFormat header = null;
    private RowFormat firstRow = null;
    private RowFormat middleRow = null;
    private RowFormat lastRow = null;
    private CellFormat defaultCell = CellFormats.def().clone();
    private CellFormat firstCell = null;
    private CellFormat lastCell = null;
    private CellFormat middleCell = null;
    private CellFormatMap cellFormatMap = null;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(TableFormat.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(TableFormat.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(TableFormat.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(TableFormat.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(TableFormat.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(TableFormat.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(TableFormat.class.getName()).log(Level.SEVERE, null, ex);
    }

    public TableFormat() {
    }

    public TableFormat(TableFormat src) {
        if (src != null) {
            this.border = src.border != null ? src.border.clone() : this.border;
            this.headerVisible = src.headerVisible;
            this.defaultCell = src.defaultCell != null ? src.defaultCell.clone() : this.defaultCell;
            this.firstCell = src.firstCell != null ? src.firstCell.clone() : this.firstCell;
            this.lastCell = src.lastCell != null ? src.lastCell.clone() : this.lastCell;
            CellFormat cellFormat = this.middleCell = src.middleCell != null ? src.middleCell.clone() : this.middleCell;
            if (src.cellFormatMap != null) {
                this.cellFormatMap = src.cellFormatMap.clone();
            }
            RowFormat rowFormat = this.header = src.header != null ? src.header.clone() : this.header;
            if (this.header != null) {
                if (this.defaultCell != null) {
                    this.header.setDefaultCell(this.defaultCell);
                }
                if (this.firstCell != null) {
                    this.header.setFirstCell(this.firstCell);
                }
                if (this.lastCell != null) {
                    this.header.setLastCell(this.lastCell);
                }
                if (this.middleCell != null) {
                    this.header.setMiddleCell(this.middleCell);
                }
                if (this.cellFormatMap != null) {
                    this.header.setCellFormatMap(this.cellFormatMap);
                }
            }
            RowFormat rowFormat2 = this.firstRow = src.firstRow != null ? src.firstRow.clone() : this.firstRow;
            if (this.firstRow != null) {
                if (this.defaultCell != null) {
                    this.firstRow.setDefaultCell(this.defaultCell);
                }
                if (this.firstCell != null) {
                    this.firstRow.setFirstCell(this.firstCell);
                }
                if (this.lastCell != null) {
                    this.firstRow.setLastCell(this.lastCell);
                }
                if (this.middleCell != null) {
                    this.firstRow.setMiddleCell(this.middleCell);
                }
                if (this.cellFormatMap != null) {
                    this.firstRow.setCellFormatMap(this.cellFormatMap);
                }
            }
            RowFormat rowFormat3 = this.middleRow = src.middleRow != null ? src.middleRow.clone() : this.middleRow;
            if (this.middleRow != null) {
                if (this.defaultCell != null) {
                    this.middleRow.setDefaultCell(this.defaultCell);
                }
                if (this.firstCell != null) {
                    this.middleRow.setFirstCell(this.firstCell);
                }
                if (this.lastCell != null) {
                    this.middleRow.setLastCell(this.lastCell);
                }
                if (this.middleCell != null) {
                    this.middleRow.setMiddleCell(this.middleCell);
                }
                if (this.cellFormatMap != null) {
                    this.middleRow.setCellFormatMap(this.cellFormatMap);
                }
            }
            RowFormat rowFormat4 = this.lastRow = src.lastRow != null ? src.lastRow.clone() : this.lastRow;
            if (this.lastRow != null) {
                if (this.defaultCell != null) {
                    this.lastRow.setDefaultCell(this.defaultCell);
                }
                if (this.firstCell != null) {
                    this.lastRow.setFirstCell(this.firstCell);
                }
                if (this.lastCell != null) {
                    this.lastRow.setLastCell(this.lastCell);
                }
                if (this.middleCell != null) {
                    this.lastRow.setMiddleCell(this.middleCell);
                }
                if (this.cellFormatMap != null) {
                    this.lastRow.setCellFormatMap(this.cellFormatMap);
                }
            }
        }
    }

    public TableFormat clone() {
        return new TableFormat(this);
    }

    public boolean isHeaderVisible() {
        return this.headerVisible;
    }

    public void setHeaderVisible(boolean headerVisible) {
        this.headerVisible = headerVisible;
    }

    public Border getBorder() {
        return this.border;
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    public RowFormat getHeader() {
        if (this.header != null) {
            return this.header;
        }
        this.header = RowFormats.singleRow().clone();
        this.header.setCellFormatMap(this.getCellFormatMap());
        this.header.setDefaultCell(this.getDefaultCell());
        this.header.setFirstCell(this.getFirstCell());
        this.header.setMiddleCell(this.getMiddleCell());
        this.header.setLastCell(this.getLastCell());
        this.header.getBorder().setLeftBottomText("\u255e");
        this.header.getBorder().setRightBottomText("\u2561");
        this.header.getBorder().setBottomText("\u2550");
        this.header.getVerticalSplitter().setBottomText("\u256a");
        return this.header;
    }

    public void setHeader(RowFormat header) {
        this.header = header;
    }

    public RowFormat getFirstRow() {
        if (this.firstRow != null) {
            return this.firstRow;
        }
        this.firstRow = RowFormats.singleRow().clone();
        this.firstRow.setCellFormatMap(this.getCellFormatMap());
        this.firstRow.setDefaultCell(this.getDefaultCell());
        this.firstRow.setFirstCell(this.getFirstCell());
        this.firstRow.setMiddleCell(this.getMiddleCell());
        this.firstRow.setLastCell(this.getLastCell());
        this.firstRow.getBorder().setTopHeight(0);
        this.firstRow.getBorder().setLeftBottomText("\u251c");
        this.firstRow.getBorder().setRightBottomText("\u2524");
        this.firstRow.getVerticalSplitter().setBottomText("\u253c");
        return this.firstRow;
    }

    public void setFirstRow(RowFormat firstRow) {
        this.firstRow = firstRow;
    }

    public RowFormat getMiddleRow() {
        if (this.middleRow != null) {
            return this.middleRow;
        }
        this.middleRow = RowFormats.singleRow().clone();
        this.middleRow.setCellFormatMap(this.getCellFormatMap());
        this.middleRow.setDefaultCell(this.getDefaultCell());
        this.middleRow.setFirstCell(this.getFirstCell());
        this.middleRow.setMiddleCell(this.getMiddleCell());
        this.middleRow.setLastCell(this.getLastCell());
        this.middleRow.getBorder().setTopHeight(0);
        this.middleRow.getBorder().setLeftBottomText("\u251c");
        this.middleRow.getBorder().setRightBottomText("\u2524");
        this.middleRow.getVerticalSplitter().setBottomText("\u253c");
        return this.middleRow;
    }

    public void setMiddleRow(RowFormat middleRow) {
        this.middleRow = middleRow;
    }

    public RowFormat getLastRow() {
        if (this.lastRow != null) {
            return this.lastRow;
        }
        this.lastRow = RowFormats.singleRow().clone();
        this.lastRow.setCellFormatMap(this.getCellFormatMap());
        this.lastRow.setDefaultCell(this.getDefaultCell());
        this.lastRow.setFirstCell(this.getFirstCell());
        this.lastRow.setMiddleCell(this.getMiddleCell());
        this.lastRow.setLastCell(this.getLastCell());
        this.lastRow.getBorder().setTopHeight(0);
        return this.lastRow;
    }

    public void setLastRow(RowFormat lastRow) {
        this.lastRow = lastRow;
    }

    public CellFormat getDefaultCell() {
        if (this.defaultCell != null) {
            return this.defaultCell;
        }
        this.defaultCell = CellFormats.def().clone();
        return this.defaultCell;
    }

    public void setDefaultCell(CellFormat defaultCell) {
        this.defaultCell = defaultCell;
    }

    public CellFormat getFirstCell() {
        if (this.firstCell != null) {
            return this.firstCell;
        }
        this.firstCell = this.getDefaultCell();
        return this.firstCell;
    }

    public void setFirstCell(CellFormat firstCell) {
        this.firstCell = firstCell;
    }

    public CellFormat getLastCell() {
        if (this.lastCell != null) {
            return this.lastCell;
        }
        this.lastCell = this.getDefaultCell();
        return this.lastCell;
    }

    public void setLastCell(CellFormat lastCell) {
        this.lastCell = lastCell;
    }

    public CellFormat getMiddleCell() {
        if (this.middleCell != null) {
            return this.middleCell;
        }
        this.middleCell = this.getDefaultCell();
        return this.middleCell;
    }

    public void setMiddleCell(CellFormat middleCell) {
        this.middleCell = middleCell;
    }

    public CellFormatMap getCellFormatMap() {
        if (this.cellFormatMap != null) {
            return this.cellFormatMap;
        }
        this.cellFormatMap = new CellFormatMap();
        return this.cellFormatMap;
    }

    public void setCellFormatMap(CellFormatMap cellFormatMap) {
        this.cellFormatMap = cellFormatMap;
    }

    public List<String> formatHeader(String ... labels) {
        return this.formatHeader(labels, (String[])null);
    }

    public List<String> formatHeader(String[] labels, String[] columnNames) {
        if (!this.isHeaderVisible()) {
            return new ArrayList<String>();
        }
        if (labels == null) {
            throw new IllegalArgumentException("labels==null");
        }
        List<String> headerLines = this.getHeader().format(labels, columnNames);
        Border brd = this.getBorder();
        if (brd == null) {
            return headerLines;
        }
        if (brd.isEmpty()) {
            return headerLines;
        }
        TextCell headerTextCell = new TextCell(headerLines);
        Bounds headerBounds = Bounds.get(headerTextCell);
        ArrayList<String> out = new ArrayList<String>();
        if (brd.getTopHeight() > 0) {
            out.addAll(TextCell.joinAsList(brd.getLeftTopCell(), brd.getTopCell(headerBounds), brd.getRightTopCell()));
        }
        out.addAll(TextCell.joinAsList(brd.getLeftCell(headerBounds), headerTextCell, brd.getRightCell(headerBounds)));
        return out;
    }

    public List<String> formatFirstRow(String ... data) {
        return this.formatFirstRow(data, (String[])null);
    }

    public List<String> formatFirstRow(String[] data, String[] columnNames) {
        if (data == null) {
            throw new IllegalArgumentException("labels==null");
        }
        List<String> dataLines = this.getFirstRow().format(data, columnNames);
        Border brd = this.getBorder();
        if (brd == null) {
            return dataLines;
        }
        if (brd.isEmpty()) {
            return dataLines;
        }
        TextCell dataTextCell = new TextCell(dataLines);
        Bounds dataBounds = Bounds.get(dataTextCell);
        ArrayList<String> out = new ArrayList<String>();
        out.addAll(TextCell.joinAsList(brd.getLeftCell(dataBounds), dataTextCell, brd.getRightCell(dataBounds)));
        return out;
    }

    public List<String> formatMiddleRow(String ... data) {
        return this.formatMiddleRow(data, (String[])null);
    }

    public List<String> formatMiddleRow(String[] data, String[] columnNames) {
        if (data == null) {
            throw new IllegalArgumentException("labels==null");
        }
        List<String> dataLines = this.getMiddleRow().format(data, columnNames);
        Border brd = this.getBorder();
        if (brd == null) {
            return dataLines;
        }
        if (brd.isEmpty()) {
            return dataLines;
        }
        TextCell dataTextCell = new TextCell(dataLines);
        Bounds dataBounds = Bounds.get(dataTextCell);
        ArrayList<String> out = new ArrayList<String>();
        out.addAll(TextCell.joinAsList(brd.getLeftCell(dataBounds), dataTextCell, brd.getRightCell(dataBounds)));
        return out;
    }

    public List<String> formatLastRow(String ... data) {
        return this.formatLastRow(data, (String[])null);
    }

    public List<String> formatLastRow(String[] data, String[] columnNames) {
        if (data == null) {
            throw new IllegalArgumentException("labels==null");
        }
        List<String> dataLines = this.getLastRow().format(data, columnNames);
        Border brd = this.getBorder();
        if (brd == null) {
            return dataLines;
        }
        if (brd.isEmpty()) {
            return dataLines;
        }
        TextCell dataTextCell = new TextCell(dataLines);
        Bounds dataBounds = Bounds.get(dataTextCell);
        ArrayList<String> out = new ArrayList<String>();
        out.addAll(TextCell.joinAsList(brd.getLeftCell(dataBounds), dataTextCell, brd.getRightCell(dataBounds)));
        if (brd.getBottomHeigth() > 0) {
            out.addAll(TextCell.joinAsList(brd.getLeftBottomCell(), brd.getBottomCell(dataBounds), brd.getRightBottomCell()));
        }
        return out;
    }
}

