/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.parser.lex;

import xyz.cofe.text.parser.TokenParser;
import xyz.cofe.text.parser.lex.NumberConst;

public class NumberConstParser
implements TokenParser {
    protected int radix = 10;
    protected boolean isFloat = false;
    protected String id = null;

    public NumberConstParser() {
    }

    public NumberConstParser(int radix, boolean isFloat) {
        if (radix < 2 || radix > 16) {
            throw new IllegalArgumentException("radix<2||radix>16");
        }
        this.radix = radix;
        this.isFloat = isFloat;
    }

    public NumberConstParser(String id, int radix, boolean isFloat) {
        this.id = id;
        if (radix < 2 || radix > 16) {
            throw new IllegalArgumentException("radix<2||radix>16");
        }
        this.radix = radix;
        this.isFloat = isFloat;
    }

    protected static int getDigit(char c, int radix) {
        if (radix < 2 || radix > 16) {
            return -2;
        }
        switch (c) {
            case '0': {
                if (radix < 2) break;
                return 0;
            }
            case '1': {
                if (radix < 2) break;
                return 1;
            }
            case '2': {
                if (radix < 3) break;
                return 2;
            }
            case '3': {
                if (radix < 4) break;
                return 3;
            }
            case '4': {
                if (radix < 5) break;
                return 4;
            }
            case '5': {
                if (radix < 6) break;
                return 5;
            }
            case '6': {
                if (radix < 7) break;
                return 6;
            }
            case '7': {
                if (radix < 8) break;
                return 7;
            }
            case '8': {
                if (radix < 9) break;
                return 8;
            }
            case '9': {
                if (radix < 10) break;
                return 9;
            }
            case 'A': 
            case 'a': {
                if (radix < 11) break;
                return 10;
            }
            case 'B': 
            case 'b': {
                if (radix < 12) break;
                return 11;
            }
            case 'C': 
            case 'c': {
                if (radix < 13) break;
                return 12;
            }
            case 'D': 
            case 'd': {
                if (radix < 14) break;
                return 13;
            }
            case 'E': 
            case 'e': {
                if (radix < 15) break;
                return 14;
            }
            case 'F': 
            case 'f': {
                if (radix < 16) break;
                return 15;
            }
        }
        return -1;
    }

    protected NumberConst createNumberConst() {
        return new NumberConst();
    }

    @Override
    public NumberConst parse(String source, int offset) {
        if (source == null) {
            throw new IllegalArgumentException("source==null");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset<0");
        }
        StringBuilder intPartSB = new StringBuilder();
        StringBuilder floatPartSB = new StringBuilder();
        boolean state = false;
        int idx = -1;
        while (++idx + offset < source.length()) {
            char c = source.charAt(idx + offset);
            int d = NumberConstParser.getDigit(c, this.radix);
            if (d < 0) {
                if (this.isFloat && c == '.' && !state) {
                    state = true;
                    continue;
                }
                if (idx != 0) break;
                return null;
            }
            if (!state) {
                intPartSB.insert(0, c);
                continue;
            }
            if (!state) continue;
            floatPartSB.append(c);
        }
        long intPart = 0L;
        if (intPartSB.length() > 0) {
            long kof = 1L;
            for (int i = 0; i < intPartSB.length(); ++i) {
                long d = NumberConstParser.getDigit(intPartSB.charAt(i), this.radix);
                intPart += d * kof;
                kof *= (long)this.radix;
            }
        }
        double floatPart = 0.0;
        if (floatPartSB.length() > 0) {
            double kof = 1.0;
            for (int i = 0; i < floatPartSB.length(); ++i) {
                int d = NumberConstParser.getDigit(floatPartSB.charAt(i), this.radix);
                floatPart += (double)d * kof;
                kof /= (double)this.radix;
            }
        }
        NumberConst num = this.createNumberConst();
        num.setBegin(offset);
        num.setLength(idx);
        num.setSource(source);
        num.setIsFLoat(this.isFloat);
        if (this.isFloat) {
            Double n = (double)intPart + floatPart;
            num.setNumber(n);
        } else {
            Long n = intPart;
            num.setNumber(n);
        }
        if (this.id != null) {
            num.setId(this.id);
        }
        return num;
    }
}

