/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.parser.lex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.text.Text;
import xyz.cofe.text.parser.Token;
import xyz.cofe.text.parser.TokenParser;
import xyz.cofe.text.parser.lex.AnyChar;

public class AnyCharParser
implements TokenParser {
    public final List<String> stopList = new ArrayList<String>();

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(AnyCharParser.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(AnyCharParser.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(AnyCharParser.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(AnyCharParser.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(AnyCharParser.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(AnyCharParser.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(AnyCharParser.class.getName()).log(Level.SEVERE, null, ex);
    }

    public AnyCharParser() {
    }

    public AnyCharParser(String ... stopList) {
        this.stopList.addAll(Arrays.asList(stopList));
    }

    @Override
    public Token parse(String source, int offset) {
        if (source == null) {
            return null;
        }
        if (offset >= source.length()) {
            return null;
        }
        int offStart = offset;
        String[] stopArray = this.stopList.toArray(new String[0]);
        int minCapture = Integer.MAX_VALUE;
        for (String stopWord : stopArray) {
            int l;
            if (stopWord == null || (l = stopWord.length()) >= minCapture) continue;
            minCapture = l;
        }
        StringBuilder sb = new StringBuilder();
        while (offset < source.length()) {
            String capture;
            boolean isStopWordMatched = false;
            for (String stopWord : stopArray) {
                String lookWord;
                if (stopWord == null || !stopWord.equals(lookWord = Text.lookupText(source, offset, stopWord.length()))) continue;
                isStopWordMatched = true;
                break;
            }
            if (isStopWordMatched || (capture = Text.lookupText(source, offset, minCapture)).length() <= 0) break;
            sb.append(capture);
            offset += capture.length();
        }
        if (sb.length() == 0) {
            return null;
        }
        return new AnyChar("anyChar", source, offStart, sb.length());
    }
}

