/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.parser;

import java.util.ArrayList;
import java.util.List;
import xyz.cofe.common.Reciver;
import xyz.cofe.text.Text;
import xyz.cofe.text.parser.Lexer;
import xyz.cofe.text.parser.Token;
import xyz.cofe.text.parser.TokenParser;

public class ListLexer
implements Lexer {
    protected List<TokenParser> parsers = new ArrayList<TokenParser>();

    public List<TokenParser> getParsers() {
        return this.parsers;
    }

    public List<Token> parse(String source) {
        return this.parse(source, null);
    }

    @Override
    public List<Token> parse(String source, Reciver<String> errorReciver) {
        int l;
        if (source == null) {
            throw new IllegalArgumentException("source==null");
        }
        ArrayList<Token> tokens = new ArrayList<Token>();
        if (source.length() == 0) {
            return tokens;
        }
        for (int offset = 0; offset < source.length(); offset += l) {
            Token tok = null;
            TokenParser lastParser = null;
            for (TokenParser tparser : this.getParsers()) {
                if (tparser == null) continue;
                lastParser = tparser;
                tok = tparser.parse(source, offset);
                if (tok == null) continue;
                break;
            }
            if (tok == null) {
                if (errorReciver == null) break;
                StringBuilder sb = new StringBuilder();
                sb.append("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u043f\u0430\u0440\u0441\u0435\u0440, \u043f\u043e\u0437\u0438\u0446\u0438\u044f \u0432 \u0442\u0435\u043a\u0441\u0442\u0435 = ");
                sb.append(offset);
                if (offset > 0) {
                    int o = offset - 5;
                    if (o < 0) {
                        o = 0;
                    }
                    sb.append("\n");
                    sb.append("\u0422\u0435\u043a\u0441\u0442 \u043f\u0435\u0440\u0435\u0434 \u043f\u043e\u0437\u0438\u0446\u0438\u0435\u0439: ... ");
                    sb.append(Text.encodeStringConstant(source.substring(o, offset)));
                    sb.append("\n");
                    sb.append("\u0422\u0435\u043a\u0441\u0442 \u043f\u043e\u0441\u043b\u0435 \u043f\u043e\u0437\u0438\u0446\u0438\u0438: ");
                    String tafter = source.substring(offset);
                    if (tafter.length() > 50) {
                        tafter = tafter.substring(0, 50);
                    }
                    sb.append(Text.encodeStringConstant(tafter));
                } else {
                    sb.append("\n");
                    sb.append("\u0422\u0435\u043a\u0441\u0442 \u043f\u043e\u0441\u043b\u0435 \u043f\u043e\u0437\u0438\u0446\u0438\u0438: ");
                    String tafter = source.substring(offset);
                    if (tafter.length() > 50) {
                        tafter = tafter.substring(0, 50);
                    }
                    sb.append(Text.encodeStringConstant(tafter));
                }
                errorReciver.recive((Object)sb.toString());
                break;
            }
            l = tok.getLength();
            if (l <= 0) {
                if (errorReciver == null) break;
                errorReciver.recive((Object)("\u041d\u0443\u043b\u0435\u043d\u0432\u0430\u044f \u0434\u043b\u0438\u043d\u0430 \u043b\u0435\u043a\u0441\u0435\u043c\u044b = " + tok.getClass().getName() + ", \u043f\u043e\u0437\u0438\u0446\u0438\u044f \u0432 \u0442\u0435\u043a\u0441\u0442\u0435 = " + offset + " \u043f\u0430\u0440\u0441\u0435\u0440=" + lastParser));
                break;
            }
            tokens.add(tok);
        }
        return tokens;
    }
}

