/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.parser;

import java.util.ArrayList;
import java.util.List;
import xyz.cofe.collection.Predicate;
import xyz.cofe.collection.Predicates;
import xyz.cofe.text.parser.Token;

public class LexerUtil {
    public static final Predicate<Character> isLetter = new Predicate<Character>(){

        public boolean validate(Character value) {
            if (value == null) {
                return false;
            }
            return Character.isLetter(value.charValue());
        }
    };
    public static final Predicate<Character> isDigit = new Predicate<Character>(){

        public boolean validate(Character value) {
            return value == null ? false : Character.isDigit(value.charValue());
        }
    };

    public static List<Token> filter(List<Token> toks, Class ... whiteSpaceTokens) {
        if (toks == null) {
            throw new IllegalArgumentException("toks==null");
        }
        ArrayList<Token> res = new ArrayList<Token>();
        for (int i = 0; i < toks.size(); ++i) {
            Token o = toks.get(i);
            if (o != null) {
                boolean skip = false;
                for (Class c : whiteSpaceTokens) {
                    if (!o.getClass().equals(c)) continue;
                    skip = true;
                    break;
                }
                if (skip) continue;
                res.add(o);
                continue;
            }
            res.add(o);
        }
        return res;
    }

    public static char lookup(String str, int off, char nullc) {
        if (str == null) {
            return nullc;
        }
        if (off < 0) {
            return nullc;
        }
        if (str.length() == 0) {
            return nullc;
        }
        if (off >= str.length()) {
            return nullc;
        }
        return str.charAt(off);
    }

    public static int isRepeat(String src, int offset, Predicate<Character> charPred) {
        char c;
        char nullc = '\u0000';
        int co = 0;
        while ((c = LexerUtil.lookup(src, offset + co, nullc)) != nullc && charPred.validate((Object)Character.valueOf(c))) {
            ++co;
        }
        return co;
    }

    public static boolean match(String src, int offset, Predicate<Character> ... charPreds) {
        if (charPreds == null) {
            return false;
        }
        if (src == null) {
            return false;
        }
        if (offset >= src.length()) {
            return false;
        }
        if (offset < 0) {
            return false;
        }
        if (charPreds.length > src.length() - offset) {
            return false;
        }
        if (charPreds.length == 0) {
            return true;
        }
        for (int i = 0; i < charPreds.length; ++i) {
            Predicate<Character> charPred = charPreds[i];
            char nullc = '\u0000';
            char cs = LexerUtil.lookup(src, i + offset, nullc);
            if (charPred.validate((Object)Character.valueOf(cs))) continue;
            return false;
        }
        return true;
    }

    public static boolean match(String src, int offset, boolean ignoreCase, String text) {
        if (text == null) {
            return false;
        }
        if (src == null) {
            return false;
        }
        if (offset >= src.length()) {
            return false;
        }
        if (offset < 0) {
            return false;
        }
        if (text.length() > src.length() - offset) {
            return false;
        }
        if (text.length() == 0) {
            return true;
        }
        for (int i = 0; i < text.length(); ++i) {
            char ct = text.charAt(i);
            char cs = LexerUtil.lookup(src, i + offset, ct);
            if (!(ignoreCase ? (Character.isLetter(ct) && Character.isLetter(cs) ? (ct = Character.toLowerCase(ct)) != (cs = Character.toLowerCase(cs)) : ct != cs) : ct != cs)) continue;
            return false;
        }
        return true;
    }

    public static Predicate<Character>[] array(Predicate<Character> ... chr) {
        return chr;
    }

    public static Predicate<Character>[] append(Predicate<Character>[] src, Predicate<Character> ... chr) {
        if (src == null && chr == null) {
            return new Predicate[0];
        }
        if (src == null && chr != null) {
            return chr;
        }
        if (src != null && chr == null) {
            return src;
        }
        Predicate[] res = new Predicate[src.length + chr.length];
        System.arraycopy(src, 0, res, 0, src.length);
        System.arraycopy(chr, 0, res, src.length, chr.length);
        return res;
    }

    public static final Predicate<Character> not(Predicate<Character> pred) {
        if (pred == null) {
            throw new IllegalArgumentException("pred==null");
        }
        final Predicate<Character> f = pred;
        return new Predicate<Character>(){

            public boolean validate(Character value) {
                boolean r = f.validate((Object)value);
                return !r;
            }
        };
    }

    public static Predicate<Character> isInList(String listOfChars) {
        final String chars = listOfChars;
        return new Predicate<Character>(){

            public boolean validate(Character value) {
                if (value == null) {
                    return false;
                }
                if (chars == null || chars.length() == 0) {
                    return false;
                }
                int i = 0;
                for (i = 0; i < chars.length(); ++i) {
                    char c = chars.charAt(i);
                    if (!value.equals(Character.valueOf(c))) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Predicate<Character> isInList(char ... listOfChars) {
        final char[] chars = listOfChars;
        return new Predicate<Character>(){

            public boolean validate(Character value) {
                if (value == null) {
                    return false;
                }
                for (char c : chars) {
                    if (!value.equals(Character.valueOf(c))) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Predicate<Character> or(Predicate<Character> ... p) {
        return Predicates.or(p);
    }
}

