/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text;

import java.io.IOException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.text.EndLine;
import xyz.cofe.text.EndLineReWriter;

public class PrefixWriter
extends EndLineReWriter {
    private static final Logger logger = Logger.getLogger(PrefixWriter.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected String prefix = null;
    protected boolean prefixWrited = false;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public PrefixWriter(Writer writer) {
        super(writer);
    }

    public PrefixWriter(Writer writer, String endl) {
        super(writer, endl);
    }

    public PrefixWriter(Writer writer, EndLine endl) {
        super(writer, endl);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String pref) {
        this.prefix = pref;
    }

    protected void writePrefix() throws IOException {
        String pref = this.getPrefix();
        Writer wr = this.writer;
        if (pref != null && wr != null) {
            wr.append(pref);
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (!this.prefixWrited) {
            this.prefixWrited = true;
            this.writePrefix();
        }
        super.write(cbuf, off, len);
    }

    @Override
    protected void writeChar(char c0) throws IOException {
        if (!this.prefixWrited) {
            this.prefixWrited = true;
            this.writePrefix();
        }
        super.writeChar(c0);
    }

    @Override
    protected void writeEndLine() throws IOException {
        super.writeEndLine();
        this.prefixWrited = false;
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

