/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Func1;
import xyz.cofe.collection.Iterators;
import xyz.cofe.common.LazyValue;
import xyz.cofe.text.LineReaderIterator;

public class LazyLineReader
implements Iterable<String>,
Closeable {
    private static final Logger logger = Logger.getLogger(LazyLineReader.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected LazyValue<Reader> lazyReader;
    protected int bufferSize = 4096;
    protected final Lock lock;
    private Func1<Object, Reader> closeReaderFun = new Func1<Object, Reader>(){

        public Object apply(Reader rd) {
            try {
                LazyLineReader.this.lock.lock();
                try {
                    rd.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(LazyLineReader.class.getName()).log(Level.SEVERE, null, ex);
                }
                Object var2_3 = null;
                return var2_3;
            }
            finally {
                LazyLineReader.this.lock.unlock();
            }
        }
    };

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public LazyLineReader(LazyValue<Reader> reader) {
        this(reader, 4096, null);
    }

    public LazyLineReader(LazyValue<Reader> reader, int bufferSize, Lock lock) {
        if (reader == null) {
            throw new IllegalArgumentException("reader==null");
        }
        if (bufferSize < 1) {
            bufferSize = 4096;
        }
        this.lazyReader = reader;
        this.bufferSize = bufferSize;
        this.lock = lock == null ? new ReentrantLock() : lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<String> iterator() {
        try {
            this.lock.lock();
            LineReaderIterator lr_itr = null;
            if (this.lazyReader != null) {
                Reader rd = (Reader)this.lazyReader.evaluate();
                if (rd == null) {
                    Iterator<String> iterator = Iterators.empty().iterator();
                    return iterator;
                }
                LineReaderIterator lineReaderIterator = lr_itr = new LineReaderIterator(rd, this.bufferSize, this.closeReaderFun, this.lock);
                return lineReaderIterator;
            }
            Iterator<String> iterator = Iterators.empty().iterator();
            return iterator;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.lock.lock();
            if (this.lazyReader != null) {
                this.lazyReader = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

