/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import xyz.cofe.text.IndentWriter;

public class IndentPrintWriter
extends PrintWriter {
    private IndentWriter indentWriter = lastInitedWriter;
    private OutputStream toClose = lastStreamforClose;
    private static IndentWriter lastInitedWriter = null;
    private static OutputStream lastStreamforClose = null;

    public IndentPrintWriter() {
        super(IndentPrintWriter.initWriter());
    }

    public IndentPrintWriter(Writer writer) {
        super(IndentPrintWriter.initWriter(writer));
    }

    public IndentPrintWriter(File writer) {
        super(IndentPrintWriter.initWriter(writer, false, (String)null));
    }

    public IndentPrintWriter(File writer, Charset cs) {
        super(IndentPrintWriter.initWriter(writer, false, cs));
    }

    public IndentPrintWriter(File writer, Charset cs, boolean append) {
        super(IndentPrintWriter.initWriter(writer, append, cs));
    }

    public IndentPrintWriter(File writer, String charset) {
        super(IndentPrintWriter.initWriter(writer, false, charset));
    }

    public IndentPrintWriter(File writer, String charset, boolean append) {
        super(IndentPrintWriter.initWriter(writer, append, charset));
    }

    public IndentPrintWriter(OutputStream outputStream) {
        super(IndentPrintWriter.initWriter(outputStream));
    }

    public IndentPrintWriter(OutputStream outputStream, Charset cs) {
        super(IndentPrintWriter.initWriter(outputStream, cs));
    }

    public IndentPrintWriter(OutputStream outputStream, String cs) {
        super(IndentPrintWriter.initWriter(outputStream, cs));
    }

    private static synchronized Writer initWriter() {
        IndentWriter iw;
        OutputStreamWriter output = new OutputStreamWriter(System.out);
        lastInitedWriter = iw = new IndentWriter(output);
        return iw;
    }

    private static synchronized Writer initWriter(File file, boolean append, Charset cs) {
        IndentWriter iw;
        FileOutputStream fout;
        if (file == null) {
            throw new IllegalArgumentException("file == null");
        }
        try {
            fout = new FileOutputStream(file, append);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            throw new IllegalArgumentException("File not found");
        }
        OutputStreamWriter output = cs == null ? new OutputStreamWriter(fout) : new OutputStreamWriter((OutputStream)fout, cs);
        lastInitedWriter = iw = new IndentWriter(output);
        lastStreamforClose = fout;
        return iw;
    }

    private static synchronized Writer initWriter(File file, boolean append, String cs) {
        IndentWriter iw;
        FileOutputStream fout;
        if (file == null) {
            throw new IllegalArgumentException("file == null");
        }
        try {
            fout = new FileOutputStream(file, append);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            throw new IllegalArgumentException("File not found");
        }
        OutputStreamWriter output = null;
        try {
            output = cs == null ? new OutputStreamWriter(fout) : new OutputStreamWriter((OutputStream)fout, cs);
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            output = new OutputStreamWriter(fout);
        }
        lastInitedWriter = iw = new IndentWriter(output);
        lastStreamforClose = fout;
        return iw;
    }

    private static synchronized Writer initWriter(OutputStream outputStream) {
        IndentWriter iw;
        OutputStreamWriter output = new OutputStreamWriter(outputStream);
        lastInitedWriter = iw = new IndentWriter(output);
        return iw;
    }

    private static synchronized Writer initWriter(OutputStream outputStream, Charset cs) {
        IndentWriter iw;
        OutputStreamWriter output = new OutputStreamWriter(outputStream, cs);
        lastInitedWriter = iw = new IndentWriter(output);
        return iw;
    }

    private static synchronized Writer initWriter(OutputStream outputStream, String cs) {
        IndentWriter iw;
        OutputStreamWriter output;
        try {
            output = new OutputStreamWriter(outputStream, cs);
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            output = new OutputStreamWriter(outputStream);
        }
        lastInitedWriter = iw = new IndentWriter(output);
        return iw;
    }

    private static synchronized Writer initWriter(Writer writer) {
        IndentWriter iw;
        lastInitedWriter = iw = new IndentWriter(writer);
        return iw;
    }

    public String getIndent() {
        return this.indentWriter.getIndent();
    }

    public void setIndent(String indent) {
        this.indentWriter.setIndent(indent);
    }

    public int getLevel() {
        return this.indentWriter.getLevel();
    }

    public void setLevel(int level) {
        this.indentWriter.setLevel(level);
    }

    public void incLevel() {
        this.indentWriter.incLevel();
    }

    public void decLevel() {
        this.indentWriter.decLevel();
    }

    public String getPrefix() {
        return this.indentWriter.getPrefix();
    }

    @Override
    public void close() {
        if (this.toClose != null) {
            try {
                this.toClose.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.toClose = null;
        }
        super.close();
    }
}

