/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text;

import java.io.IOException;
import java.io.Writer;
import xyz.cofe.text.EndLine;

public class EndLineReWriter
extends Writer {
    protected Writer writer = null;
    protected String endl = System.getProperty("line.separator", "\n");
    private int state = 0;

    public String getEndl() {
        return this.endl;
    }

    public void setEndl(String endl) {
        if (endl == null) {
            endl = System.getProperty("line.separator", "\n");
        }
        this.endl = endl;
    }

    public void setEndLine(EndLine endline) {
        if (endline == null) {
            endline = EndLine.Default;
        }
        this.endl = endline.get();
    }

    public EndLine getEndLine() {
        if (this.endl == null) {
            return null;
        }
        if (this.endl.equals(EndLine.Default.get())) {
            return EndLine.Default;
        }
        if (this.endl.equals(EndLine.Linux.get())) {
            return EndLine.Linux;
        }
        if (this.endl.equals(EndLine.Mac.get())) {
            return EndLine.Mac;
        }
        if (this.endl.equals(EndLine.Windows.get())) {
            return EndLine.Windows;
        }
        if (this.endl.equals(EndLine.Other.get())) {
            return EndLine.Other;
        }
        return null;
    }

    public EndLineReWriter(Writer writer) {
        if (writer == null) {
            throw new IllegalArgumentException("writer==null");
        }
        this.writer = writer;
    }

    public EndLineReWriter(Writer writer, String endl) {
        if (writer == null) {
            throw new IllegalArgumentException("writer==null");
        }
        if (endl == null) {
            throw new IllegalArgumentException("endl==null");
        }
        this.writer = writer;
        this.endl = endl;
    }

    public EndLineReWriter(Writer writer, EndLine endl) {
        if (writer == null) {
            throw new IllegalArgumentException("writer==null");
        }
        if (endl == null) {
            throw new IllegalArgumentException("endl==null");
        }
        this.writer = writer;
        this.endl = endl.get();
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        int idx = -1;
        for (int i = off; i < off + len; ++i) {
            int c1;
            ++idx;
            char c0 = cbuf[i];
            int n = c1 = i < off + len - 1 ? cbuf[i + 1] : -1;
            if (this.state == 0) {
                if (c0 == '\n' && c1 == 13) {
                    ++i;
                    this.writeEndLine();
                    continue;
                }
                if (c0 == '\r' && c1 == 10) {
                    ++i;
                    this.writeEndLine();
                    continue;
                }
                if (c0 == '\n' && c1 != 13 && c1 != -1) {
                    this.writeEndLine();
                    continue;
                }
                if (c0 == '\r' && c1 != 10 && c1 != -1) {
                    this.writeEndLine();
                    continue;
                }
                if (c0 == '\r' && c1 == -1) {
                    this.state = 1;
                    this.writeEndLine();
                    continue;
                }
                if (c0 == '\n' && c1 == -1) {
                    this.state = 2;
                    this.writeEndLine();
                    continue;
                }
                this.writeChar(c0);
                continue;
            }
            if (this.state == 1) {
                if (c0 == '\n') {
                    this.state = 0;
                    continue;
                }
                if (c0 == '\r') {
                    this.state = 1;
                    this.writeEndLine();
                    continue;
                }
                this.state = 0;
                this.writeChar(c0);
                continue;
            }
            if (this.state != 2) continue;
            if (c0 == '\r') {
                this.state = 0;
                continue;
            }
            if (c0 == '\n') {
                this.state = 2;
                this.writeEndLine();
                continue;
            }
            this.state = 0;
            this.writeChar(c0);
        }
    }

    protected void writeEndLine() throws IOException {
        this.writer.write(this.getEndl());
    }

    protected void writeChar(char c0) throws IOException {
        this.writer.write(c0);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

