/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.out;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.text.EndLine;
import xyz.cofe.text.PrefixWriter;
import xyz.cofe.text.UnionWriter;
import xyz.cofe.text.template.BasicTemplate;

public class Output
extends PrintWriter {
    private PrefixWriter prefixWriter;
    protected boolean closeOnReset = false;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(Output.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(Output.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(Output.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(Output.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(Output.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(Output.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(Output.class.getName()).log(Level.SEVERE, null, ex);
    }

    public Output() {
        super(System.out, true);
        this.prefixWriter = this.createPrefixWriter(this.out);
        this.out = this.prefixWriter;
    }

    private static Writer createWriter(File file, Charset cs) {
        try {
            if (file == null) {
                throw new IllegalArgumentException("file==null");
            }
            if (cs == null) {
                cs = Charset.defaultCharset();
            }
            FileOutputStream fout = new FileOutputStream(file);
            OutputStreamWriter sw = new OutputStreamWriter((OutputStream)fout, cs);
            return sw;
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(Output.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOError(ex);
        }
    }

    public Output(File file, Charset cs) {
        super(Output.createWriter(file, cs), true);
        this.prefixWriter = this.createPrefixWriter(this.out);
        this.out = this.prefixWriter;
    }

    private static Writer createWriter(Path file, Charset cs) {
        try {
            if (file == null) {
                throw new IllegalArgumentException("file==null");
            }
            if (cs == null) {
                cs = Charset.defaultCharset();
            }
            BufferedWriter w = Files.newBufferedWriter(file, cs, new OpenOption[0]);
            return w;
        }
        catch (IOException ex) {
            Logger.getLogger(Output.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOError(ex);
        }
    }

    public Output(Path file, Charset cs) {
        super(Output.createWriter(file, cs), true);
        this.prefixWriter = this.createPrefixWriter(this.out);
        this.out = this.prefixWriter;
    }

    private static Writer createWriter(xyz.cofe.io.fs.File file, Charset cs) {
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        if (cs == null) {
            cs = Charset.defaultCharset();
        }
        OutputStream fout = file.writeStream(new OpenOption[0]);
        OutputStreamWriter w = new OutputStreamWriter(fout, cs);
        return w;
    }

    public Output(xyz.cofe.io.fs.File file, Charset cs) {
        super(Output.createWriter(file, cs), true);
        this.prefixWriter = this.createPrefixWriter(this.out);
        this.out = this.prefixWriter;
    }

    public Output(Writer out) {
        super(out);
        this.prefixWriter = this.createPrefixWriter(out);
        this.out = this.prefixWriter;
    }

    public Output(Writer out, boolean autoFlush) {
        super(out, autoFlush);
        this.prefixWriter = this.createPrefixWriter(out);
        this.out = this.prefixWriter;
    }

    public Output(OutputStream out) {
        super(out);
        this.prefixWriter = this.createPrefixWriter(new OutputStreamWriter((OutputStream)System.out, Charset.defaultCharset()));
        this.out = this.prefixWriter;
    }

    public Output(OutputStream out, boolean autoFlush) {
        super(out, autoFlush);
        this.prefixWriter = this.createPrefixWriter(new OutputStreamWriter((OutputStream)System.out, Charset.defaultCharset()));
        this.out = this.prefixWriter;
    }

    private synchronized PrefixWriter createPrefixWriter(Writer wr) {
        PrefixWriter elrw = new PrefixWriter(wr);
        return elrw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEndl() {
        Object lo = this.lock;
        if (lo != null) {
            Object object = lo;
            synchronized (object) {
                return this.getEndl0();
            }
        }
        return this.getEndl0();
    }

    private String getEndl0() {
        return this.prefixWriter == null ? System.getProperty("line.separator", "\n") : this.prefixWriter.getEndl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEndl(String txt) {
        Object lo = this.lock;
        if (lo != null) {
            Object object = lo;
            synchronized (object) {
                this.setEndl0(txt);
            }
        } else {
            this.setEndl0(txt);
        }
    }

    private void setEndl0(String txt) {
        if (this.prefixWriter != null) {
            this.prefixWriter.setEndl(txt == null ? EndLine.Default.get() : txt);
        }
    }

    public synchronized boolean isCloseOnReset() {
        return this.closeOnReset;
    }

    public synchronized void setCloseOnReset(boolean close) {
        this.closeOnReset = close;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reset(final Writer output) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Output.this.flush();
                if (Output.this.closeOnReset) {
                    Output.this.close();
                }
                Output.this.prefixWriter = Output.this.createPrefixWriter(output == null ? new OutputStreamWriter((OutputStream)System.out, Charset.defaultCharset()) : output);
                Output.this.out = (Writer)Output.this.prefixWriter;
            }
        };
        Object lo = this.lock;
        if (lo != null) {
            Object object = lo;
            synchronized (object) {
                r.run();
            }
        } else {
            r.run();
        }
    }

    public synchronized void reset() {
        this.reset(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void appendWriter(Writer w) {
        if (w == null) {
            throw new IllegalArgumentException("w==null");
        }
        Object lo = this.lock;
        if (lo != null) {
            Object object = lo;
            synchronized (object) {
                this.appendWriter0(w);
            }
        } else {
            this.appendWriter0(w);
        }
    }

    private void appendWriter0(Writer w) {
        if (this.out instanceof UnionWriter) {
            ((UnionWriter)this.out).getWriters().add(w);
        } else {
            UnionWriter uw = new UnionWriter(new Writer[]{this.out, w});
            this.out = uw;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeWriter(Writer writer) {
        if (writer == null) {
            throw new IllegalArgumentException("writer==null");
        }
        Object lo = this.lock;
        if (lo != null) {
            Object object = lo;
            synchronized (object) {
                if (this.out instanceof UnionWriter) {
                    UnionWriter uw = (UnionWriter)this.out;
                    uw.getWriters().remove(writer);
                }
            }
        } else if (this.out instanceof UnionWriter) {
            UnionWriter uw = (UnionWriter)this.out;
            uw.getWriters().remove(writer);
        }
    }

    public BasicTemplate.EasyTemplate template(String template) {
        if (template == null) {
            throw new IllegalArgumentException("template==null");
        }
        BasicTemplate.EasyTemplate tmpl = BasicTemplate.template((String)template);
        tmpl.output((Writer)this);
        tmpl.align();
        tmpl.outputFlushing();
        return tmpl;
    }

    public synchronized void setLinePrefixFn(Supplier<String> fn) {
        PrefixWriter pw = this.prefixWriter;
        if (pw == null) {
            throw new IllegalStateException("prefixWriter == null");
        }
        pw.setLinePrefixFn(fn);
    }

    public synchronized Supplier<String> getLinePrefixFn() {
        PrefixWriter pw = this.prefixWriter;
        if (pw == null) {
            throw new IllegalStateException("prefixWriter == null");
        }
        return pw.getLinePrefixFn();
    }

    public synchronized String getLinePrefix() {
        PrefixWriter pw = this.prefixWriter;
        if (pw == null) {
            throw new IllegalStateException("prefixWriter == null");
        }
        return pw.getLinePrefix();
    }

    public synchronized void setLinePrefix(String prefix) {
        PrefixWriter pw = this.prefixWriter;
        if (pw == null) {
            throw new IllegalStateException("prefixWriter == null");
        }
        pw.setLinePrefix(prefix);
    }

    public synchronized Function<String, String> getLineConvertor() {
        PrefixWriter pw = this.prefixWriter;
        if (pw == null) {
            throw new IllegalStateException("prefixWriter == null");
        }
        return pw.getLineConvertor();
    }

    public synchronized void setLineConvertor(Function<String, String> conv) {
        PrefixWriter pw = this.prefixWriter;
        if (pw == null) {
            throw new IllegalStateException("prefixWriter == null");
        }
        if (conv == null) {
            throw new IllegalStateException("conv == null");
        }
        pw.setLineConvertor(conv);
    }
}

