/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.template.ctx;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DateVar {
    private transient GregorianCalendar cal = new GregorianCalendar();
    private Date date = null;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(DateVar.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(DateVar.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(DateVar.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(DateVar.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(DateVar.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(DateVar.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(DateVar.class.getName()).log(Level.SEVERE, null, ex);
    }

    public DateVar() {
        this.date = new Date();
        this.cal.setTime(this.date);
    }

    public DateVar(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("date==null");
        }
        this.date = date;
        this.cal.setTime(date);
    }

    public Date getDate() {
        if (this.date == null) {
            this.date = new Date();
            this.cal.setTime(this.date);
        }
        return this.date;
    }

    public void setDate(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("date==null");
        }
        this.date = date;
        this.cal.setTime(date);
    }

    public int getYear() {
        return this.cal.get(1);
    }

    public String getYyyy() {
        int y = this.getYear();
        if (y < 10) {
            return "000" + Integer.toString(y);
        }
        if (y < 100) {
            return "00" + Integer.toString(y);
        }
        if (y < 1000) {
            return "0" + Integer.toString(y);
        }
        return Integer.toString(y);
    }

    public int getMonth() {
        return this.cal.get(2) + 1;
    }

    public String getMM() {
        int m = this.getMonth();
        String s = Integer.toString(m);
        if (s.length() == 1) {
            s = "0" + s;
        }
        return s;
    }

    public String getMMM() {
        SimpleDateFormat sdf = new SimpleDateFormat("MMM");
        return sdf.format(this.getDate());
    }

    public int getDay() {
        return this.cal.get(5);
    }

    public String getDd() {
        String s = Integer.toString(this.getDay());
        if (s.length() == 1) {
            s = "0" + s;
        }
        return s;
    }

    public String getEe() {
        SimpleDateFormat sdf = new SimpleDateFormat("EEEEEE");
        return sdf.format(this.getDate());
    }

    public String getE() {
        SimpleDateFormat sdf = new SimpleDateFormat("E");
        return sdf.format(this.getDate());
    }

    public int getHour() {
        return this.cal.get(11);
    }

    public String getHH() {
        String s = Integer.toString(this.getHour());
        if (s.length() == 1) {
            s = "0" + s;
        }
        return s;
    }

    public int getMinute() {
        return this.cal.get(12);
    }

    public String getMm() {
        String s = Integer.toString(this.getMinute());
        if (s.length() == 1) {
            s = "0" + s;
        }
        return s;
    }

    public int getSecond() {
        return this.cal.get(13);
    }

    public String getSs() {
        String s = Integer.toString(this.getSecond());
        if (s.length() == 1) {
            s = "0" + s;
        }
        return s;
    }

    public String getSSS() {
        SimpleDateFormat sdf = new SimpleDateFormat("SSS");
        return sdf.format(this.getDate());
    }

    public String getGZ() {
        SimpleDateFormat sdf = new SimpleDateFormat("z");
        return sdf.format(this.getDate());
    }

    public String getZ() {
        SimpleDateFormat sdf = new SimpleDateFormat("Z");
        return sdf.format(this.getDate());
    }

    public String getX() {
        SimpleDateFormat sdf = new SimpleDateFormat("XXX");
        return sdf.format(this.getDate());
    }

    public String getWw() {
        SimpleDateFormat sdf = new SimpleDateFormat("ww");
        return sdf.format(this.getDate());
    }

    public String getU() {
        SimpleDateFormat sdf = new SimpleDateFormat("u");
        return sdf.format(this.getDate());
    }

    public String getShortDT() {
        return this.getYyyy() + this.getMM() + this.getDd() + this.getHH() + this.getMm() + this.getSs();
    }

    public String getDT() {
        return this.getYyyy() + "-" + this.getMM() + "-" + this.getDd() + " " + this.getHH() + ":" + this.getMm() + ":" + this.getSs();
    }

    public String toString() {
        return this.getDT();
    }
}

