/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.template;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.types.FieldController;
import xyz.cofe.types.SetOwner;
import xyz.cofe.types.TypesUtil;
import xyz.cofe.types.ValueController;

public class PropertyAccessResolver {
    private final Map<String, PropertyDescriptor> propertiesDesc;
    private final Map<String, FieldController> fields;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(PropertyAccessResolver.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(PropertyAccessResolver.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(PropertyAccessResolver.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(PropertyAccessResolver.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(PropertyAccessResolver.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(PropertyAccessResolver.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(PropertyAccessResolver.class.getName()).log(Level.SEVERE, null, ex);
    }

    public PropertyAccessResolver(Class contextClass) {
        if (contextClass == null) {
            throw new IllegalArgumentException("contextClass==null");
        }
        this.propertiesDesc = new LinkedHashMap<String, PropertyDescriptor>();
        try {
            BeanInfo bi = Introspector.getBeanInfo(contextClass);
            for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
                this.propertiesDesc.put(pd.getName(), pd);
            }
        }
        catch (IntrospectionException ex) {
            Logger.getLogger(PropertyAccessResolver.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.fields = new LinkedHashMap<String, FieldController>();
        for (ValueController vc : TypesUtil.Iterators.fieldsControllersOf((Class)contextClass, null)) {
            if (!(vc instanceof FieldController)) continue;
            FieldController fc = (FieldController)vc;
            this.fields.put(fc.getName(), fc);
        }
    }

    public Map<String, PropertyDescriptor> getProperties() {
        return this.propertiesDesc;
    }

    public Map<String, FieldController> getFields() {
        return this.fields;
    }

    private void updateOwner(Object owner) {
        for (FieldController o : this.fields.values()) {
            if (!(o instanceof SetOwner)) continue;
            ((SetOwner)o).setOwner(owner);
        }
    }

    public Object resolve(Object context, String ... indexes) {
        Method readMethod;
        PropertyDescriptor pd;
        if (context == null) {
            throw new IllegalArgumentException("context==null");
        }
        if (indexes == null) {
            throw new IllegalArgumentException("indexes==null");
        }
        if (indexes.length == 0) {
            return context;
        }
        Object v = null;
        boolean propReaded = false;
        if (v == null && (pd = this.propertiesDesc.get(indexes[0])) != null && (readMethod = pd.getReadMethod()) != null) {
            try {
                v = readMethod.invoke(context, new Object[0]);
                propReaded = true;
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(PropertyAccessResolver.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(PropertyAccessResolver.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(PropertyAccessResolver.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        boolean fieldReaded = false;
        if (v == null && !propReaded) {
            this.updateOwner(context);
            ValueController fvc = (ValueController)this.fields.get(indexes[0]);
            if (fvc != null) {
                try {
                    v = fvc.getValue();
                    fieldReaded = true;
                }
                catch (Throwable ex) {
                    Logger.getLogger(PropertyAccessResolver.class.getName()).log(Level.SEVERE, null, ex);
                    return null;
                }
            }
        }
        if (v == null && !fieldReaded && context instanceof Map) {
            v = ((Map)context).get(indexes[0]);
        }
        if (v == null) {
            return null;
        }
        if (indexes.length == 1) {
            return v;
        }
        String[] nidx = Arrays.copyOfRange(indexes, 1, indexes.length);
        PropertyAccessResolver reslv = new PropertyAccessResolver(v.getClass());
        return reslv.resolve(v, nidx);
    }
}

