/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.unix.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.unix.libc.ResourcesInfo;
import xyz.cofe.unix.linux.Process;

public class FileUtil {
    private static void logFine(String message, Object ... args) {
        Logger.getLogger(FileUtil.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(FileUtil.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(FileUtil.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(FileUtil.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(FileUtil.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(FileUtil.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(FileUtil.class.getName()).log(Level.SEVERE, null, ex);
    }

    public static byte[] read(File f, int blocksize) {
        if (f == null) {
            throw new IllegalArgumentException("f==null");
        }
        if (blocksize < 1) {
            throw new IllegalArgumentException("blocksize<1");
        }
        byte[] res = null;
        try {
            int rd;
            FileInputStream fin = new FileInputStream(f);
            byte[] buff = new byte[blocksize];
            while ((rd = fin.read(buff)) >= 0) {
                if (rd <= 0) continue;
                if (res == null) {
                    res = Arrays.copyOf(buff, rd);
                    continue;
                }
                res = Arrays.copyOf(res, res.length + rd);
                System.arraycopy(buff, 0, res, res.length - rd, rd);
            }
            fin.close();
        }
        catch (IOException ex) {
            Logger.getLogger(Process.class.getName()).log(Level.SEVERE, null, ex);
        }
        return res;
    }

    public static byte[] read(File f) {
        return FileUtil.read(f, ResourcesInfo.getPageSize());
    }

    public static String read(File f, Charset cs) {
        if (f == null) {
            throw new IllegalArgumentException("f==null");
        }
        if (cs == null) {
            throw new IllegalArgumentException("cs==null");
        }
        byte[] data = FileUtil.read(f);
        if (data != null) {
            return new String(data, cs);
        }
        return null;
    }

    public static String readAsString(File f) {
        if (f == null) {
            throw new IllegalArgumentException("f==null");
        }
        return FileUtil.read(f, Charset.defaultCharset());
    }

    public static String readAsString(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path==null");
        }
        return FileUtil.read(new File(path), Charset.defaultCharset());
    }
}

