/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.unix.linux;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.unix.linux.Socket;
import xyz.cofe.unix.linux.TcpState;
import xyz.cofe.unix.utils.Func1;

public class TcpSocket
extends Socket {
    private TcpState state = null;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(TcpSocket.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(TcpSocket.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(TcpSocket.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(TcpSocket.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(TcpSocket.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(TcpSocket.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(TcpSocket.class.getName()).log(Level.SEVERE, null, ex);
    }

    protected TcpSocket(Socket.ParsedSocketLine parsedLine) {
        super(parsedLine);
    }

    public TcpState getState() {
        if (this.state != null) {
            return this.state;
        }
        this.state = TcpState.get(this.st);
        return this.state;
    }

    public static List<TcpSocket> createTcpSnapshot() {
        List<Socket> socks = TcpSocket.createSnapshot(new Func1<Socket, Socket.ParsedSocketLine>(){

            @Override
            public Socket apply(Socket.ParsedSocketLine a1) {
                return new TcpSocket(a1);
            }
        }, "/proc/net/tcp", "/proc/net/tcp6");
        ArrayList<TcpSocket> res = new ArrayList<TcpSocket>();
        for (Socket s : socks) {
            if (!(s instanceof TcpSocket)) continue;
            res.add((TcpSocket)s);
        }
        return res;
    }
}

