/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.unix.linux;

import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import xyz.cofe.unix.libc.FileStat;
import xyz.cofe.unix.libc.ResourcesInfo;
import xyz.cofe.unix.libc.UnixFileIO;
import xyz.cofe.unix.linux.FileDescriptor;
import xyz.cofe.unix.linux.ProcessList;
import xyz.cofe.unix.linux.Socket;
import xyz.cofe.unix.utils.FileUtil;
import xyz.cofe.unix.utils.TextUtil;

public class Process {
    protected ProcessList owner = null;
    protected int PID = Integer.MIN_VALUE;
    protected int PPID = Integer.MIN_VALUE;
    protected String exe = null;
    protected String commandLine = null;
    protected Map<String, String> environment = new TreeMap<String, String>();
    protected int uid = 0;
    protected int gid = 0;
    protected String workDirectory = null;
    protected State state = State.UNKNOW;
    private long virtualSize = Long.MIN_VALUE;
    private long residentSize = Long.MIN_VALUE;
    protected int priority = 0;
    protected int nice = 0;
    protected long utime = 0L;
    protected long stime = 0L;
    protected long cutime = 0L;
    protected long cstime = 0L;
    protected int numThreads = 0;
    private static UnixFileIO io = new UnixFileIO();
    private static Pattern procFileNamePattern = Pattern.compile("^(\\d+)$");
    private static Pattern numberPattern = Pattern.compile("^\\s*([\\+\\-]\\s*)?\\d+\\s*");
    private FileDescriptor[] fileDescriptors = null;
    protected File[] files = null;
    protected Socket[] sockets = null;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(Process.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(Process.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(Process.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(Process.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(Process.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(Process.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(Process.class.getName()).log(Level.SEVERE, null, ex);
    }

    public Process() {
    }

    public Process(Process src) {
        if (src != null) {
            this.PID = src.PID;
            this.PPID = src.PPID;
            this.exe = src.exe;
            this.commandLine = src.commandLine;
            this.getEnvironment().clear();
            this.getEnvironment().putAll(src.getEnvironment());
            this.uid = src.uid;
            this.gid = src.gid;
            this.workDirectory = src.workDirectory;
            this.state = src.state;
            this.virtualSize = src.virtualSize;
            this.residentSize = src.residentSize;
            this.priority = src.priority;
            this.nice = src.nice;
            this.utime = src.utime;
            this.stime = src.stime;
            this.cutime = src.cutime;
            this.cstime = src.cstime;
            this.numThreads = src.numThreads;
            this.owner = src.owner;
        }
    }

    public ProcessList getOwner() {
        return this.owner;
    }

    public void setOwner(ProcessList owner) {
        this.owner = owner;
    }

    public int getPID() {
        return this.PID;
    }

    protected void setPID(int PID) {
        this.PID = PID;
    }

    public int getPPID() {
        return this.PPID;
    }

    protected void setPPID(int PPID) {
        this.PPID = PPID;
    }

    public String getExe() {
        return this.exe;
    }

    protected void setExe(String exe) {
        this.exe = exe;
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    protected void setCommandLine(String commandLine) {
        this.commandLine = commandLine;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public int getUID() {
        return this.uid;
    }

    protected void setUID(int uid) {
        this.uid = uid;
    }

    public int getGID() {
        return this.gid;
    }

    protected void setGID(int gid) {
        this.gid = gid;
    }

    public String getWorkDirectory() {
        return this.workDirectory;
    }

    protected void setWorkDirectory(String workDirectory) {
        this.workDirectory = workDirectory;
    }

    public State getState() {
        return this.state;
    }

    protected void setState(State state) {
        this.state = state;
    }

    public long getVirtualSize() {
        return this.virtualSize;
    }

    protected void setVirtualSize(long virtualSize) {
        this.virtualSize = virtualSize;
    }

    public long getResidentSize() {
        return this.residentSize;
    }

    protected void setResidentSize(long residentSize) {
        this.residentSize = residentSize;
    }

    public int getPriority() {
        return this.priority;
    }

    protected void setPriority(int priority) {
        this.priority = priority;
    }

    public int getNice() {
        return this.nice;
    }

    protected void setNice(int nice) {
        this.nice = nice;
    }

    public long getUtime() {
        return this.utime;
    }

    protected void setUtime(long utime) {
        this.utime = utime;
    }

    public long getStime() {
        return this.stime;
    }

    protected void setStime(long stime) {
        this.stime = stime;
    }

    public long getCutime() {
        return this.cutime;
    }

    protected void setCutime(long cutime) {
        this.cutime = cutime;
    }

    public long getCstime() {
        return this.cstime;
    }

    protected void setCstime(long cstime) {
        this.cstime = cstime;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    protected void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    private static boolean isNumber(String str) {
        if (str == null) {
            return false;
        }
        if (str.length() < 1) {
            return false;
        }
        Matcher m = numberPattern.matcher(str);
        return m.matches();
    }

    private static int parseInt(String str) {
        return Integer.parseInt(str);
    }

    private static long parseLong(String str) {
        return Long.parseLong(str);
    }

    private static BigInteger parseBigInt(String str) {
        return new BigInteger(str);
    }

    public boolean refresh() {
        File procInProcFS = new File("/proc/" + this.PID);
        if (procInProcFS.exists()) {
            this.fileDescriptors = null;
            this.files = null;
            this.sockets = null;
            Process.apply(this, procInProcFS);
            return true;
        }
        return false;
    }

    private static void apply(Process proc, File procInProcFS) {
        File cwdFile;
        File statusFile;
        String[] fields;
        String statStr;
        String envText;
        File environFile;
        String cmdl;
        File cmdLineFile;
        File exeSymLinkFile;
        if (procInProcFS == null) {
            throw new IllegalArgumentException("procInProcFS==null");
        }
        if (proc == null) {
            throw new IllegalArgumentException("proc==null");
        }
        if (!procInProcFS.exists()) {
            proc.state = State.NotExists;
            return;
        }
        Matcher m = procFileNamePattern.matcher(procInProcFS.getName());
        if (m.matches()) {
            String pidStr = m.group(1);
            try {
                int pidInt = Integer.parseInt(pidStr);
                proc.setPID(pidInt);
            }
            catch (NumberFormatException pidInt) {
                // empty catch block
            }
        }
        if ((exeSymLinkFile = new File(procInProcFS, "exe")).exists()) {
            String exeTarget = io.readlink(exeSymLinkFile.getAbsolutePath());
            proc.setExe(exeTarget);
        }
        if ((cmdLineFile = new File(procInProcFS, "cmdline")).exists() && cmdLineFile.canRead() && (cmdl = FileUtil.readAsString(cmdLineFile)) != null) {
            proc.setCommandLine(cmdl);
        }
        if ((environFile = new File(procInProcFS, "environ")).exists() && environFile.canRead() && (envText = FileUtil.readAsString(environFile)) != null) {
            String[] envLines;
            for (String envLine : envLines = envText.split("\\x00")) {
                String[] envKeyVal = envLine.split("=", 2);
                if (envKeyVal == null || envKeyVal.length != 2) continue;
                String envKey = envKeyVal[0];
                String envVal = envKeyVal[1];
                proc.getEnvironment().put(envKey, envVal);
            }
        }
        FileStat fstat = io.lstat(procInProcFS.getAbsolutePath());
        int uid = fstat.getUID();
        int gid = fstat.getGID();
        proc.setGID(gid);
        proc.setUID(uid);
        File statFile = new File(procInProcFS, "stat");
        if (statFile.exists() && statFile.canRead() && (statStr = FileUtil.readAsString(statFile)) != null && (fields = statStr.split("\\s+")).length >= 37) {
            String rss;
            String num_threads;
            String nice;
            String priority;
            String cstime;
            String cutime;
            String stime;
            String ppid;
            String state = fields[2];
            if (state != null) {
                if (state.equals("R")) {
                    proc.setState(State.Running);
                } else if (state.equals("S")) {
                    proc.setState(State.Sleeping);
                } else if (state.equals("D")) {
                    proc.setState(State.Waiting);
                } else if (state.equals("Z")) {
                    proc.setState(State.Zombie);
                } else if (state.equals("T")) {
                    proc.setState(State.Stopped);
                } else if (state.equals("t")) {
                    proc.setState(State.TracingStop);
                } else if (state.equals("W")) {
                    proc.setState(State.Paging);
                } else if (state.equals("X")) {
                    proc.setState(State.Dead);
                } else if (state.equals("x")) {
                    proc.setState(State.Dead);
                } else if (state.equals("K")) {
                    proc.setState(State.Dead);
                } else if (!state.equals("W")) {
                    if (state.equals("P")) {
                        proc.setState(State.Parked);
                    } else {
                        proc.setState(State.UNKNOW);
                    }
                }
            }
            if (Process.isNumber(ppid = fields[3])) {
                proc.setPPID(Process.parseInt(ppid));
            }
            String pgrp = fields[4];
            String session = fields[5];
            String tty_nr = fields[6];
            String tpgid = fields[7];
            String minflt = fields[9];
            String cminflt = fields[10];
            String majflt = fields[11];
            String cmajflt = fields[12];
            String utime = fields[13];
            if (Process.isNumber(utime)) {
                proc.setUtime(Process.parseLong(utime));
            }
            if (Process.isNumber(stime = fields[14])) {
                proc.setStime(Process.parseLong(stime));
            }
            if (Process.isNumber(cutime = fields[15])) {
                proc.setCutime(Process.parseLong(cutime));
            }
            if (Process.isNumber(cstime = fields[16])) {
                proc.setCstime(Process.parseLong(cstime));
            }
            if (Process.isNumber(priority = fields[17])) {
                proc.setPriority(Process.parseInt(priority));
            }
            if (Process.isNumber(nice = fields[18])) {
                proc.setNice(Process.parseInt(nice));
            }
            if (Process.isNumber(num_threads = fields[19])) {
                proc.setNumThreads(Process.parseInt(num_threads));
            }
            String itrealvalue = fields[20];
            String starttime = fields[21];
            String vsize = fields[22];
            if (Process.isNumber(vsize)) {
                proc.setVirtualSize(Process.parseLong(vsize));
            }
            if (Process.isNumber(rss = fields[23])) {
                proc.setResidentSize(Process.parseLong(rss) * (long)ResourcesInfo.getPageSize());
            }
            String string = fields[24];
        }
        if ((statusFile = new File(procInProcFS, "status")).exists()) {
            String[] lines;
            String statusStr = FileUtil.readAsString(statusFile);
            for (String line : lines = TextUtil.splitNewLines(statusStr)) {
                String[] kv = line.split("\\s*:\\s*", 2);
                if (kv == null || kv.length != 2) continue;
                String key = kv[0].trim();
                String value = kv[1].trim();
                try {
                    if (key.equalsIgnoreCase("pid")) {
                        int pid = Integer.parseInt(value);
                        proc.setPID(pid);
                    }
                    if (!key.equalsIgnoreCase("ppid")) continue;
                    int ppid = Integer.parseInt(value);
                    proc.setPPID(ppid);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if ((cwdFile = new File(procInProcFS, "cwd")).exists()) {
            String cwdTarget = io.readlink(cwdFile.getAbsolutePath());
            proc.setWorkDirectory(cwdTarget);
        }
    }

    public static Process createFrom(ProcessList processes, File procInProcFS) {
        if (procInProcFS == null) {
            throw new IllegalArgumentException("procInProcFS==null");
        }
        Process proc = new Process();
        proc.setOwner(processes);
        Process.apply(proc, procInProcFS);
        return proc;
    }

    public static Process createFrom(File procInProcFS) {
        if (procInProcFS == null) {
            throw new IllegalArgumentException("procInProcFS==null");
        }
        Process proc = new Process();
        Process.apply(proc, procInProcFS);
        return proc;
    }

    public static Process createSelf() {
        Process proc = new Process();
        Process.apply(proc, new File("/proc/self"));
        return proc;
    }

    public FileDescriptor[] getFileDescriptors() {
        if (this.fileDescriptors != null) {
            return this.fileDescriptors;
        }
        ArrayList<FileDescriptor> fdList = new ArrayList<FileDescriptor>();
        File procInProcFS = new File("/proc/" + this.PID);
        File fd = new File(procInProcFS, "fd");
        if (fd.exists()) {
            for (File fdesc : fd.listFiles()) {
                FileStat fstat;
                int mode;
                boolean exists = fdesc.exists();
                if (!exists || (mode = (fstat = io.lstat(fdesc.getPath())).getMode()) == 0) continue;
                fdList.add(new FileDescriptor(fdesc));
            }
        }
        this.fileDescriptors = fdList.toArray(new FileDescriptor[0]);
        return this.fileDescriptors;
    }

    public File[] getFiles() {
        if (this.files != null) {
            return this.files;
        }
        ArrayList<File> lfiles = new ArrayList<File>();
        for (FileDescriptor fd : this.getFileDescriptors()) {
            String target;
            if (fd.isPipe() || fd.isSocket() || (target = fd.getTarget()) == null) continue;
            File f = new File(fd.getTarget());
            lfiles.add(f);
        }
        this.files = lfiles.toArray(new File[0]);
        return this.files;
    }

    public Socket[] getSockets() {
        if (this.sockets != null) {
            return this.sockets;
        }
        ArrayList<Socket> lres = new ArrayList<Socket>();
        List<Socket> sockSnapShot = Socket.createSnapshot();
        for (FileDescriptor fd : this.getFileDescriptors()) {
            if (!fd.isSocket()) continue;
            long socketInode = fd.getSocketInode();
            for (Socket soc : sockSnapShot) {
                if (soc.getInode() != socketInode) continue;
                lres.add(soc);
            }
        }
        this.sockets = lres.toArray(new Socket[0]);
        return this.sockets;
    }

    public static enum State {
        NotExists,
        Running,
        Sleeping,
        Waiting,
        Zombie,
        Stopped,
        TracingStop,
        Paging,
        Dead,
        Wakekill,
        Waking,
        Parked,
        UNKNOW;

    }
}

