/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.unix.libc;

import java.math.BigInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.unix.libc.StdErr;
import xyz.cofe.unix.libc.jna.LibC;

public class ResourcesInfo {
    private static final Object syncObj = LibC.class;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(ResourcesInfo.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(ResourcesInfo.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(ResourcesInfo.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(ResourcesInfo.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(ResourcesInfo.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(ResourcesInfo.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(ResourcesInfo.class.getName()).log(Level.SEVERE, null, ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getAvailableProcessors() {
        Object object = syncObj;
        synchronized (object) {
            return LibC.get_nprocs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getProcessors() {
        Object object = syncObj;
        synchronized (object) {
            return LibC.get_nprocs_conf();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getPageSize() {
        Object object = syncObj;
        synchronized (object) {
            return LibC.getpagesize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getTotalPhysPages() {
        Object object = syncObj;
        synchronized (object) {
            return LibC.get_phys_pages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getAvailablePhysPages() {
        Object object = syncObj;
        synchronized (object) {
            return LibC.get_avphys_pages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BigInteger getTotalPhysBytes() {
        Object object = syncObj;
        synchronized (object) {
            return BigInteger.valueOf(ResourcesInfo.getPageSize()).multiply(BigInteger.valueOf(ResourcesInfo.getTotalPhysPages()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BigInteger getAvailablePhysBytes() {
        Object object = syncObj;
        synchronized (object) {
            return BigInteger.valueOf(ResourcesInfo.getPageSize()).multiply(BigInteger.valueOf(ResourcesInfo.getAvailablePhysPages()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LoadAVG getLoadAvg() {
        Object object = syncObj;
        synchronized (object) {
            double[] loadavg = new double[]{0.0, 0.0, 0.0};
            int r = LibC.getloadavg(loadavg, loadavg.length);
            if (r == -1) {
                int err = LibC.errno();
                String mes = LibC.strerror(err);
                throw new StdErr(err, mes);
            }
            LoadAVG load = new LoadAVG();
            load.oneMinute = loadavg[0];
            load.fiveMinutes = loadavg[1];
            load.fifteenMinutes = loadavg[2];
            return load;
        }
    }

    public static class LoadAVG {
        public double oneMinute = 0.0;
        public double fiveMinutes = 0.0;
        public double fifteenMinutes = 0.0;
    }
}

