/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.unix.libc;

import com.sun.jna.Pointer;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.unix.libc.jna.LibC;
import xyz.cofe.unix.utils.Func;

public class ProcessInfo {
    private static final Object syncObj = LibC.class;
    private static Func<String> loginFunc = null;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(ProcessInfo.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(ProcessInfo.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(ProcessInfo.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(ProcessInfo.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(ProcessInfo.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(ProcessInfo.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(ProcessInfo.class.getName()).log(Level.SEVERE, null, ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getPID() {
        int r;
        Object object = syncObj;
        synchronized (object) {
            r = LibC.getpid();
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getParentPID() {
        int r;
        Object object = syncObj;
        synchronized (object) {
            r = LibC.getppid();
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getUID() {
        int r;
        Object object = syncObj;
        synchronized (object) {
            r = LibC.getuid();
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getGID() {
        int r;
        Object object = syncObj;
        synchronized (object) {
            r = LibC.getgid();
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getEUID() {
        int r;
        Object object = syncObj;
        synchronized (object) {
            r = LibC.geteuid();
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getEGID() {
        int r;
        Object object = syncObj;
        synchronized (object) {
            r = LibC.getegid();
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLogin() {
        if (loginFunc != null) {
            return loginFunc.apply();
        }
        String login = null;
        Object object = syncObj;
        synchronized (object) {
            login = LibC.getlogin();
        }
        if (login != null) {
            loginFunc = new Func<String>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public String apply() {
                    String res;
                    Object object = syncObj;
                    synchronized (object) {
                        res = LibC.getlogin();
                    }
                    return res;
                }
            };
            return login;
        }
        object = syncObj;
        synchronized (object) {
            login = LibC.cuserid(Pointer.NULL);
        }
        loginFunc = new Func<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String apply() {
                String res;
                Object object = syncObj;
                synchronized (object) {
                    res = LibC.cuserid(Pointer.NULL);
                }
                return res;
            }
        };
        return login;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getGroupsID() {
        Object object = syncObj;
        synchronized (object) {
            int grpCo = LibC.getgroups(0, null);
            if (grpCo > 0) {
                int[] grpIDs = new int[grpCo];
                grpCo = LibC.getgroups(grpIDs.length, grpIDs);
                return grpIDs;
            }
            return new int[0];
        }
    }
}

