/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.io.fn;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IOFun {
    private static final Lock lock = new ReentrantLock();
    private static int defaultBlockSize = -1;

    private static int getDefaultBlockSize() {
        try {
            lock.lock();
            if (defaultBlockSize < 0) {
                defaultBlockSize = 8192;
            }
            int n = defaultBlockSize;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    public static long copy(InputStream from, OutputStream to, long maxSize, int blockSize, Consumer<Long> progress) throws IOException {
        if (from == null) {
            throw new IllegalArgumentException("from == null");
        }
        if (to == null) {
            throw new IllegalArgumentException("to == null");
        }
        if (blockSize < 1) {
            blockSize = IOFun.getDefaultBlockSize();
        }
        long total = 0L;
        while (!Thread.currentThread().isInterrupted()) {
            byte[] buff;
            int rd;
            int bs = blockSize;
            if (maxSize > 0L) {
                long residue = maxSize - total;
                if (residue <= 0L) break;
                bs = residue > (long)blockSize ? blockSize : (int)residue;
            }
            if ((rd = from.read(buff = new byte[bs])) < 0) break;
            to.write(buff, 0, rd);
            total += (long)rd;
            if (progress == null) continue;
            try {
                progress.accept(total);
            }
            catch (Throwable err) {
                Logger.getLogger(IOFun.class.getName()).log(Level.WARNING, "error: " + err.getMessage(), err);
            }
        }
        return total;
    }

    public static long copy(InputStream from, OutputStream to, long maxSize) throws IOException {
        return IOFun.copy(from, to, maxSize, -1, null);
    }

    public static long copy(InputStream from, OutputStream to) throws IOException {
        return IOFun.copy(from, to, -1L, -1, null);
    }

    public static byte[] readBytes(InputStream from, int maxSize, int blockSize, Consumer<Long> progress) throws IOException {
        if (from == null) {
            throw new IllegalArgumentException("from==null");
        }
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        IOFun.copy(from, ba, maxSize, blockSize, progress);
        return ba.toByteArray();
    }

    public static byte[] readBytes(InputStream from, int maxSize) throws IOException {
        if (from == null) {
            throw new IllegalArgumentException("from==null");
        }
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        IOFun.copy(from, ba, maxSize, -1, null);
        return ba.toByteArray();
    }

    public static byte[] readBytes(InputStream from) throws IOException {
        if (from == null) {
            throw new IllegalArgumentException("from==null");
        }
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        IOFun.copy(from, ba, -1L, -1, null);
        return ba.toByteArray();
    }

    public static void writeBytes(OutputStream to, byte[] data, int dataOffset, int dataSize, int blockSize, BiConsumer<Long, Long> progress) throws IOException {
        int residue;
        if (to == null) {
            throw new IllegalArgumentException("to==null");
        }
        if (data == null) {
            throw new IllegalArgumentException("data==null");
        }
        if (dataOffset < 0) {
            throw new IllegalArgumentException("dataOffset(" + dataOffset + ")<0");
        }
        if (dataSize < 0) {
            throw new IllegalArgumentException("dataSize(" + dataOffset + ")<0");
        }
        if (blockSize < 1) {
            blockSize = IOFun.getDefaultBlockSize();
        }
        if (dataSize == 0) {
            if (progress != null) {
                progress.accept(0L, 0L);
            }
            return;
        }
        int total = 0;
        while ((residue = dataSize - total) > 0) {
            int bs = blockSize;
            bs = residue > blockSize ? blockSize : residue;
            to.write(data, dataOffset + total, bs);
            total += bs;
            if (progress == null) continue;
            try {
                progress.accept(Long.valueOf(total), Long.valueOf(dataSize));
            }
            catch (Throwable err) {
                Logger.getLogger(IOFun.class.getName()).log(Level.WARNING, "error: " + err.getMessage(), err);
            }
        }
        to.flush();
    }

    public static void writeBytes(OutputStream to, byte[] data, int dataOffset, int dataSize) throws IOException {
        IOFun.writeBytes(to, data, dataOffset, dataSize, -1, null);
    }

    public static void writeBytes(OutputStream to, byte[] data) throws IOException {
        if (data == null) {
            throw new IllegalArgumentException("data==null");
        }
        IOFun.writeBytes(to, data, 0, data.length, -1, null);
    }

    public static String readText(InputStream from, Charset cs, int maxSize, int blockSize, Consumer<Long> progress) throws IOException {
        if (from == null) {
            throw new IllegalArgumentException("from==null");
        }
        if (cs == null) {
            cs = Charset.defaultCharset();
        }
        byte[] bytes = IOFun.readBytes(from, maxSize, blockSize, progress);
        return new String(bytes, cs);
    }

    public static String readText(InputStream from, Charset cs, int maxSize) throws IOException {
        if (from == null) {
            throw new IllegalArgumentException("from==null");
        }
        if (cs == null) {
            cs = Charset.defaultCharset();
        }
        byte[] bytes = IOFun.readBytes(from, maxSize, -1, null);
        return new String(bytes, cs);
    }

    public static String readText(InputStream from, String cs) throws IOException {
        return IOFun.readText(from, cs != null ? Charset.forName(cs) : Charset.defaultCharset());
    }

    public static String readText(InputStream from, Charset cs) throws IOException {
        if (from == null) {
            throw new IllegalArgumentException("from==null");
        }
        if (cs == null) {
            cs = Charset.defaultCharset();
        }
        byte[] bytes = IOFun.readBytes(from, -1, -1, null);
        return new String(bytes, cs);
    }

    public static void writeText(OutputStream to, String string, Charset cs, int blockSize, BiConsumer<Long, Long> progress) throws IOException {
        if (to == null) {
            throw new IllegalArgumentException("to==null");
        }
        if (string == null) {
            throw new IllegalArgumentException("string==null");
        }
        if (blockSize < 1) {
            blockSize = IOFun.getDefaultBlockSize();
        }
        if (cs == null) {
            cs = Charset.defaultCharset();
        }
        byte[] data = string.getBytes(cs);
        IOFun.writeBytes(to, data, 0, data.length, blockSize, progress);
    }

    public static void writeText(OutputStream to, String string, String cs) throws IOException {
        IOFun.writeText(to, string, cs != null ? Charset.forName(cs) : Charset.defaultCharset());
    }

    public static void writeText(OutputStream to, String string, Charset cs) throws IOException {
        if (to == null) {
            throw new IllegalArgumentException("to==null");
        }
        if (string == null) {
            throw new IllegalArgumentException("string==null");
        }
        if (cs == null) {
            cs = Charset.defaultCharset();
        }
        byte[] data = string.getBytes(cs);
        IOFun.writeBytes(to, data, 0, data.length, -1, null);
    }

    public static byte[] readBytes(File file, int maxSize, int blockSize, BiConsumer<Long, Long> progress) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        if (blockSize < 1) {
            blockSize = IOFun.getDefaultBlockSize();
        }
        final long fmaxsize = maxSize;
        long total = maxSize >= 0 ? (long)maxSize : -1L;
        final File fil = file;
        final BiConsumer<Long, Long> prgs = progress;
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        FileInputStream fin = new FileInputStream(file);
        IOFun.copy(fin, ba, total, blockSize, new Consumer<Long>(){

            @Override
            public void accept(Long readedTotal) {
                if (prgs != null) {
                    try {
                        long fileSize = fil.length();
                        long total = fmaxsize >= 0L ? fmaxsize : fileSize;
                        prgs.accept(readedTotal, total);
                    }
                    catch (Throwable err) {
                        Logger.getLogger(IOFun.class.getName()).log(Level.WARNING, "error: " + err.getMessage(), err);
                    }
                }
            }
        });
        fin.close();
        return ba.toByteArray();
    }

    public static void writeBytes(File file, byte[] data, int dataOffset, int dataSize, int blockSize, BiConsumer<Long, Long> progress) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        if (data == null) {
            throw new IllegalArgumentException("data==null");
        }
        if (dataOffset < 0) {
            throw new IllegalArgumentException("dataOffset(" + dataOffset + ")<0");
        }
        if (dataSize < 0) {
            throw new IllegalArgumentException("dataSize(" + dataOffset + ")<0");
        }
        if (blockSize < 1) {
            blockSize = IOFun.getDefaultBlockSize();
        }
        FileOutputStream fout = new FileOutputStream(file);
        IOFun.writeBytes(fout, data, dataOffset, dataSize, blockSize, progress);
        fout.flush();
        fout.close();
        if (dataSize == 0 && progress != null) {
            try {
                progress.accept(0L, 0L);
            }
            catch (Throwable err) {
                Logger.getLogger(IOFun.class.getName()).log(Level.WARNING, "error: " + err.getMessage(), err);
            }
        }
    }

    public static void writeBytes(File file, byte[] data, int dataOffset, int dataSize) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        if (data == null) {
            throw new IllegalArgumentException("data==null");
        }
        if (dataOffset < 0) {
            throw new IllegalArgumentException("dataOffset(" + dataOffset + ")<0");
        }
        if (dataSize < 0) {
            throw new IllegalArgumentException("dataSize(" + dataOffset + ")<0");
        }
        FileOutputStream fout = new FileOutputStream(file);
        IOFun.writeBytes(fout, data, dataOffset, dataSize, -1, null);
        fout.flush();
        fout.close();
    }

    public static void writeBytes(File file, byte[] data) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        if (data == null) {
            throw new IllegalArgumentException("data==null");
        }
        FileOutputStream fout = new FileOutputStream(file);
        IOFun.writeBytes(fout, data, 0, data.length, -1, null);
        fout.flush();
        fout.close();
    }

    public static void appendBytes(File file, byte[] data, int dataOffset, int dataSize, int blockSize, BiConsumer<Long, Long> progress) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        if (data == null) {
            throw new IllegalArgumentException("data==null");
        }
        if (dataOffset < 0) {
            throw new IllegalArgumentException("dataOffset(" + dataOffset + ")<0");
        }
        if (dataSize < 0) {
            throw new IllegalArgumentException("dataSize(" + dataOffset + ")<0");
        }
        if (blockSize < 1) {
            blockSize = IOFun.getDefaultBlockSize();
        }
        FileOutputStream fout = new FileOutputStream(file, true);
        IOFun.writeBytes(fout, data, dataOffset, dataSize, blockSize, progress);
        fout.flush();
        fout.close();
        if (dataSize == 0 && progress != null) {
            try {
                progress.accept(0L, 0L);
            }
            catch (Throwable err) {
                Logger.getLogger(IOFun.class.getName()).log(Level.WARNING, "error: " + err.getMessage(), err);
            }
        }
    }

    public static void appendBytes(File file, byte[] data, int dataOffset, int dataSize) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        if (data == null) {
            throw new IllegalArgumentException("data==null");
        }
        if (dataOffset < 0) {
            throw new IllegalArgumentException("dataOffset(" + dataOffset + ")<0");
        }
        if (dataSize < 0) {
            throw new IllegalArgumentException("dataSize(" + dataOffset + ")<0");
        }
        IOFun.appendBytes(file, data, dataOffset, dataSize, -1, null);
    }

    public static void appendBytes(File file, byte[] data) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        if (data == null) {
            throw new IllegalArgumentException("data==null");
        }
        IOFun.appendBytes(file, data, 0, data.length, -1, null);
    }

    public static String readText(File file, Charset cs, int maxSize, int blockSize, BiConsumer<Long, Long> progress) throws IOException {
        if (cs == null) {
            cs = Charset.defaultCharset();
        }
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        byte[] data = IOFun.readBytes(file, maxSize, blockSize, progress);
        return new String(data, cs);
    }

    public static String readText(File file, Charset cs, int maxSize) throws IOException {
        if (cs == null) {
            cs = Charset.defaultCharset();
        }
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        byte[] data = IOFun.readBytes(file, maxSize, -1, null);
        return new String(data, cs);
    }

    public static String readText(File file, String cs) throws IOException {
        return IOFun.readText(file, cs != null ? Charset.forName(cs) : Charset.defaultCharset());
    }

    public static String readText(File file, Charset cs) throws IOException {
        if (cs == null) {
            cs = Charset.defaultCharset();
        }
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        byte[] data = IOFun.readBytes(file, -1, -1, null);
        return new String(data, cs);
    }

    public static void writeText(File file, String string, Charset cs, int blockSize, BiConsumer<Long, Long> progress) throws IOException {
        if (cs == null) {
            cs = Charset.defaultCharset();
        }
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        if (string == null) {
            throw new IllegalArgumentException("string==null");
        }
        FileOutputStream fout = new FileOutputStream(file);
        IOFun.writeText(fout, string, cs, blockSize, progress);
        fout.flush();
        fout.close();
    }

    public static void writeText(File file, String string, String cs) throws IOException {
        IOFun.writeText(file, string, cs != null ? Charset.forName(cs) : Charset.defaultCharset());
    }

    public static void writeText(File file, String string, Charset cs) throws IOException {
        if (cs == null) {
            cs = Charset.defaultCharset();
        }
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        if (string == null) {
            throw new IllegalArgumentException("string==null");
        }
        FileOutputStream fout = new FileOutputStream(file);
        IOFun.writeText(fout, string, cs, -1, null);
        fout.flush();
        fout.close();
    }

    public static void appendText(File file, String string, Charset cs, int blockSize, BiConsumer<Long, Long> progress) throws IOException {
        if (cs == null) {
            cs = Charset.defaultCharset();
        }
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        if (string == null) {
            throw new IllegalArgumentException("string==null");
        }
        FileOutputStream fout = new FileOutputStream(file, true);
        IOFun.writeText(fout, string, cs, blockSize, progress);
        fout.flush();
        fout.close();
    }

    public static void appendText(File file, String string, Charset cs) throws IOException {
        if (cs == null) {
            cs = Charset.defaultCharset();
        }
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        if (string == null) {
            throw new IllegalArgumentException("string==null");
        }
        FileOutputStream fout = new FileOutputStream(file, true);
        IOFun.writeText(fout, string, cs, -1, null);
        fout.flush();
        fout.close();
    }

    public static void appendText(File file, String string, String cs) throws IOException {
        IOFun.appendText(file, string, cs != null ? Charset.forName(cs) : Charset.defaultCharset());
    }

    public static byte[] readBytes(URL url, int maxSize, int blockSize, Consumer<Long> progress) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("url==null");
        }
        InputStream input = url.openStream();
        byte[] res = IOFun.readBytes(input, maxSize, blockSize, progress);
        input.close();
        return res;
    }

    public static byte[] readBytes(URL url) throws IOException {
        return IOFun.readBytes(url, -1, -1, null);
    }

    public static String readText(URL url, Charset cs, int maxSize, int blockSize, Consumer<Long> progress) throws IOException {
        if (cs == null) {
            cs = Charset.defaultCharset();
        }
        byte[] data = IOFun.readBytes(url, maxSize, blockSize, progress);
        return new String(data, cs);
    }

    public static String readText(URL url, Charset cs) throws IOException {
        if (cs == null) {
            cs = Charset.defaultCharset();
        }
        byte[] data = IOFun.readBytes(url, -1, -1, null);
        return new String(data, cs);
    }

    public static String readText(URL url, String cs) throws IOException {
        return IOFun.readText(url, cs != null ? Charset.forName(cs) : Charset.defaultCharset());
    }
}

