/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.io.fs;

import java.util.Iterator;
import java.util.function.Function;
import xyz.cofe.io.fs.DirFollow;
import xyz.cofe.io.fs.File;
import xyz.cofe.io.fs.FileTreeIterator;
import xyz.cofe.iter.Eterable;
import xyz.cofe.iter.TreeStep;

public class FileTreeBuilder
implements Eterable<File> {
    private File from;
    private volatile DirFollow dirFollow;

    protected FileTreeBuilder(FileTreeBuilder sample) {
        if (sample == null) {
            throw new IllegalArgumentException("sample == null");
        }
        this.from = sample.from;
        this.dirFollow = sample.dirFollow == null ? null : sample.dirFollow.clone();
    }

    public FileTreeBuilder(File from) {
        if (from == null) {
            throw new IllegalArgumentException("from==null");
        }
        this.from = from;
    }

    public File getFrom() {
        return this.from;
    }

    public synchronized DirFollow getDirFollow() {
        if (this.dirFollow != null) {
            return this.dirFollow;
        }
        this.dirFollow = new DirFollow();
        return this.dirFollow;
    }

    public FileTreeBuilder dirFollow(DirFollow follow) {
        FileTreeBuilder bld = new FileTreeBuilder(this);
        bld.dirFollow = follow;
        return bld;
    }

    public boolean isCheckDir() {
        return this.getDirFollow().isCheckDir();
    }

    public FileTreeBuilder checkDir(boolean checkDir) {
        DirFollow df = this.getDirFollow().clone();
        df.setCheckDir(checkDir);
        return this.dirFollow(df);
    }

    public boolean isCheckCycle() {
        return this.getDirFollow().isCheckCycle();
    }

    public FileTreeBuilder checkCycle(boolean checkCycle) {
        DirFollow df = this.getDirFollow().clone();
        df.setCheckCycle(checkCycle);
        return this.dirFollow(df);
    }

    public DirFollow.ErrorBehavior getErrorBehavior() {
        return this.getDirFollow().getErrorBehavior();
    }

    public FileTreeBuilder errorBehavior(DirFollow.ErrorBehavior errorBehavior) {
        DirFollow df = this.getDirFollow().clone();
        df.setErrorBehavior(errorBehavior);
        return this.dirFollow(df);
    }

    public boolean isFollowLinks() {
        return this.getDirFollow().isFollowLinks();
    }

    public FileTreeBuilder followLinks(boolean followLinks) {
        DirFollow df = this.getDirFollow().clone();
        df.setFollowLinks(followLinks);
        return this.dirFollow(df);
    }

    public Eterable<TreeStep<File>> tree() {
        return new Eterable<TreeStep<File>>(){

            public Iterator<TreeStep<File>> iterator() {
                return new FileTreeIterator(FileTreeBuilder.this.from, (Function<File, Iterable<? extends File>>)((Object)FileTreeBuilder.this.getDirFollow()));
            }
        };
    }

    public Eterable<File> go() {
        return this.tree().map(t -> t != null ? (File)t.getNode() : null);
    }

    public Iterator<File> iterator() {
        return this.go().iterator();
    }
}

