/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.io.fs;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.io.fs.File;

public class DirIterator
implements Iterator<File>,
Closeable {
    private static final Logger logger = Logger.getLogger(DirIterator.class.getName());
    protected DirectoryStream<Path> dstream;
    protected Iterator<Path> diterator;

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(DirIterator.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(DirIterator.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(DirIterator.class.getName(), method, result);
    }

    public DirIterator(Path path) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("path == null");
        }
        this.dstream = Files.newDirectoryStream(path);
        this.diterator = this.dstream.iterator();
    }

    public DirIterator(File path) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("path == null");
        }
        this.dstream = Files.newDirectoryStream(path.path);
        this.diterator = this.dstream.iterator();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.finish();
    }

    protected synchronized void finish() {
        if (this.diterator != null) {
            this.diterator = null;
        }
        if (this.dstream != null) {
            try {
                this.dstream.close();
            }
            catch (IOException ex) {
                Logger.getLogger(DirIterator.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.dstream = null;
        }
    }

    @Override
    public synchronized boolean hasNext() {
        if (this.diterator == null) {
            return false;
        }
        if (!this.diterator.hasNext()) {
            this.finish();
            return false;
        }
        return true;
    }

    @Override
    public synchronized File next() {
        if (this.diterator == null) {
            return null;
        }
        Path p = this.diterator.next();
        if (p == null) {
            return null;
        }
        return new File(p);
    }

    @Override
    public void remove() {
    }

    @Override
    public synchronized void close() throws IOException {
        this.finish();
    }
}

