/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.io.fs;

import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.io.fs.DirFollow;
import xyz.cofe.io.fs.File;
import xyz.cofe.io.fs.FileTreeIterator;
import xyz.cofe.iter.TreeStep;

public class FileTreeIterable
implements Iterable<TreeStep<File>> {
    private static final Logger logger = Logger.getLogger(FileTreeIterable.class.getName());
    public final File start;
    protected volatile DirFollow dirFollow;
    protected volatile Predicate<File> fileFilter;
    protected volatile Predicate<TreeStep<File>> treeWalkFilter;

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(FileTreeIterable.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(FileTreeIterable.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(FileTreeIterable.class.getName(), method, result);
    }

    public synchronized DirFollow getDirFollow() {
        if (this.dirFollow == null) {
            DirFollow df = new DirFollow();
            df.setCheckCycle(true);
            df.setCheckDir(true);
            df.setErrorBehavior(DirFollow.ErrorBehavior.Continue);
            df.setFollowLinks(true);
            return df;
        }
        return this.dirFollow;
    }

    public synchronized void setDirFollow(DirFollow dirFollow) {
        this.dirFollow = dirFollow;
    }

    public synchronized Predicate<File> getFileFilter() {
        return this.fileFilter;
    }

    public synchronized void setFileFilter(Predicate<File> fileFilter) {
        this.fileFilter = fileFilter;
    }

    public synchronized Predicate<TreeStep<File>> getTreeWalkFilter() {
        return this.treeWalkFilter;
    }

    public synchronized void setTreeWalkFilter(Predicate<TreeStep<File>> treeWalkFilter) {
        this.treeWalkFilter = treeWalkFilter;
    }

    public FileTreeIterable(File start) {
        if (start == null) {
            throw new IllegalArgumentException("start == null");
        }
        this.start = start;
    }

    public synchronized FileTreeIterator iterator() {
        DirFollow df = this.getDirFollow();
        FileTreeIterator fti = new FileTreeIterator(this.start, (Function<File, Iterable<? extends File>>)((Object)df));
        return fti;
    }
}

