/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.io.fs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.BasicVisitor;
import xyz.cofe.collection.NodesExtracter;
import xyz.cofe.collection.Visitor;
import xyz.cofe.io.fs.DirFollowBuilder;
import xyz.cofe.io.fs.DirIterator;
import xyz.cofe.io.fs.FChannelBuffer;

public class File
implements Comparable<File> {
    private static final Logger logger = Logger.getLogger(File.class.getName());
    public final Path path;

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(File.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(File.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(File.class.getName(), method, result);
    }

    public File(Path path) {
        if (path == null) {
            throw new IllegalArgumentException("path == null");
        }
        this.path = path;
    }

    public File(File path) {
        if (path == null) {
            throw new IllegalArgumentException("path == null");
        }
        this.path = path.path;
    }

    public File(String filePath, String ... more) {
        if (filePath == null) {
            throw new IllegalArgumentException("filePath == null");
        }
        FileSystem fs = FileSystems.getDefault();
        this.path = fs.getPath(filePath, more);
    }

    public FileSystem getFileSystem() {
        return this.path.getFileSystem();
    }

    public boolean isAbsolute() {
        return this.path.isAbsolute();
    }

    public File getRoot() {
        Path p = this.path.getRoot();
        return p != null ? new File(p) : null;
    }

    public static List<File> getRootDirectories() {
        ArrayList<File> rootDirs = new ArrayList<File>();
        for (Path rootDir : FileSystems.getDefault().getRootDirectories()) {
            if (rootDir == null) continue;
            File f = new File(rootDir);
            rootDirs.add(f);
        }
        return rootDirs;
    }

    public File getFileName() {
        Path p = this.path.getFileName();
        return p != null ? new File(p) : null;
    }

    public File getParent() {
        Path p = this.path.getParent();
        return p != null ? new File(p) : null;
    }

    public int getNameCount() {
        return this.path.getNameCount();
    }

    public File getName(int index) {
        Path p = this.path.getName(index);
        return p != null ? new File(p) : null;
    }

    public File subpath(int beginIndex, int endIndex) {
        Path p = this.path.subpath(beginIndex, endIndex);
        return p != null ? new File(p) : null;
    }

    public boolean startsWith(Path other) {
        if (other == null) {
            throw new IllegalArgumentException("other==null");
        }
        return this.path.startsWith(other);
    }

    public boolean startsWith(File other) {
        if (other == null) {
            throw new IllegalArgumentException("other==null");
        }
        return this.path.startsWith(other.path);
    }

    public boolean startsWith(String other) {
        return this.path.startsWith(other);
    }

    public boolean endsWith(Path other) {
        return this.path.endsWith(other);
    }

    public boolean endsWith(File other) {
        return this.path.endsWith(other.path);
    }

    public boolean endsWith(String other) {
        return this.path.endsWith(other);
    }

    public File normalize() {
        Path p = this.path.normalize();
        return p != null ? new File(p) : null;
    }

    public File resolve(Path other) {
        if (other == null) {
            throw new IllegalArgumentException("other == null");
        }
        Path p = this.path.resolve(other);
        return p != null ? new File(p) : null;
    }

    public File resolve(File other) {
        if (other == null) {
            throw new IllegalArgumentException("other == null");
        }
        Path p = this.path.resolve(other.path);
        return p != null ? new File(p) : null;
    }

    public File resolve(String other) {
        Path p = this.path.resolve(other);
        return p != null ? new File(p) : null;
    }

    public File resolveSibling(Path other) {
        if (other == null) {
            throw new IllegalArgumentException("other == null");
        }
        Path p = this.path.resolveSibling(other);
        return p != null ? new File(p) : null;
    }

    public File resolveSibling(File other) {
        if (other == null) {
            throw new IllegalArgumentException("other == null");
        }
        Path p = this.path.resolveSibling(other.path);
        return p != null ? new File(p) : null;
    }

    public File resolveSibling(String other) {
        Path p = this.path.resolveSibling(other);
        return p != null ? new File(p) : null;
    }

    public File relativize(Path other) {
        if (other == null) {
            throw new IllegalArgumentException("other == null");
        }
        Path p = this.path.relativize(other);
        return p != null ? new File(p) : null;
    }

    public File relativize(File other) {
        if (other == null) {
            throw new IllegalArgumentException("other == null");
        }
        Path p = this.path.relativize(other.path);
        return p != null ? new File(p) : null;
    }

    public URI toUri() {
        return this.path.toUri();
    }

    public URL toUrl() {
        try {
            return this.path.toUri().toURL();
        }
        catch (MalformedURLException ex) {
            String msg = ex.getMessage();
            throw msg != null ? new IllegalStateException(msg, ex) : new IllegalStateException(ex);
        }
    }

    public File toAbsolute() {
        Path p = this.path.toAbsolutePath();
        return p != null ? new File(p) : null;
    }

    public File toReal(LinkOption ... options) throws IOException {
        Path p = this.path.toRealPath(options);
        return p != null ? new File(p) : null;
    }

    public java.io.File toFile() {
        return this.path.toFile();
    }

    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        return this.path.register(watcher, events, modifiers);
    }

    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        return this.path.register(watcher, events);
    }

    @Override
    public int compareTo(File other) {
        if (other instanceof File) {
            return this.path.compareTo(other.path);
        }
        return 0;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof File) {
            return this.path.equals(((File)other).path);
        }
        return this.path.equals(other);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return this.path.toString();
    }

    public String getName() {
        return this.path.getFileName().toString();
    }

    public String getExtension() {
        String name = this.path.getFileName().toString();
        int dot = name.lastIndexOf(".");
        if (dot < 0) {
            return "";
        }
        if (dot >= name.length() - 1) {
            return "";
        }
        return name.substring(dot + 1);
    }

    public String getBasename() {
        String name = this.path.getFileName().toString();
        int dot = name.lastIndexOf(".");
        if (dot < 0) {
            return name;
        }
        if (dot == 0) {
            return "";
        }
        return name.substring(0, dot);
    }

    public DirIterator dirIterator() {
        try {
            return new DirIterator(this.path);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public List<File> dirList() {
        DirIterator dirItr = this.dirIterator();
        ArrayList<File> list = new ArrayList<File>();
        while (dirItr.hasNext()) {
            File ch = dirItr.next();
            if (ch == null) continue;
            list.add(ch);
        }
        try {
            dirItr.close();
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
        return list;
    }

    public List<File> getFiles() {
        return this.dirList();
    }

    public void visit(Visitor<File> visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("visitor == null");
        }
        BasicVisitor.visit(visitor, (Object)this, (NodesExtracter)new DirFollowBuilder().checkCycle(true).followLinks(true).build());
    }

    public boolean isDirectory(LinkOption ... options) {
        return Files.isDirectory(this.path, options);
    }

    public boolean isRegularFile(LinkOption ... options) {
        return Files.isRegularFile(this.path, options);
    }

    public boolean isFile() {
        return Files.isRegularFile(this.path, new LinkOption[0]);
    }

    public boolean isSymbolicLink() {
        return Files.isSymbolicLink(this.path);
    }

    public boolean isWritable() {
        return Files.isWritable(this.path);
    }

    public boolean isSameFile(Path path2) {
        if (path2 == null) {
            throw new IllegalArgumentException("path2 == null");
        }
        try {
            return Files.isSameFile(this.path, path2);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public boolean isSameFile(File path2) {
        if (path2 == null) {
            throw new IllegalArgumentException("path2 == null");
        }
        try {
            return Files.isSameFile(this.path, path2.path);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public boolean isDir() {
        return Files.isDirectory(this.path, new LinkOption[0]);
    }

    public boolean isExecutable() {
        return Files.isExecutable(this.path);
    }

    public boolean isHidden() {
        try {
            return Files.isHidden(this.path);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public boolean isReadable() {
        return Files.isReadable(this.path);
    }

    public boolean notExists(LinkOption ... opts) {
        return Files.notExists(this.path, opts);
    }

    public boolean notExists() {
        return Files.notExists(this.path, new LinkOption[0]);
    }

    public boolean exists(LinkOption ... options) {
        return Files.exists(this.path, options);
    }

    public boolean isExists() {
        return this.exists(new LinkOption[0]);
    }

    public long getSize() {
        try {
            return Files.size(this.path);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public InputStream readStream(OpenOption ... opts) {
        try {
            return Files.newInputStream(this.path, opts);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public OutputStream writeStream(OpenOption ... opts) {
        try {
            return Files.newOutputStream(this.path, opts);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public void delete() {
        try {
            Files.delete(this.path);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public boolean deleteIfExists() {
        try {
            return Files.deleteIfExists(this.path);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public File createTempFile(String prefix, String suffix, FileAttribute<?> ... attrs) {
        try {
            return new File(Files.createTempFile(this.path, prefix, suffix, attrs));
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public static File tempFile(String prefix, String suffix, FileAttribute<?> ... attrs) {
        try {
            return new File(Files.createTempFile(prefix, suffix, attrs));
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public File createTempDirectory(String prefix, FileAttribute<?> ... attrs) {
        try {
            return new File(Files.createTempDirectory(this.path, prefix, attrs));
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public static File tempDirectory(String prefix, FileAttribute<?> ... attrs) {
        try {
            return new File(Files.createTempDirectory(prefix, attrs));
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public File createDirectories(FileAttribute<?> ... attrs) {
        try {
            return new File(Files.createDirectories(this.path, attrs));
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public File createDirectory(FileAttribute<?> ... attrs) {
        try {
            return new File(Files.createDirectory(this.path, attrs));
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public File createFile(FileAttribute<?> ... attrs) {
        try {
            return new File(Files.createFile(this.path, attrs));
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public File createLink(Path target) {
        if (this.path == null) {
            throw new IllegalArgumentException("path == null");
        }
        try {
            return new File(Files.createLink(this.path, target));
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public File createLink(File target) {
        if (this.path == null) {
            throw new IllegalArgumentException("path == null");
        }
        try {
            return new File(Files.createLink(this.path, target.path));
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public File createSymbolicLink(Path target, FileAttribute<?> ... attrs) {
        try {
            return new File(Files.createSymbolicLink(this.path, target, attrs));
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public File createSymbolicLink(File target, FileAttribute<?> ... attrs) {
        try {
            return new File(Files.createSymbolicLink(this.path, target.path, attrs));
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public Object getAttribute(String attrib, LinkOption ... lopts) {
        try {
            return Files.getAttribute(this.path, attrib, lopts);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public File setAttribute(String attrib, Object value, LinkOption ... lopts) {
        try {
            return new File(Files.setAttribute(this.path, attrib, value, lopts));
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public <V extends FileAttributeView> V getFileAttributeView(Class<V> type, LinkOption ... lopts) {
        return Files.getFileAttributeView(this.path, type, lopts);
    }

    public FileStore getFileStore() {
        try {
            return Files.getFileStore(this.path);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public FileTime getLastModifiedTime(LinkOption ... lopts) {
        try {
            return Files.getLastModifiedTime(this.path, lopts);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public Date getLastModifiedDate(LinkOption ... lopts) {
        FileTime ftime = this.getLastModifiedTime(lopts);
        return new Date(ftime.toMillis());
    }

    public File setLastModifiedTime(FileTime ftime) {
        try {
            return new File(Files.setLastModifiedTime(this.path, ftime));
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public File setLastModifiedDate(Date date) {
        FileTime ftime = FileTime.fromMillis(date.getTime());
        return new File(this.setLastModifiedTime(ftime));
    }

    public UserPrincipal getOwner(LinkOption ... lopts) {
        try {
            return Files.getOwner(this.path, lopts);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public File setOwner(UserPrincipal user) {
        try {
            return new File(Files.setOwner(this.path, user));
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public Set<PosixFilePermission> getPosixFilePermissions(LinkOption ... lopts) {
        try {
            return Files.getPosixFilePermissions(this.path, lopts);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public File setPosixFilePermissions(Set<PosixFilePermission> perms) {
        try {
            return new File(Files.setPosixFilePermissions(this.path, perms));
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public File move(Path target, CopyOption ... copts) {
        try {
            return new File(Files.move(this.path, target, copts));
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public File move(File target, CopyOption ... copts) {
        try {
            return new File(Files.move(this.path, target.path, copts));
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public long copyFrom(InputStream input, CopyOption ... copts) {
        try {
            return Files.copy(input, this.path, copts);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public long copyTo(OutputStream out) {
        try {
            return Files.copy(this.path, out);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public File copyTo(Path target, CopyOption ... copts) {
        try {
            return new File(Files.copy(this.path, target, copts));
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public File copyTo(File target, CopyOption ... copts) {
        try {
            return new File(Files.copy(this.path, target.path, copts));
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public String probeContentType() {
        try {
            return Files.probeContentType(this.path);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public BufferedReader reader(Charset cs) {
        try {
            return Files.newBufferedReader(this.path, cs != null ? cs : Charset.defaultCharset());
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public BufferedReader reader(String cs) {
        try {
            return Files.newBufferedReader(this.path, cs != null ? Charset.forName(cs) : Charset.defaultCharset());
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public BufferedWriter writer(Charset cs) {
        try {
            return Files.newBufferedWriter(this.path, cs, new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public SeekableByteChannel channel(OpenOption ... oopts) {
        try {
            return Files.newByteChannel(this.path, oopts);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public SeekableByteChannel channel(Set<? extends OpenOption> options, FileAttribute<?> ... attrs) {
        try {
            return Files.newByteChannel(this.path, options, attrs);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public byte[] readAllBytes() {
        try {
            return Files.readAllBytes(this.path);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public File write(byte[] bytes, OpenOption ... oopts) {
        try {
            return new File(Files.write(this.path, bytes, oopts));
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public List<String> readAllLines(Charset cs) {
        try {
            return Files.readAllLines(this.path, cs == null ? Charset.defaultCharset() : cs);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public List<String> readAllLines(String cs) {
        try {
            return Files.readAllLines(this.path, cs == null ? Charset.defaultCharset() : Charset.forName(cs));
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public String readText(Charset cs) {
        if (cs == null) {
            throw new IllegalArgumentException("cs == null");
        }
        StringBuilder sb = new StringBuilder();
        BufferedReader rd = this.reader(cs);
        try {
            int readed;
            char[] cbuff = new char[8192];
            while ((readed = rd.read(cbuff)) >= 0) {
                if (readed <= 0) continue;
                sb.append(cbuff, 0, readed);
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
        finally {
            if (rd != null) {
                try {
                    ((Reader)rd).close();
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
            }
        }
    }

    public String readText(String cs) {
        if (cs == null) {
            throw new IllegalArgumentException("cs == null");
        }
        StringBuilder sb = new StringBuilder();
        BufferedReader rd = this.reader(cs);
        try {
            int readed;
            char[] cbuff = new char[8192];
            while ((readed = rd.read(cbuff)) >= 0) {
                if (readed <= 0) continue;
                sb.append(cbuff, 0, readed);
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
        finally {
            if (rd != null) {
                try {
                    ((Reader)rd).close();
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeText(String text, Charset cs) {
        if (text == null) {
            throw new IllegalArgumentException("text == null");
        }
        if (cs == null) {
            throw new IllegalArgumentException("cs == null");
        }
        BufferedWriter wr = this.writer(cs);
        try {
            try {
                wr.write(text);
            }
            catch (IOException ex) {
                throw new IOError(ex);
            }
        }
        finally {
            try {
                ((Writer)wr).close();
            }
            catch (IOException ex) {
                throw new IOError(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeText(String text, String cs) {
        if (text == null) {
            throw new IllegalArgumentException("text == null");
        }
        BufferedWriter wr = this.writer(cs != null ? Charset.forName(cs) : Charset.defaultCharset());
        try {
            try {
                wr.write(text);
            }
            catch (IOException ex) {
                throw new IOError(ex);
            }
        }
        finally {
            try {
                ((Writer)wr).close();
            }
            catch (IOException ex) {
                throw new IOError(ex);
            }
        }
    }

    public File write(Iterable<? extends CharSequence> lines, Charset cs, OpenOption ... options) {
        try {
            return new File(Files.write(this.path, lines, cs, options));
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public File write(Iterable<? extends CharSequence> lines, String cs, OpenOption ... options) {
        try {
            return new File(Files.write(this.path, lines, cs != null ? Charset.forName(cs) : Charset.defaultCharset(), options));
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public FChannelBuffer randomAccess(OpenOption ... options) {
        return FChannelBuffer.open(this, options);
    }

    public FChannelBuffer randomAccess(Set<? extends OpenOption> options, FileAttribute<?> ... attrs) {
        return FChannelBuffer.open(this, options, attrs);
    }
}

