/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.template.ctx;

import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.fs.ByteSize;
import xyz.cofe.fs.File;
import xyz.cofe.fs.FileSystem;
import xyz.cofe.text.template.ctx.DateVar;

public class FileVar {
    private static final Logger logger = Logger.getLogger(FileVar.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private final File file;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public FileVar(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public FileSystem getFileSystem() {
        return this.file.getFileSystem();
    }

    public FileVar getParent() {
        File f = this.file.getParent();
        if (f != null) {
            return new FileVar(f);
        }
        return null;
    }

    public FileVar getChild(String name) {
        File f = this.file.getChild(name);
        if (f != null) {
            return new FileVar(f);
        }
        return null;
    }

    public FileVar getCanonical() {
        File f = this.file.getCanonical();
        if (f != null) {
            return new FileVar(f);
        }
        return null;
    }

    public FileVar getAbsolute() {
        File f = this.file.getAbsolute();
        if (f != null) {
            return new FileVar(f);
        }
        return null;
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public boolean isFile() {
        return this.file.isFile();
    }

    public boolean isExists() {
        return this.file.isExists();
    }

    public DateVar getModifyDate() {
        return new DateVar(this.file.getModifyDate());
    }

    public long getLength() {
        return this.file.getLength();
    }

    public String getSizeRound() {
        return new ByteSize(this.file.getLength()).toStringRoundMin(2);
    }

    public boolean isReadable() {
        return this.file.isReadable();
    }

    public boolean isWritable() {
        return this.file.isWritable();
    }

    public boolean isExecutable() {
        return this.file.isExecutable();
    }

    public String getName() {
        return this.file.getName();
    }

    public String getPath() {
        return this.file.getPath();
    }

    public boolean isAbsolute() {
        return this.file.isAbsolute();
    }

    public boolean isRoot() {
        return this.file.isRoot();
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

