/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.fs.java;

import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.fs.File;
import xyz.cofe.fs.FileSystem;
import xyz.cofe.fs.FileSystemInfo;
import xyz.cofe.fs.java.JavaFile;
import xyz.cofe.fs.java.RootJavaFile;

public class JavaFileSystem
implements FileSystem,
FileSystemInfo {
    private static Boolean isOS_Windows = null;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(JavaFileSystem.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(JavaFileSystem.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(JavaFileSystem.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(JavaFileSystem.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(JavaFileSystem.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(JavaFileSystem.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(JavaFileSystem.class.getName()).log(Level.SEVERE, null, ex);
    }

    public Class getFileType() {
        return JavaFile.class;
    }

    public File get(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path==null");
        }
        return new JavaFile(path);
    }

    public File getRoot() {
        return RootJavaFile.get();
    }

    protected boolean isOS_Windows() {
        if (isOS_Windows != null) {
            return isOS_Windows;
        }
        String os = System.getProperty("os.name");
        if (os != null) {
            isOS_Windows = os.toLowerCase().contains("windows");
            return isOS_Windows;
        }
        return false;
    }

    public boolean isFileNameIgnoreCase() {
        return this.isOS_Windows();
    }

    public String getFileSeparator() {
        return System.getProperty("file.separator", "/");
    }
}

