/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.fs.java;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.common.Reciver;
import xyz.cofe.fs.AbstractFile;
import xyz.cofe.fs.File;
import xyz.cofe.fs.FileSystem;
import xyz.cofe.fs.FileVisitor;
import xyz.cofe.fs.OpenMode;
import xyz.cofe.fs.Path;
import xyz.cofe.fs.UnixFile;
import xyz.cofe.fs.UnixPath;
import xyz.cofe.fs.VisitOptions;
import xyz.cofe.fs.java.JavaFileSystem;
import xyz.cofe.fs.java.RootJavaFile;

public class JavaFile
extends AbstractFile
implements File {
    protected java.io.File file = null;
    private static Boolean isOS_Windows = null;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(JavaFile.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(JavaFile.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(JavaFile.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(JavaFile.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(JavaFile.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(JavaFile.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(JavaFile.class.getName()).log(Level.SEVERE, null, ex);
    }

    protected JavaFile() {
    }

    public JavaFile(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path==null");
        }
        this.file = new java.io.File(path);
    }

    public JavaFile(java.io.File path) {
        if (path == null) {
            throw new IllegalArgumentException("path==null");
        }
        this.file = path;
    }

    public JavaFile(JavaFile src) {
        java.io.File f;
        if (src != null && (f = src.getFile()) != null) {
            this.file = new java.io.File(f.getPath());
        }
    }

    public JavaFile clone() {
        return new JavaFile(this);
    }

    public java.io.File getFile() {
        return this.file;
    }

    public boolean equals(Object obj) {
        if (obj instanceof JavaFile) {
            if (this.file == null) {
                return ((JavaFile)((Object)obj)).file == null;
            }
            return this.file.getPath().equals(((JavaFile)((Object)obj)).file.getPath());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.file != null ? this.file.hashCode() : 0);
        return hash;
    }

    public FileSystem getFileSystem() {
        return new JavaFileSystem();
    }

    public JavaFile getCanonical() {
        try {
            return new JavaFile(this.file.getCanonicalFile());
        }
        catch (IOException ex) {
            return null;
        }
    }

    public JavaFile getAbsolute() {
        return new JavaFile(this.file.getAbsoluteFile());
    }

    public boolean isAbsolute() {
        return this.file.isAbsolute();
    }

    public boolean isRoot() {
        if (!this.isAbsolute()) {
            try {
                java.io.File cf = this.file.getAbsoluteFile().getCanonicalFile();
                return cf.getParentFile() == null;
            }
            catch (IOException ex) {
                throw new IOError(ex);
            }
        }
        java.io.File p = this.file.getParentFile();
        return p == null;
    }

    public JavaFile getParent() {
        java.io.File p = this.file.getParentFile();
        if (p == null) {
            if (this.file.isAbsolute()) {
                return RootJavaFile.get();
            }
            return null;
        }
        return new JavaFile(p);
    }

    public JavaFile getChild(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name==null");
        }
        java.io.File f = new java.io.File(this.file, name);
        return new JavaFile(f);
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public boolean isFile() {
        return this.file.isFile();
    }

    public boolean isExists() {
        return this.file.exists();
    }

    public List<File> listFiles() {
        java.io.File[] files = this.file.listFiles();
        ArrayList<File> res = new ArrayList<File>();
        if (files == null) {
            return res;
        }
        for (java.io.File f : files) {
            if (f == null || f.getName().equals(".") || f.getName().equals("..")) continue;
            res.add(new JavaFile(f));
        }
        return res;
    }

    public Date getModifyDate() {
        return new Date(this.file.lastModified());
    }

    public long getLength() {
        return this.file.length();
    }

    private boolean windows_isAbsPath(String p) {
        if (p.length() > 2) {
            char c0 = p.charAt(0);
            char c1 = p.charAt(1);
            if (Character.isLetter(c0) && c1 == ':') {
                return true;
            }
        }
        return false;
    }

    private String[] windows_getComponents() {
        char filesepc;
        String p = this.file.getPath();
        String filesep = System.getProperty("file.separator", "\\");
        char c = filesepc = filesep.length() > 0 ? (char)filesep.charAt(0) : (char)'\\';
        if (this.windows_isAbsPath(p)) {
            String drive = p.substring(0, 2);
            StringBuilder sb = new StringBuilder();
            ArrayList<String> cmpts = new ArrayList<String>();
            for (int i = 3; i < p.length(); ++i) {
                char c2 = p.charAt(i);
                if (c2 == filesepc) {
                    cmpts.add(sb.toString());
                    sb.setLength(0);
                    continue;
                }
                sb.append(c2);
            }
            if (sb.length() > 0) {
                cmpts.add(sb.toString());
            }
            cmpts.add(0, drive);
            return cmpts.toArray(new String[0]);
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<String> cmpts = new ArrayList<String>();
        for (int i = 0; i < p.length(); ++i) {
            char c3 = p.charAt(i);
            if (c3 == filesepc) {
                cmpts.add(sb.toString());
                sb.setLength(0);
                continue;
            }
            sb.append(c3);
        }
        if (sb.length() > 0) {
            cmpts.add(sb.toString());
        }
        return cmpts.toArray(new String[0]);
    }

    private String[] unix_getComponents() {
        UnixPath up = new UnixPath(this.file.getPath());
        return up.getComponents();
    }

    protected boolean isOS_Windows() {
        if (isOS_Windows != null) {
            return isOS_Windows;
        }
        String os = System.getProperty("os.name");
        if (os != null) {
            isOS_Windows = os.toLowerCase().contains("windows");
            return isOS_Windows;
        }
        return false;
    }

    public String[] getComponents() {
        return this.isOS_Windows() ? this.windows_getComponents() : this.unix_getComponents();
    }

    public String getName() {
        return this.file.getName();
    }

    public String getPath() {
        return this.file.getPath();
    }

    public int compareTo(Path o) {
        String p0 = this.getPath();
        String p1 = o.getPath();
        return this.isOS_Windows() ? p0.compareToIgnoreCase(p1) : p0.compareTo(p1);
    }

    public BufferedInputStream openRead() {
        try {
            FileInputStream fin = new FileInputStream(this.file);
            BufferedInputStream bin = new BufferedInputStream(fin);
            return bin;
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public BufferedOutputStream openWrite() {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(this.file);
            BufferedOutputStream bout = new BufferedOutputStream(fout);
            return bout;
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public BufferedOutputStream openAppend() {
        try {
            FileOutputStream fout = new FileOutputStream(this.file, true);
            BufferedOutputStream bout = new BufferedOutputStream(fout);
            return bout;
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public RandomAccessFile openReadWrite(OpenMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("mode==null");
        }
        try {
            String m = "r";
            switch (mode) {
                case Read: {
                    m = "r";
                    break;
                }
                case ReadWrite: {
                    m = "rw";
                    break;
                }
                case ReadWriteSync: {
                    m = "rws";
                    break;
                }
                case ReadWriteSyncMeta: {
                    m = "rwd";
                }
            }
            return new RandomAccessFile(this.file, m);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public Iterable<File> walk(VisitOptions opts) {
        FileVisitor visit = new FileVisitor();
        VisitOptions vopt = opts == null ? new VisitOptions(true) : opts;
        this.apply(visit, vopt);
        return visit.walkIterable((File)this);
    }

    public Iterable<File> walk() {
        FileVisitor visit = new FileVisitor();
        VisitOptions vopt = new VisitOptions(true);
        this.apply(visit, vopt);
        return visit.walkIterable((File)this);
    }

    public boolean isReadable() {
        return this.file.canRead();
    }

    public void setReadable(boolean readable) {
        this.file.setReadable(readable);
    }

    public void setReadable(boolean readable, boolean ownerOnly) {
        this.file.setReadable(readable, ownerOnly);
    }

    public boolean isWritable() {
        return this.file.canWrite();
    }

    public void setWritable(boolean writable) {
        this.file.setWritable(writable);
    }

    public void setWritable(boolean writable, boolean ownerOnly) {
        this.file.setWritable(writable, ownerOnly);
    }

    public boolean isExecutable() {
        return this.file.canExecute();
    }

    public void setExecutable(boolean executable) {
        this.file.setExecutable(executable);
    }

    public void setExecutable(boolean executable, boolean ownerOnly) {
        this.file.setExecutable(executable, ownerOnly);
    }

    public void setModifyDate(Date modifyDate) {
        if (modifyDate == null) {
            throw new IllegalArgumentException("modifyDate==null");
        }
        this.file.setLastModified(modifyDate.getTime());
    }

    private void apply(FileVisitor visitor, VisitOptions opts) {
        if (visitor == null || opts == null) {
            return;
        }
        Boolean v = opts.isFollowLink();
        if (v != null) {
            visitor.setFollowLink(v.booleanValue());
        }
    }

    public void delete() {
        this.delete(null);
    }

    public void delete(Reciver<File> deleted) {
        VisitOptions vopt = new VisitOptions(false);
        this.delete(deleted, vopt);
    }

    public void delete(final Reciver<File> deleted, VisitOptions opts) {
        FileVisitor visitor = new FileVisitor(){

            public synchronized void exit(Stack<File> path) {
                try {
                    File file;
                    if (!path.empty() && (file = path.peek()) instanceof JavaFile) {
                        JavaFile jfile = (JavaFile)file;
                        java.io.File f = jfile.getFile();
                        if (!f.delete()) {
                            throw new Error("can't delete " + f.getPath());
                        }
                        if (deleted != null) {
                            deleted.recive((Object)jfile);
                        }
                    }
                }
                catch (Throwable e) {
                    JavaFile.logException(e);
                }
            }
        };
        this.apply(visitor, opts);
        visitor.walk((File)this);
    }

    public void mkdir() {
        if (!this.file.mkdir()) {
            throw new Error("can't create directory " + this.file.getPath());
        }
    }

    public void mkdirs() {
        if (!this.file.mkdirs()) {
            throw new Error("can't create directory " + this.file.getPath());
        }
    }

    public void renameTo(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        if (file instanceof JavaFile) {
            java.io.File target = ((JavaFile)file).getFile();
            if (!this.file.renameTo(target)) {
                throw new Error("can't " + this.file.getPath() + " rename to " + target.getPath());
            }
            this.file = target;
        } else if (file instanceof UnixFile) {
            java.io.File target = new java.io.File(((UnixFile)file).getPath());
            if (!this.file.renameTo(target)) {
                throw new Error("can't " + this.file.getPath() + " rename to " + target.getPath());
            }
            this.file = target;
        }
    }

    public String toString() {
        String path = this.getPath();
        return path == null ? super.toString() : path;
    }
}

