/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.fs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import xyz.cofe.collection.Convertor;
import xyz.cofe.collection.Func1;
import xyz.cofe.collection.Iterators;
import xyz.cofe.collection.Predicate;
import xyz.cofe.collection.iterators.TreeWalk;
import xyz.cofe.fs.File;
import xyz.cofe.fs.FileSystem;
import xyz.cofe.fs.FileSystemInfo;
import xyz.cofe.fs.FileSystems;
import xyz.cofe.fs.FileVisitor;
import xyz.cofe.fs.UnixPath;
import xyz.cofe.text.Text;

public class Glob {
    private static final Logger logger = Logger.getLogger(Glob.class.getName());
    private static final Level logLevel = logger.getLevel();
    private List<UnixPath> pattern = new ArrayList<UnixPath>();
    private static final char pathsep = ':';
    private static final char filesep = '/';
    private static final char escape = '\\';
    private static final boolean useescape = true;
    private static final char anyrepeat = '*';
    private static final char any = '?';
    private FileSystem fileSystem;
    private File workDirectory;
    private Boolean ignoreCase = null;
    private Func1<Object, File> matched;
    private Func1<Object, File> skipped;
    private Boolean followLink;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public static Glob parse(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("pattern==null");
        }
        Glob glob = new Glob();
        for (String ptrn : Text.split((String)pattern, (String)":")) {
            if (ptrn == null || ptrn.length() == 0) continue;
            UnixPath upath = new UnixPath(ptrn, true, '\\', '/');
            glob.pattern.add(upath);
        }
        return glob;
    }

    private static boolean cnameIsPattern(String cname) {
        if (cname.contains("*")) {
            return true;
        }
        return cname.contains("?");
    }

    private static FollowPattern getFollowPatern(UnixPath pattern, FileSystem fs, File wd) {
        String[] fcmpts = pattern.getComponents();
        if (fcmpts == null || fcmpts.length == 0) {
            return null;
        }
        int fcIdx = 0;
        File offset = null;
        while (offset == null && fcIdx < fcmpts.length) {
            if (fcmpts[fcIdx].length() == 0 && fcIdx == 0) {
                offset = fs.getRoot();
                ++fcIdx;
                break;
            }
            if (fcmpts[fcIdx].equals("..")) {
                File pwd;
                File file = pwd = wd.isAbsolute() ? wd.getParent() : wd.getChild("..");
                if (pwd != null) {
                    wd = pwd;
                }
                ++fcIdx;
                continue;
            }
            if (fcmpts[fcIdx].equals(".") || fcmpts[fcIdx].length() == 0) {
                ++fcIdx;
                continue;
            }
            if (Glob.cnameIsPattern(fcmpts[fcIdx])) {
                offset = wd;
                break;
            }
            offset = wd.getChild(fcmpts[fcIdx]);
            ++fcIdx;
            break;
        }
        if (offset == null) {
            return null;
        }
        if (!offset.isExists()) {
            return null;
        }
        if (fcIdx >= fcmpts.length) {
            return null;
        }
        String[] nc = Arrays.copyOfRange(fcmpts, fcIdx, fcmpts.length);
        FollowPattern fp = new FollowPattern();
        fp.from = offset;
        fp.pattern = nc;
        return fp;
    }

    private ArrayList<String> walkToNames(TreeWalk<File> tw) {
        ArrayList<String> names = new ArrayList<String>();
        while (tw != null) {
            names.add(0, ((File)tw.currentNode()).getName());
            tw = tw.parent();
        }
        return names;
    }

    private static StringBuilder wildcard(String wildcard, boolean escapeAllowed) {
        if (wildcard == null) {
            throw new IllegalArgumentException("wildcard==null");
        }
        StringBuilder sb = new StringBuilder();
        if (escapeAllowed) {
            boolean qOpen = false;
            boolean esc = false;
            block5: for (int i = 0; i < wildcard.length(); ++i) {
                char c = wildcard.charAt(i);
                switch (c) {
                    case '?': {
                        if (esc) {
                            if (!qOpen) {
                                sb.append("\\Q");
                                qOpen = true;
                            }
                            sb.append("?");
                            continue block5;
                        }
                        if (qOpen) {
                            sb.append("\\E");
                            qOpen = false;
                        }
                        sb.append(".");
                        continue block5;
                    }
                    case '*': {
                        char nc;
                        if (esc) {
                            if (!qOpen) {
                                sb.append("\\Q");
                                qOpen = true;
                            }
                            sb.append("*");
                            continue block5;
                        }
                        if (qOpen) {
                            sb.append("\\E");
                            qOpen = false;
                        }
                        char c2 = nc = i + 1 < wildcard.length() ? wildcard.charAt(i + 1) : (char)'\u0000';
                        if (nc == '*') {
                            ++i;
                            sb.append(".*?");
                            continue block5;
                        }
                        sb.append("[^/]*?");
                        continue block5;
                    }
                    case '\\': {
                        if (esc) {
                            if (!qOpen) {
                                sb.append("\\Q");
                                qOpen = true;
                            }
                            sb.append('\\');
                            esc = false;
                            continue block5;
                        }
                        esc = true;
                        continue block5;
                    }
                    default: {
                        if (!qOpen) {
                            sb.append("\\Q");
                            qOpen = true;
                        }
                        sb.append(c);
                    }
                }
            }
            if (qOpen) {
                sb.append("\\E");
                boolean bl = false;
            }
        } else {
            wildcard = wildcard.replace("?", ".");
            wildcard = wildcard.replace("*", ".*?");
            sb.append(wildcard);
        }
        return sb;
    }

    private Pattern getRegex(String[] cmpt, boolean icase) {
        StringBuilder sb = new StringBuilder();
        String prevs = null;
        for (String s : cmpt) {
            if (sb.length() > 0) {
                if (prevs == null) {
                    sb.append("/");
                } else if (!prevs.equals("**")) {
                    sb.append("/");
                }
            }
            sb.append(s);
            prevs = s;
        }
        String wc = sb.toString().replaceAll("\\*{3,}", "**");
        sb = Glob.wildcard(wc, true);
        if (icase) {
            sb.insert(0, "(?is).*");
        } else {
            sb.insert(0, "(?s).*");
        }
        sb.append("$");
        return Pattern.compile(sb.toString());
    }

    private Predicate<TreeWalk<File>> pred(final Pattern ptrn, final Func1<Object, File> matched, final Func1<Object, File> skipped) {
        return new Predicate<TreeWalk<File>>(){

            public boolean validate(TreeWalk<File> t) {
                ArrayList cnames = Glob.this.walkToNames((TreeWalk<File>)t);
                if (!cnames.isEmpty()) {
                    cnames.remove(0);
                }
                String names = Text.join((Iterable)cnames, (String)"/");
                boolean m = ptrn.matcher(names).matches();
                if (matched != null && m) {
                    matched.apply(t.currentNode());
                }
                if (skipped != null && !m) {
                    skipped.apply(t.currentNode());
                }
                return m;
            }
        };
    }

    public Glob fs(FileSystem fs) {
        this.fileSystem = fs;
        return this;
    }

    public Glob cd(File workDirectory) {
        this.workDirectory = workDirectory;
        return this;
    }

    public Glob icase(Boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        return this;
    }

    public Glob matched(Func1<Object, File> matched) {
        this.matched = matched;
        return this;
    }

    public Glob skipped(Func1<Object, File> skipped) {
        this.skipped = skipped;
        return this;
    }

    public Glob followLink(Boolean followLink) {
        this.followLink = followLink;
        return this;
    }

    private Iterable<File> get(UnixPath up) {
        FileSystem fs;
        FollowPattern fp = Glob.getFollowPatern(up, this.fileSystem == null ? FileSystems.get().getDefault() : this.fileSystem, this.workDirectory == null ? FileSystems.get().getDefault().get(".") : this.workDirectory);
        if (fp == null || fp.from == null || fp.pattern == null) {
            return Iterators.empty();
        }
        boolean icase = false;
        icase = this.ignoreCase == null ? ((fs = fp.from.getFileSystem()) instanceof FileSystemInfo ? ((FileSystemInfo)fs).isFileNameIgnoreCase() : false) : this.ignoreCase;
        FileVisitor fv = new FileVisitor();
        fv.setUseAbsolutePath(false);
        if (this.followLink != null) {
            fv.setFollowLink(this.followLink.booleanValue());
        }
        Convertor<File, File> dropFirstDots = new Convertor<File, File>(){

            public File convert(File from) {
                if (!from.isAbsolute()) {
                    ArrayList<String> lc = new ArrayList<String>();
                    for (String cmpt : from.getComponents()) {
                        if (cmpt.equals(".") || cmpt.equals("")) continue;
                        lc.add(cmpt);
                    }
                    FileSystem fs = from.getFileSystem();
                    if (!lc.isEmpty()) {
                        File off = fs.get((String)lc.get(0));
                        lc.remove(0);
                        for (String c : lc) {
                            off = off.getChild(c);
                        }
                        return off;
                    }
                }
                return from.getCanonical();
            }
        };
        Func1<Object, File> fmatched = this.matched;
        Func1<Object, File> fskipped = this.skipped;
        Iterable files = fv.treeWalkIterable(fp.from);
        files = Iterators.predicate((Iterable)files, this.pred(this.getRegex(fp.pattern, icase), new Func1<Object, File>((Convertor)dropFirstDots, fmatched){
            final /* synthetic */ Convertor val$dropFirstDots;
            final /* synthetic */ Func1 val$fmatched;
            {
                this.val$dropFirstDots = convertor;
                this.val$fmatched = func1;
            }

            public Object apply(File f) {
                f = (File)this.val$dropFirstDots.convert((Object)f);
                if (this.val$fmatched != null) {
                    this.val$fmatched.apply((Object)f);
                }
                return null;
            }
        }, new Func1<Object, File>((Convertor)dropFirstDots, fskipped){
            final /* synthetic */ Convertor val$dropFirstDots;
            final /* synthetic */ Func1 val$fskipped;
            {
                this.val$dropFirstDots = convertor;
                this.val$fskipped = func1;
            }

            public Object apply(File f) {
                f = (File)this.val$dropFirstDots.convert((Object)f);
                if (this.val$fskipped != null) {
                    this.val$fskipped.apply((Object)f);
                }
                return null;
            }
        }));
        Iterable itr = Iterators.convert((Iterable)files, (Convertor)new FileVisitor.ConvertTreeWalk());
        itr = Iterators.convert((Iterable)itr, (Convertor)dropFirstDots);
        return itr;
    }

    public Iterable<File> find() {
        Iterable itr = null;
        for (UnixPath up : this.pattern) {
            Iterable itr1 = this.get(up);
            itr = itr == null ? itr1 : Iterators.sequence((Iterable[])new Iterable[]{itr, itr1});
        }
        return itr;
    }

    private static class FollowPattern {
        public File from;
        public String[] pattern;

        private FollowPattern() {
        }
    }
}

