/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.fs;

import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.fs.File;
import xyz.cofe.fs.FileSystem;
import xyz.cofe.fs.GetWorkDir;
import xyz.cofe.fs.java.JavaFileSystem;
import xyz.cofe.fs.spi.OSFileSystemService;

public class FileSystems {
    private static FileSystems instance = null;
    private FileSystem defaultSystem = null;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(FileSystems.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(FileSystems.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(FileSystems.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(FileSystems.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(FileSystems.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(FileSystems.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(FileSystems.class.getName()).log(Level.SEVERE, null, ex);
    }

    protected FileSystems() {
    }

    public static FileSystems get() {
        if (instance != null) {
            return instance;
        }
        instance = new FileSystems();
        return instance;
    }

    public FileSystem getDefault() {
        if (this.defaultSystem != null) {
            return this.defaultSystem;
        }
        String os = System.getProperty("os.name");
        for (OSFileSystemService srvc : ServiceLoader.load(OSFileSystemService.class)) {
            FileSystem fs;
            if (srvc == null || (fs = srvc.getFileSystem(os)) == null) continue;
            this.defaultSystem = fs;
            return this.defaultSystem;
        }
        this.defaultSystem = new JavaFileSystem();
        return this.defaultSystem;
    }

    public File getWorkDir() {
        FileSystem fs = this.getDefault();
        if (fs instanceof GetWorkDir) {
            return ((GetWorkDir)fs).getWorkDir();
        }
        String curdir = System.getProperty("user.dir", ".");
        return fs.get(curdir);
    }

    public static File get(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path==null");
        }
        return FileSystems.get().getDefault().get(path);
    }

    public static File workDir() {
        return FileSystems.get().getWorkDir();
    }

    public static File root() {
        return FileSystems.get().getDefault().getRoot();
    }
}

