/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.fs;

import java.util.List;
import java.util.regex.Pattern;
import xyz.cofe.collection.Iterators;
import xyz.cofe.collection.Predicate;
import xyz.cofe.collection.Predicates;
import xyz.cofe.fs.File;
import xyz.cofe.fs.FileSystem;
import xyz.cofe.fs.FileSystemInfo;
import xyz.cofe.text.Text;

public class FilePredicates {
    public static Predicate<File> nameEquals(final String name) {
        return new Predicate<File>(){

            public boolean validate(File value) {
                FileSystem fs;
                if (value == null) {
                    return false;
                }
                boolean ignoreCase = value instanceof FileSystemInfo ? ((FileSystemInfo)value).isFileNameIgnoreCase() : ((fs = value.getFileSystem()) instanceof FileSystemInfo ? ((FileSystemInfo)fs).isFileNameIgnoreCase() : false);
                String n = value.getName();
                if (n == null) {
                    return false;
                }
                if (ignoreCase) {
                    return n.equalsIgnoreCase(name);
                }
                return n.equals(name);
            }
        };
    }

    public static Predicate<File> nameWildcard(String wildcard) {
        final String f_wildcard = wildcard;
        return new Predicate<File>(){
            Pattern ptrn;
            Pattern ptrnIgnoreCase;

            public boolean validate(File value) {
                FileSystem fs;
                if (value == null) {
                    return false;
                }
                if (f_wildcard == null) {
                    return false;
                }
                if (f_wildcard.length() == 0) {
                    String n = value.getName();
                    return n.length() == 0;
                }
                boolean ignoreCase = value instanceof FileSystemInfo ? ((FileSystemInfo)value).isFileNameIgnoreCase() : ((fs = value.getFileSystem()) instanceof FileSystemInfo ? ((FileSystemInfo)fs).isFileNameIgnoreCase() : false);
                Pattern ptr = ignoreCase ? (this.ptrn == null ? (this.ptrn = Text.wildcard((String)f_wildcard, (boolean)false, (boolean)true)) : this.ptrn) : (this.ptrnIgnoreCase == null ? (this.ptrnIgnoreCase = Text.wildcard((String)f_wildcard, (boolean)false, (boolean)false)) : this.ptrnIgnoreCase);
                if (ptr == null) {
                    return false;
                }
                String n = value.getName();
                return ptr.matcher(n).matches();
            }
        };
    }

    public static Predicate<File> isFile() {
        return new Predicate<File>(){

            public boolean validate(File value) {
                if (value == null) {
                    return false;
                }
                return value.isFile();
            }
        };
    }

    public static Predicate<File> isDir() {
        return new Predicate<File>(){

            public boolean validate(File value) {
                if (value == null) {
                    return false;
                }
                return value.isDirectory();
            }
        };
    }

    public static Predicate<File> and(Predicate<File> ... p) {
        return Predicates.and(p);
    }

    public static Predicate<File> or(Predicate<File> ... p) {
        return Predicates.or(p);
    }

    public static Predicate<File> not(Predicate<File> p) {
        return Predicates.not(p);
    }

    public static boolean in(Predicate<File> p, Iterable<File> files) {
        return Iterators.count((Iterable)Iterators.predicate(files, p)) > 0L;
    }

    public static Predicate<File> dirContains(final Predicate<File> p) {
        return new Predicate<File>(){

            public boolean validate(File value) {
                if (value == null) {
                    return false;
                }
                if (!value.isDirectory()) {
                    return false;
                }
                List lf = value.listFiles();
                return FilePredicates.in((Predicate<File>)p, lf);
            }
        };
    }

    public static Predicate<File> dirEmpty() {
        return new Predicate<File>(){

            public boolean validate(File value) {
                if (value == null) {
                    return false;
                }
                if (!value.isDirectory()) {
                    return false;
                }
                List lf = value.listFiles();
                return lf == null || lf.isEmpty();
            }
        };
    }

    public static Predicate<File> dirEmpty(boolean recursive) {
        return new Predicate<File>(){

            public boolean validate(File value) {
                if (value == null) {
                    return false;
                }
                if (!value.isDirectory()) {
                    return false;
                }
                int c = 0;
                for (File f : value.walk()) {
                    if (!f.isFile()) continue;
                    ++c;
                }
                return c == 0;
            }
        };
    }
}

