/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.fs;

import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import xyz.cofe.fs.ByteName;
import xyz.cofe.text.Text;

public class ByteSize
implements Comparable<ByteSize> {
    protected int sign = 1;
    protected int bytes = 0;
    protected int kbytes = 0;
    protected int mbytes = 0;
    protected int gbytes = 0;
    protected int tbytes = 0;
    protected int pbytes = 0;
    private static Pattern _number = null;
    private static Pattern _zero = null;
    protected static Pattern _number2 = null;

    public ByteSize(BigInteger size) {
        if (size == null) {
            throw new IllegalArgumentException("size==null");
        }
        int s = size.signum();
        if (s == 0) {
            this.sign = 1;
            this.bytes = 0;
            this.kbytes = 0;
            this.mbytes = 0;
            this.gbytes = 0;
            this.tbytes = 0;
            this.pbytes = 0;
            return;
        }
        if (s < 0) {
            this.sign = -1;
            size = size.negate();
        } else {
            this.sign = 1;
        }
        BigInteger k = BigInteger.valueOf(1024L);
        BigInteger[] dd = size.divideAndRemainder(k);
        this.bytes = dd[1].intValue();
        size = dd[0];
        dd = size.divideAndRemainder(k);
        this.kbytes = dd[1].intValue();
        size = dd[0];
        dd = size.divideAndRemainder(k);
        this.mbytes = dd[1].intValue();
        size = dd[0];
        dd = size.divideAndRemainder(k);
        this.gbytes = dd[1].intValue();
        size = dd[0];
        dd = size.divideAndRemainder(k);
        this.tbytes = dd[1].intValue();
        size = dd[0];
        this.pbytes = size.intValue();
    }

    public ByteSize(long size) {
        this.sign = 1;
        if (size < 0L) {
            this.sign = -1;
            size = -size;
        }
        long b = size % 1024L;
        long kb = (size /= 1024L) % 1024L;
        long mb = (size /= 1024L) % 1024L;
        long gb = (size /= 1024L) % 1024L;
        long tb = (size /= 1024L) % 1024L;
        long pb = size /= 1024L;
        this.bytes = (int)b;
        this.kbytes = (int)kb;
        this.mbytes = (int)mb;
        this.gbytes = (int)gb;
        this.tbytes = (int)tb;
        this.pbytes = (int)pb;
    }

    protected static Pattern number() {
        if (_number != null) {
            return _number;
        }
        _number = Pattern.compile("(?is)\\s*(-|\\+)?\\s*(\\d+)\\s*");
        return _number;
    }

    protected static Pattern zero() {
        if (_zero != null) {
            return _zero;
        }
        _zero = Pattern.compile("(?is)\\s*(-|\\+)?\\s*0\\s*");
        return _zero;
    }

    protected static Pattern number2() {
        if (_number2 != null) {
            return _number2;
        }
        _number2 = Pattern.compile("(?is)\\s*(-|\\+)?(\\s*(\\d+)(\\.(\\d+))?\\s*(b|kb|mb|gb|tb|pb|k|m|g|t|p)?)(\\s*(\\d+)(\\.(\\d+))?\\s*(b|kb|mb|gb|tb|pb|k|m|g|t|p)?)?(\\s*(\\d+)(\\.(\\d+))?\\s*(b|kb|mb|gb|tb|pb|k|m|g|t|p)?)?(\\s*(\\d+)(\\.(\\d+))?\\s*(b|kb|mb|gb|tb|pb|k|m|g|t|p)?)?(\\s*(\\d+)(\\.(\\d+))?\\s*(b|kb|mb|gb|tb|pb|k|m|g|t|p)?)?(\\s*(\\d+)(\\.(\\d+))?\\s*(b|kb|mb|gb|tb|pb|k|m|g|t|p)?)?");
        return _number2;
    }

    private static long parse(Matcher m, int intPartGroup, int floatPartGroup, int suffixGroup) {
        long intNum;
        long b = 1L;
        long kb = 1024L;
        long mb = 0x100000L;
        long gb = 0x40000000L;
        long tb = 0L;
        long pb = 0L;
        String intNumStr = m.group(intPartGroup);
        String floatNumStr = m.group(floatPartGroup);
        String suffix = m.group(suffixGroup);
        long l = intNum = intNumStr == null ? 0L : Long.parseLong(intNumStr);
        long k = suffix != null ? (suffix.toLowerCase().startsWith("b") ? b : (suffix.toLowerCase().startsWith("k") ? kb : (suffix.toLowerCase().startsWith("m") ? mb : (suffix.toLowerCase().startsWith("g") ? gb : (suffix.toLowerCase().startsWith("t") ? tb : (suffix.toLowerCase().startsWith("p") ? pb : 0L)))))) : b;
        long kf = floatNumStr == null ? 1L : Long.parseLong("1" + Text.repeat((String)"0", (int)floatNumStr.length()));
        long floatNum = floatNumStr == null ? 0L : k * Long.parseLong(floatNumStr) / kf;
        long sum = intNum * k + floatNum;
        return sum;
    }

    public static ByteSize parse(String text) {
        if (text == null) {
            throw new IllegalArgumentException("text==null");
        }
        Matcher mZero = ByteSize.zero().matcher(text);
        if (mZero.matches()) {
            return new ByteSize(0L);
        }
        Matcher mNum = ByteSize.number().matcher(text);
        if (mNum.matches()) {
            String signStr = mNum.group(1);
            String numStr = mNum.group(2);
            long sign = 1L;
            if (signStr != null && signStr.equals("-")) {
                sign = -1L;
            }
            long num = Long.parseLong(numStr);
            return new ByteSize(sign * num);
        }
        Matcher m = ByteSize.number2().matcher(text);
        if (m.matches()) {
            String signStr = m.group(1);
            long sign = signStr != null && signStr.equals("-") ? -1L : 1L;
            long n1 = ByteSize.parse(m, 3, 5, 6);
            long n2 = ByteSize.parse(m, 8, 10, 11);
            long n3 = ByteSize.parse(m, 13, 15, 16);
            long n4 = ByteSize.parse(m, 18, 20, 21);
            long n5 = ByteSize.parse(m, 23, 25, 26);
            long n6 = ByteSize.parse(m, 28, 30, 31);
            long size = (n1 + n2 + n3 + n4 + n5 + n6) * sign;
            return new ByteSize(size);
        }
        return null;
    }

    public ByteSize add(ByteSize bs) {
        if (bs == null) {
            throw new IllegalArgumentException("bs==null");
        }
        if (this.sign == bs.sign) {
            int s_b = this.bytes + bs.bytes;
            int a_kb = s_b / 1024;
            int b = s_b % 1024;
            int s_kb = this.kbytes + bs.kbytes + a_kb;
            int a_mb = s_kb / 1024;
            int kb = s_kb % 1024;
            int s_mb = this.mbytes + bs.mbytes + a_mb;
            int a_gb = s_mb / 1024;
            int mb = s_mb % 1024;
            int s_gb = this.gbytes + bs.gbytes + a_gb;
            int a_tb = s_gb / 1024;
            int gb = s_gb % 1024;
            int s_tb = this.tbytes + bs.tbytes + a_tb;
            int a_pb = s_tb / 1024;
            int tb = s_tb % 1024;
            int s_pb = this.pbytes + bs.pbytes + a_pb;
            ByteSize r = new ByteSize(0L);
            r.sign = this.sign;
            r.bytes = b;
            r.kbytes = kb;
            r.mbytes = mb;
            r.gbytes = gb;
            r.tbytes = tb;
            r.pbytes = s_pb;
            return r;
        }
        BigInteger o2 = bs.getSize();
        if (bs.sign < 0) {
            o2 = o2.negate();
        }
        BigInteger o1 = this.getSize();
        if (this.sign < 0) {
            o1 = o1.negate();
        }
        int sgn = 1;
        BigInteger s = null;
        if (o1.compareTo(o2) < 0) {
            s = o2.subtract(o1);
            if (bs.sign < 0) {
                sgn = -1;
            }
        } else {
            s = o1.subtract(o2);
            if (this.sign < 0) {
                sgn = -1;
            }
        }
        if (sgn < 0) {
            s = s.negate();
        }
        return new ByteSize(s);
    }

    public BigInteger getSize() {
        BigInteger b = BigInteger.valueOf(this.bytes);
        BigInteger ko = BigInteger.valueOf(1024L);
        BigInteger kb1 = BigInteger.valueOf(1024L);
        BigInteger kb = BigInteger.valueOf(this.kbytes);
        kb = kb.multiply(ko);
        BigInteger mb = BigInteger.valueOf(this.mbytes);
        ko = BigInteger.valueOf(0x100000L);
        mb = mb.multiply(ko);
        BigInteger gb = BigInteger.valueOf(this.gbytes);
        ko = kb1.multiply(kb1.multiply(kb1));
        gb = gb.multiply(ko);
        BigInteger tb = BigInteger.valueOf(this.tbytes);
        ko = kb1.multiply(kb1.multiply(kb1.multiply(kb1)));
        tb = tb.multiply(ko);
        BigInteger pb = BigInteger.valueOf(this.pbytes);
        ko = kb1.multiply(kb1.multiply(kb1.multiply(kb1.multiply(kb1))));
        pb = pb.multiply(ko);
        BigInteger _sign = BigInteger.valueOf(this.sign);
        BigInteger summ = BigInteger.ZERO;
        summ = summ.add(b);
        summ = summ.add(kb);
        summ = summ.add(mb);
        summ = summ.add(gb);
        summ = summ.add(tb);
        summ = summ.add(pb);
        summ = summ.multiply(_sign);
        return summ;
    }

    public int getSign() {
        return this.sign;
    }

    public int getNameSize(ByteName name) {
        if (name == null) {
            throw new IllegalArgumentException("name==null");
        }
        switch (name) {
            case Byte: {
                return this.bytes;
            }
            case KiloByte: {
                return this.kbytes;
            }
            case MegaByte: {
                return this.mbytes;
            }
            case GigaByte: {
                return this.gbytes;
            }
            case TeraByte: {
                return this.tbytes;
            }
            case PetaByte: {
                return this.pbytes;
            }
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteSize other = (ByteSize)obj;
        if (this.sign != other.sign) {
            return false;
        }
        if (this.bytes != other.bytes) {
            return false;
        }
        if (this.kbytes != other.kbytes) {
            return false;
        }
        if (this.mbytes != other.mbytes) {
            return false;
        }
        if (this.gbytes != other.gbytes) {
            return false;
        }
        if (this.tbytes != other.tbytes) {
            return false;
        }
        return this.pbytes == other.pbytes;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + this.sign;
        hash = 89 * hash + this.bytes;
        hash = 89 * hash + this.kbytes;
        hash = 89 * hash + this.mbytes;
        hash = 89 * hash + this.gbytes;
        hash = 89 * hash + this.tbytes;
        hash = 89 * hash + this.pbytes;
        return hash;
    }

    public boolean isZero() {
        boolean isZero = this.bytes == 0 && this.kbytes == 0 && this.mbytes == 0 && this.gbytes == 0 && this.tbytes == 0 && this.pbytes == 0;
        return isZero;
    }

    @Override
    public int compareTo(ByteSize bc) {
        int cpb;
        int ctb;
        int cgb;
        int cmb;
        int ckb;
        int cb;
        int csign;
        if (bc == null) {
            throw new IllegalArgumentException("bc==null");
        }
        boolean isZero1 = this.isZero();
        boolean isZero2 = bc.isZero();
        if (isZero1 && isZero2) {
            return 0;
        }
        int n = this.sign < 0 && bc.sign > 0 ? -1 : (csign = this.sign > 0 && bc.sign < 0 ? 1 : 0);
        int n2 = this.bytes < bc.bytes ? -1 : (cb = this.bytes > bc.bytes ? 1 : 0);
        int n3 = this.kbytes < bc.kbytes ? -1 : (ckb = this.kbytes > bc.kbytes ? 1 : 0);
        int n4 = this.mbytes < bc.mbytes ? -1 : (cmb = this.mbytes > bc.mbytes ? 1 : 0);
        int n5 = this.gbytes < bc.gbytes ? -1 : (cgb = this.gbytes > bc.gbytes ? 1 : 0);
        int n6 = this.tbytes < bc.tbytes ? -1 : (ctb = this.tbytes > bc.tbytes ? 1 : 0);
        int n7 = this.pbytes < bc.pbytes ? -1 : (cpb = this.pbytes > bc.pbytes ? 1 : 0);
        if (csign != 0) {
            return csign;
        }
        if (cpb != 0) {
            return cpb;
        }
        if (ctb != 0) {
            return ctb;
        }
        if (cgb != 0) {
            return cgb;
        }
        if (cmb != 0) {
            return cmb;
        }
        if (ckb != 0) {
            return ckb;
        }
        return cb;
    }

    public String toString() {
        if (this.isZero()) {
            return "0";
        }
        StringBuilder sb = new StringBuilder();
        if (this.sign < 0) {
            sb.append("-");
        }
        int c = 0;
        if (this.pbytes > 0) {
            ++c;
            sb.append(this.getNameSize(ByteName.PetaByte));
            sb.append(ByteName.PetaByte.getSuffix());
        }
        if (this.tbytes > 0) {
            if (c > 0) {
                sb.append(" ");
            }
            ++c;
            sb.append(this.getNameSize(ByteName.TeraByte));
            sb.append(ByteName.TeraByte.getSuffix());
        }
        if (this.gbytes > 0) {
            if (c > 0) {
                sb.append(" ");
            }
            ++c;
            sb.append(this.getNameSize(ByteName.GigaByte));
            sb.append(ByteName.GigaByte.getSuffix());
        }
        if (this.mbytes > 0) {
            if (c > 0) {
                sb.append(" ");
            }
            ++c;
            sb.append(this.getNameSize(ByteName.MegaByte));
            sb.append(ByteName.MegaByte.getSuffix());
        }
        if (this.kbytes > 0) {
            if (c > 0) {
                sb.append(" ");
            }
            ++c;
            sb.append(this.getNameSize(ByteName.KiloByte));
            sb.append(ByteName.KiloByte.getSuffix());
        }
        if (this.bytes > 0) {
            if (c > 0) {
                sb.append(" ");
            }
            ++c;
            sb.append(this.getNameSize(ByteName.Byte));
            sb.append(ByteName.Byte.getSuffix());
        }
        return sb.toString();
    }

    public String toStringRoundMin() {
        StringBuilder sb = new StringBuilder();
        if (this.isZero()) {
            return "0";
        }
        if (this.sign < 0) {
            sb.append("-");
        }
        if (this.pbytes > 0) {
            sb.append(this.getNameSize(ByteName.PetaByte));
            sb.append(ByteName.PetaByte.getSuffix());
            return sb.toString();
        }
        if (this.tbytes > 0) {
            sb.append(this.getNameSize(ByteName.TeraByte));
            sb.append(ByteName.TeraByte.getSuffix());
            return sb.toString();
        }
        if (this.gbytes > 0) {
            sb.append(this.getNameSize(ByteName.GigaByte));
            sb.append(ByteName.GigaByte.getSuffix());
            return sb.toString();
        }
        if (this.mbytes > 0) {
            sb.append(this.getNameSize(ByteName.MegaByte));
            sb.append(ByteName.MegaByte.getSuffix());
            return sb.toString();
        }
        if (this.kbytes > 0) {
            sb.append(this.getNameSize(ByteName.KiloByte));
            sb.append(ByteName.KiloByte.getSuffix());
            return sb.toString();
        }
        if (this.bytes > 0) {
            sb.append(this.getNameSize(ByteName.Byte));
            sb.append(ByteName.Byte.getSuffix());
            return sb.toString();
        }
        return sb.toString();
    }

    public static String toStringRoundMin(long size, int digitAfterPoint) {
        return new ByteSize(size).toStringRoundMin(digitAfterPoint);
    }

    public String toStringRoundMin(int digitAfterPoint) {
        Options opts = new Options();
        opts.setDigitAfterPoint(digitAfterPoint);
        return this.toString(opts);
    }

    private static boolean isZero(String txt) {
        if (txt == null) {
            return false;
        }
        if (txt.length() == 0) {
            return false;
        }
        for (int i = 0; i < txt.length(); ++i) {
            char c = txt.charAt(i);
            if (c == '0') continue;
            return false;
        }
        return true;
    }

    public String toString(Options opts) {
        if (opts == null) {
            opts = new Options();
        }
        if (!opts.isApproxData()) {
            if (this.isZero()) {
                return "0";
            }
            StringBuilder sb = new StringBuilder();
            if (this.sign < 0) {
                sb.append("-");
            }
            int c = 0;
            if (this.pbytes > 0) {
                ++c;
                sb.append(this.getNameSize(ByteName.PetaByte));
                sb.append(opts.getPetaByteSuffix());
            }
            if (this.tbytes > 0) {
                if (c > 0) {
                    sb.append(opts.getSplitter());
                }
                ++c;
                sb.append(this.getNameSize(ByteName.TeraByte));
                sb.append(opts.getTeraByteSuffix());
            }
            if (this.gbytes > 0) {
                if (c > 0) {
                    sb.append(opts.getSplitter());
                }
                ++c;
                sb.append(this.getNameSize(ByteName.GigaByte));
                sb.append(opts.getGigaByteSuffix());
            }
            if (this.mbytes > 0) {
                if (c > 0) {
                    sb.append(opts.getSplitter());
                }
                ++c;
                sb.append(this.getNameSize(ByteName.MegaByte));
                sb.append(opts.getMegaByteSuffix());
            }
            if (this.kbytes > 0) {
                if (c > 0) {
                    sb.append(opts.getSplitter());
                }
                ++c;
                sb.append(this.getNameSize(ByteName.KiloByte));
                sb.append(opts.getKiloByteSuffix());
            }
            if (this.bytes > 0) {
                if (c > 0) {
                    sb.append(opts.getSplitter());
                }
                ++c;
                sb.append(this.getNameSize(ByteName.Byte));
                sb.append(opts.getByteSuffix());
            }
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        if (this.isZero()) {
            if (opts.getDigitAfterPoint() > 0 && opts.isShowZeroFloat()) {
                return "0." + Text.repeat((String)"0", (int)opts.getDigitAfterPoint());
            }
            return "0";
        }
        if (this.sign < 0) {
            sb.append("-");
        }
        if (this.pbytes > 0) {
            sb.append(this.getNameSize(ByteName.PetaByte));
            if (opts.getDigitAfterPoint() > 0) {
                long n = 1024 * this.tbytes + this.gbytes;
                long r = 0x100000L;
                double f = (double)n / (double)r;
                String fs = String.format("%0$f", f).replace(",", ".").replace("0.", "");
                if (fs.length() > opts.getDigitAfterPoint()) {
                    fs = fs.substring(0, opts.getDigitAfterPoint());
                } else if (fs.length() < opts.getDigitAfterPoint()) {
                    fs = fs + Text.repeat((String)"0", (int)(opts.getDigitAfterPoint() - fs.length()));
                }
                if (opts.isShowZeroFloat()) {
                    sb.append(opts.getFloatPoint());
                    sb.append(fs);
                } else if (!ByteSize.isZero(fs)) {
                    sb.append(opts.getFloatPoint());
                    sb.append(fs);
                }
            }
            sb.append(opts.getPetaByteSuffix());
            return sb.toString();
        }
        if (this.tbytes > 0) {
            sb.append(this.getNameSize(ByteName.TeraByte));
            if (opts.getDigitAfterPoint() > 0) {
                long n = 1024 * this.gbytes + this.mbytes;
                long r = 0x100000L;
                double f = (double)n / (double)r;
                String fs = String.format("%0$f", f).replace(",", ".").replace("0.", "");
                if (fs.length() > opts.getDigitAfterPoint()) {
                    fs = fs.substring(0, opts.getDigitAfterPoint());
                } else if (fs.length() < opts.getDigitAfterPoint()) {
                    fs = fs + Text.repeat((String)"0", (int)(opts.getDigitAfterPoint() - fs.length()));
                }
                if (opts.isShowZeroFloat()) {
                    sb.append(opts.getFloatPoint());
                    sb.append(fs);
                } else if (!ByteSize.isZero(fs)) {
                    sb.append(opts.getFloatPoint());
                    sb.append(fs);
                }
            }
            sb.append(opts.getTeraByteSuffix());
            return sb.toString();
        }
        if (this.gbytes > 0) {
            sb.append(this.getNameSize(ByteName.GigaByte));
            if (opts.getDigitAfterPoint() > 0) {
                long n = 1024 * this.mbytes + this.kbytes;
                long r = 0x100000L;
                double f = (double)n / (double)r;
                String fs = String.format("%0$f", f).replace(",", ".").replace("0.", "");
                if (fs.length() > opts.getDigitAfterPoint()) {
                    fs = fs.substring(0, opts.getDigitAfterPoint());
                } else if (fs.length() < opts.getDigitAfterPoint()) {
                    fs = fs + Text.repeat((String)"0", (int)(opts.getDigitAfterPoint() - fs.length()));
                }
                if (opts.isShowZeroFloat()) {
                    sb.append(opts.getFloatPoint());
                    sb.append(fs);
                } else if (!ByteSize.isZero(fs)) {
                    sb.append(opts.getFloatPoint());
                    sb.append(fs);
                }
            }
            sb.append(opts.getGigaByteSuffix());
            return sb.toString();
        }
        if (this.mbytes > 0) {
            sb.append(this.getNameSize(ByteName.MegaByte));
            if (opts.getDigitAfterPoint() > 0) {
                long n = 1024 * this.kbytes + this.bytes;
                long r = 0x100000L;
                double f = (double)n / (double)r;
                String fs = String.format("%0$f", f).replace(",", ".").replace("0.", "");
                if (fs.length() > opts.getDigitAfterPoint()) {
                    fs = fs.substring(0, opts.getDigitAfterPoint());
                } else if (fs.length() < opts.getDigitAfterPoint()) {
                    fs = fs + Text.repeat((String)"0", (int)(opts.getDigitAfterPoint() - fs.length()));
                }
                if (opts.isShowZeroFloat()) {
                    sb.append(opts.getFloatPoint());
                    sb.append(fs);
                } else if (!ByteSize.isZero(fs)) {
                    sb.append(opts.getFloatPoint());
                    sb.append(fs);
                }
            }
            sb.append(opts.getMegaByteSuffix());
            return sb.toString();
        }
        if (this.kbytes > 0) {
            sb.append(this.getNameSize(ByteName.KiloByte));
            if (opts.getDigitAfterPoint() > 0) {
                long n = this.bytes;
                long r = 1024L;
                double f = (double)n / (double)r;
                String fs = String.format("%0$f", f).replace(",", ".").replace("0.", "");
                if (fs.length() > opts.getDigitAfterPoint()) {
                    fs = fs.substring(0, opts.getDigitAfterPoint());
                } else if (fs.length() < opts.getDigitAfterPoint()) {
                    fs = fs + Text.repeat((String)"0", (int)(opts.getDigitAfterPoint() - fs.length()));
                }
                if (opts.isShowZeroFloat()) {
                    sb.append(opts.getFloatPoint());
                    sb.append(fs);
                } else if (!ByteSize.isZero(fs)) {
                    sb.append(opts.getFloatPoint());
                    sb.append(fs);
                }
            }
            sb.append(opts.getKiloByteSuffix());
            return sb.toString();
        }
        if (this.bytes > 0) {
            sb.append(this.getNameSize(ByteName.Byte));
            if (opts.getDigitAfterPoint() > 0 && opts.isShowZeroFloat()) {
                sb.append(opts.getFloatPoint());
                sb.append(Text.repeat((String)"0", (int)opts.getDigitAfterPoint()));
            }
            sb.append(opts.getByteSuffix());
            return sb.toString();
        }
        return sb.toString();
    }

    public static class Options {
        protected boolean approxData = true;
        protected int digitAfterPoint = 2;
        protected String petaByteSuffix = null;
        protected String teraByteSuffix = null;
        protected String gigaByteSuffix = null;
        protected String megaByteSuffix = null;
        protected String kiloByteSuffix = null;
        protected String byteSuffix = null;
        protected String splitter = " ";
        protected boolean showZeroFloat = false;
        protected String floatPoint = ".";

        public boolean isApproxData() {
            return this.approxData;
        }

        public void setApproxData(boolean approxData) {
            this.approxData = approxData;
        }

        public int getDigitAfterPoint() {
            return this.digitAfterPoint;
        }

        public void setDigitAfterPoint(int digitAfterPoint) {
            this.digitAfterPoint = digitAfterPoint;
        }

        public String getPetaByteSuffix() {
            if (this.petaByteSuffix == null) {
                this.petaByteSuffix = ByteName.PetaByte.getSuffix();
            }
            return this.petaByteSuffix;
        }

        public void setPetaByteSuffix(String petaByteSuffix) {
            this.petaByteSuffix = petaByteSuffix;
        }

        public String getTeraByteSuffix() {
            if (this.teraByteSuffix == null) {
                this.teraByteSuffix = ByteName.TeraByte.getSuffix();
            }
            return this.teraByteSuffix;
        }

        public void setTeraByteSuffix(String teraByteSuffix) {
            this.teraByteSuffix = teraByteSuffix;
        }

        public String getGigaByteSuffix() {
            if (this.gigaByteSuffix == null) {
                this.gigaByteSuffix = ByteName.GigaByte.getSuffix();
            }
            return this.gigaByteSuffix;
        }

        public void setGigaByteSuffix(String gigaByteSuffix) {
            this.gigaByteSuffix = gigaByteSuffix;
        }

        public String getMegaByteSuffix() {
            if (this.megaByteSuffix == null) {
                this.megaByteSuffix = ByteName.MegaByte.getSuffix();
            }
            return this.megaByteSuffix;
        }

        public void setMegaByteSuffix(String megaByteSuffix) {
            this.megaByteSuffix = megaByteSuffix;
        }

        public String getKiloByteSuffix() {
            if (this.kiloByteSuffix == null) {
                this.kiloByteSuffix = ByteName.KiloByte.getSuffix();
            }
            return this.kiloByteSuffix;
        }

        public void setKiloByteSuffix(String kiloByteSuffix) {
            this.kiloByteSuffix = kiloByteSuffix;
        }

        public String getByteSuffix() {
            if (this.byteSuffix == null) {
                this.byteSuffix = ByteName.Byte.getSuffix();
            }
            return this.byteSuffix;
        }

        public void setByteSuffix(String byteSuffix) {
            this.byteSuffix = byteSuffix;
        }

        public String getSplitter() {
            if (this.splitter == null) {
                this.splitter = " ";
            }
            return this.splitter;
        }

        public void setSplitter(String splitter) {
            this.splitter = splitter;
        }

        public boolean isShowZeroFloat() {
            return this.showZeroFloat;
        }

        public void setShowZeroFloat(boolean showZeroFloat) {
            this.showZeroFloat = showZeroFloat;
        }

        public String getFloatPoint() {
            if (this.floatPoint == null) {
                this.floatPoint = ".";
            }
            return this.floatPoint;
        }

        public void setFloatPoint(String floatPoint) {
            this.floatPoint = floatPoint;
        }
    }
}

