/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.layout;

import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.perspective.PerspectiveStation;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.PerspectivePlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderList;
import bibliothek.gui.dock.station.toolbar.layout.GridPlaceholderList;
import bibliothek.gui.dock.station.toolbar.layout.ModeledPlaceholderToolbarGrid;
import bibliothek.gui.dock.station.toolbar.layout.PerspectiveGridPlaceholderList;
import bibliothek.util.Path;
import java.util.HashSet;
import java.util.Set;

public class PerspectivePlaceholderToolbarGrid
extends ModeledPlaceholderToolbarGrid<PerspectiveDockable, PerspectiveStation, PerspectiveDockable> {
    public PerspectivePlaceholderToolbarGrid() {
        this.init();
    }

    @Override
    protected PlaceholderList<PerspectiveDockable, PerspectiveStation, PerspectiveDockable> createColumn() {
        return new PerspectivePlaceholderList();
    }

    @Override
    protected GridPlaceholderList<PerspectiveDockable, PerspectiveStation, PerspectiveDockable> createGrid() {
        return new PerspectiveGridPlaceholderList();
    }

    @Override
    protected Set<Path> getPlaceholders(PerspectiveDockable dockable) {
        HashSet<Path> result = new HashSet<Path>();
        this.fill(result, dockable);
        return result;
    }

    private void fill(Set<Path> placeholders, PerspectiveDockable dockable) {
        PerspectiveStation station;
        Path placeholder = dockable.getPlaceholder();
        if (placeholder != null) {
            placeholders.add(placeholder);
        }
        if ((station = dockable.asStation()) != null) {
            int n = station.getDockableCount();
            for (int i = 0; i < n; ++i) {
                this.fill(placeholders, station.getDockable(i));
            }
        }
    }

    public void replace(PerspectiveDockable oldDockable, PerspectiveDockable newDockable) {
        int column = this.getColumn(oldDockable);
        if (column == -1) {
            throw new IllegalArgumentException("oldDockable is not known to this grid");
        }
        PlaceholderList list = this.getColumn(column);
        int index = list.dockables().indexOf((Object)oldDockable);
        list.remove(index);
        list.dockables().add(index, (Object)newDockable);
    }

    @Override
    protected void fill(PerspectiveDockable dockable, ConvertedPlaceholderListItem item) {
        PerspectiveStation station;
        Path placeholder = dockable.getPlaceholder();
        if (placeholder != null) {
            item.putString("placeholder", placeholder.toString());
            item.setPlaceholder(placeholder);
        }
        if ((station = dockable.asStation()) != null) {
            item.setPlaceholderMap(station.getPlaceholders());
        }
    }
}

