/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.group;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.AbstractToolbarDockStation;
import bibliothek.gui.dock.ExpandableToolbarItemStrategy;
import bibliothek.gui.dock.ToolbarGroupDockStation;
import bibliothek.gui.dock.action.AbstractDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.event.DockActionSourceListener;
import bibliothek.gui.dock.station.toolbar.group.AbstractToolbarGroupActions;
import bibliothek.gui.dock.station.toolbar.group.ToolbarColumn;
import bibliothek.gui.dock.toolbar.expand.ExpandableToolbarItemStrategyListener;
import bibliothek.gui.dock.toolbar.expand.ExpandedState;
import bibliothek.gui.dock.toolbar.expand.SimpleExpandAction;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;

public abstract class ExpandToolbarGroupActions<P>
extends AbstractToolbarGroupActions<P, ExpandColumn> {
    private PropertyValue<ExpandableToolbarItemStrategy> strategy = new PropertyValue<ExpandableToolbarItemStrategy>(ExpandableToolbarItemStrategy.STRATEGY){

        protected void valueChanged(ExpandableToolbarItemStrategy oldValue, ExpandableToolbarItemStrategy newValue) {
            if (oldValue != null) {
                oldValue.removeExpandedListener(ExpandToolbarGroupActions.this.listener);
            }
            if (newValue != null) {
                newValue.addExpandedListener(ExpandToolbarGroupActions.this.listener);
            }
        }
    };
    private PropertyValue<Boolean> onConflictEnable = new PropertyValue<Boolean>(AbstractToolbarDockStation.ON_CONFLICT_ENABLE){

        protected void valueChanged(Boolean oldValue, Boolean newValue) {
            int n = ExpandToolbarGroupActions.this.getColumnCount();
            for (int i = 0; i < n; ++i) {
                ((ExpandColumn)ExpandToolbarGroupActions.this.getColumn(i)).source.update();
            }
        }
    };
    private ExpandableToolbarItemStrategyListener listener = new ExpandableToolbarItemStrategyListener(){

        @Override
        public void stretched(Dockable item) {
            ExpandToolbarGroupActions.this.update(item);
        }

        @Override
        public void shrunk(Dockable item) {
            ExpandToolbarGroupActions.this.update(item);
        }

        @Override
        public void expanded(Dockable item) {
            ExpandToolbarGroupActions.this.update(item);
        }

        @Override
        public void enablementChanged(Dockable item, ExpandedState state, boolean enabled) {
            ExpandToolbarGroupActions.this.update(item);
        }
    };
    private DockController controller;

    public ExpandToolbarGroupActions(DockController controller, ToolbarGroupDockStation station) {
        super(station);
        this.controller = controller;
        this.strategy.setProperties(controller);
        this.onConflictEnable.setProperties(controller);
    }

    public void destroy() {
        this.strategy.setProperties((DockController)null);
        this.onConflictEnable.setProperties((DockController)null);
    }

    @Override
    protected ExpandColumn createColumn(ToolbarColumn<Dockable, P> column) {
        return new ExpandColumn(column);
    }

    public ExpandableToolbarItemStrategy getStrategy() {
        return (ExpandableToolbarItemStrategy)this.strategy.getValue();
    }

    public void update(Dockable item) {
        ExpandColumn column = (ExpandColumn)this.getColumn(item);
        if (column != null) {
            column.source.update();
        }
    }

    private class ExpandSource
    extends AbstractDockActionSource {
        private ExpandColumn column;
        private SimpleExpandAction[] actions;

        public ExpandSource(ExpandColumn column) {
            this.column = column;
        }

        private void onAction(int index) {
            this.column.performAction(this.actions[index].getBehavior());
        }

        public void addDockActionSourceListener(DockActionSourceListener listener) {
            if (!this.hasListeners()) {
                this.findEnabledActions();
            }
            super.addDockActionSourceListener(listener);
        }

        private void findEnabledActions() {
            boolean[] canPerform = this.column.getEnabledStates();
            int enabledCount = 0;
            for (boolean can : canPerform) {
                if (!can) continue;
                ++enabledCount;
            }
            boolean canExpand = canPerform[ExpandedState.EXPANDED.ordinal()];
            boolean canShrink = canPerform[ExpandedState.SHRUNK.ordinal()];
            boolean canStretch = canPerform[ExpandedState.STRETCHED.ordinal()];
            int length = Math.max(0, enabledCount - 1);
            if (this.actions == null || this.actions.length != length) {
                SimpleExpandAction[] next = new SimpleExpandAction[length];
                if (this.actions != null) {
                    System.arraycopy(this.actions, 0, next, 0, Math.min(this.actions.length, next.length));
                }
                for (int i = 0; i < next.length; ++i) {
                    if (next[i] != null) continue;
                    next[i] = new SimpleExpandAction(ExpandToolbarGroupActions.this.controller, SimpleExpandAction.Action.LARGEST);
                    final int index = i;
                    next[i].addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ExpandSource.this.onAction(index);
                        }
                    });
                }
                this.actions = next;
            }
            ExpandedState state = this.column.getState();
            if (canExpand && canShrink && canStretch) {
                switch (state) {
                    case SHRUNK: {
                        this.actions[0].setBehavior(SimpleExpandAction.Action.LARGER);
                        this.actions[1].setBehavior(SimpleExpandAction.Action.LARGEST);
                        break;
                    }
                    case STRETCHED: {
                        this.actions[0].setBehavior(SimpleExpandAction.Action.SMALLER);
                        this.actions[1].setBehavior(SimpleExpandAction.Action.LARGER);
                        break;
                    }
                    case EXPANDED: {
                        this.actions[0].setBehavior(SimpleExpandAction.Action.SMALLEST);
                        this.actions[1].setBehavior(SimpleExpandAction.Action.SMALLER);
                    }
                }
            } else if (canShrink && (canExpand || canStretch)) {
                switch (state) {
                    case SHRUNK: {
                        this.actions[0].setBehavior(SimpleExpandAction.Action.LARGER);
                        break;
                    }
                    default: {
                        this.actions[0].setBehavior(SimpleExpandAction.Action.SMALLER);
                        break;
                    }
                }
            } else if (canStretch && canExpand) {
                switch (state) {
                    case EXPANDED: {
                        this.actions[0].setBehavior(SimpleExpandAction.Action.SMALLER);
                        break;
                    }
                    default: {
                        this.actions[0].setBehavior(SimpleExpandAction.Action.LARGER);
                    }
                }
            }
        }

        public void update() {
            if (this.hasListeners()) {
                int oldCount = this.getDockActionCount();
                this.findEnabledActions();
                int newCount = this.getDockActionCount();
                if (oldCount != newCount) {
                    if (oldCount > 0) {
                        this.fireRemoved(0, oldCount - 1);
                    }
                    this.findEnabledActions();
                    if (newCount > 0) {
                        this.fireAdded(0, newCount - 1);
                    }
                }
            }
        }

        public Iterator<DockAction> iterator() {
            return new Iterator<DockAction>(){
                private int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < ExpandSource.this.getDockActionCount();
                }

                @Override
                public DockAction next() {
                    return ExpandSource.this.getDockAction(this.index++);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public DockAction getDockAction(int index) {
            if (index < 0 || index >= this.getDockActionCount()) {
                throw new IllegalArgumentException("index out of bounds");
            }
            return this.actions[index];
        }

        public int getDockActionCount() {
            if (!this.hasListeners()) {
                this.findEnabledActions();
            }
            return this.actions.length;
        }

        public LocationHint getLocationHint() {
            return new LocationHint(LocationHint.INDIRECT_ACTION, LocationHint.RIGHT);
        }
    }

    protected class ExpandColumn
    extends AbstractToolbarGroupActions.Column {
        private ExpandSource source;

        public ExpandColumn(ToolbarColumn<Dockable, P> column) {
            super(null);
            this.source = new ExpandSource(this);
            this.init(column);
        }

        @Override
        protected DockActionSource createSource() {
            return this.source;
        }

        @Override
        protected void inserted(int index, P item) {
            this.source.update();
        }

        @Override
        protected void removed(int index, P item) {
            this.source.update();
        }

        @Override
        protected void removed() {
        }

        public void performAction(SimpleExpandAction.Action action) {
            ExpandedState next;
            boolean[] canPerform = this.getEnabledStates();
            ExpandedState current = this.getState();
            switch (action) {
                case LARGER: {
                    next = current.larger();
                    break;
                }
                case LARGEST: {
                    next = ExpandedState.EXPANDED;
                    break;
                }
                case SMALLER: {
                    next = current.smaller();
                    break;
                }
                case SMALLEST: {
                    next = ExpandedState.SHRUNK;
                    break;
                }
                default: {
                    throw new IllegalStateException("never happens");
                }
            }
            int attempts = canPerform.length;
            while (attempts > 0 && current != next && !canPerform[next.ordinal()]) {
                --attempts;
                switch (action) {
                    case LARGER: 
                    case SMALLEST: {
                        next = next.larger();
                        break;
                    }
                    case LARGEST: 
                    case SMALLER: {
                        next = next.smaller();
                    }
                }
            }
            if (current != next && canPerform[next.ordinal()]) {
                this.setState(next);
            }
        }

        public void setState(ExpandedState state) {
            ExpandableToolbarItemStrategy strategy = ExpandToolbarGroupActions.this.getStrategy();
            for (Dockable dockable : this.getDockables()) {
                strategy.setState(dockable, state);
            }
            this.source.update();
        }

        public ExpandedState getState() {
            ExpandableToolbarItemStrategy strategy;
            ToolbarColumn column = this.getColumn();
            ExpandedState result = null;
            if (column.getDockableCount() > 0 && (strategy = ExpandToolbarGroupActions.this.getStrategy()) != null) {
                int n = column.getDockableCount();
                for (int i = 0; i < n && result == null; ++i) {
                    result = strategy.getState(column.getDockable(i));
                }
            }
            if (result == null) {
                result = ExpandedState.SHRUNK;
            }
            return result;
        }

        public boolean[] getEnabledStates() {
            boolean[] canPerform = new boolean[ExpandedState.values().length];
            for (ExpandedState state : ExpandedState.values()) {
                canPerform[state.ordinal()] = this.isEnabled(state);
            }
            return canPerform;
        }

        private boolean isEnabled(ExpandedState state) {
            boolean hasEnabled = false;
            boolean hasDisabled = false;
            ExpandableToolbarItemStrategy strategy = ExpandToolbarGroupActions.this.getStrategy();
            if (strategy != null) {
                for (Dockable dockable : this.getDockables()) {
                    if (strategy.isEnabled(dockable, state)) {
                        hasEnabled = true;
                        continue;
                    }
                    hasDisabled = true;
                }
            }
            if (hasEnabled && hasDisabled) {
                return (Boolean)ExpandToolbarGroupActions.this.onConflictEnable.getValue();
            }
            return hasEnabled;
        }
    }
}

