/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar;

import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.themes.basic.BasicDockableDisplayer;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;

public class ToolbarLineBorder
implements Border {
    private BasicDockableDisplayer displayer;

    public ToolbarLineBorder(BasicDockableDisplayer displayer) {
        this.displayer = displayer;
    }

    private DockableDisplayer.Location hiddenSide() {
        if (this.displayer.getTitle() == null) {
            return null;
        }
        return this.displayer.getTitleLocation();
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        DockableDisplayer.Location hidden = this.hiddenSide();
        g.setColor(c.getForeground());
        if (hidden != DockableDisplayer.Location.BOTTOM) {
            g.drawLine(x, y + height - 1, x + width, y + height - 1);
        }
        if (hidden != DockableDisplayer.Location.TOP) {
            g.drawLine(x, y, x + width - 1, y);
        }
        if (hidden != DockableDisplayer.Location.LEFT) {
            g.drawLine(x, y, x, y + height - 1);
        }
        if (hidden != DockableDisplayer.Location.RIGHT) {
            g.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        Insets insets = new Insets(1, 1, 1, 1);
        DockableDisplayer.Location hidden = this.hiddenSide();
        if (hidden != null) {
            switch (hidden) {
                case BOTTOM: {
                    insets.bottom = 0;
                    break;
                }
                case TOP: {
                    insets.top = 0;
                    break;
                }
                case LEFT: {
                    insets.left = 0;
                    break;
                }
                case RIGHT: {
                    insets.right = 0;
                }
            }
        }
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

